/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.namespace.NamespaceConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.Text;

public class Namespaces
implements NamespaceConstants {
    private static final Map<String, String> ENCODED_URIS = Maps.newConcurrentMap();
    private static final boolean allowOtherWhitespaceChars = Boolean.getBoolean("oak.allowOtherWhitespaceChars");
    private static final boolean allowOtherControlChars = Boolean.getBoolean("oak.allowOtherControlChars");
    private static final boolean disallowNonASCIIWhitespaceChars = Boolean.getBoolean("oak.disallowNonASCIIWhitespaceChars");

    private Namespaces() {
    }

    public static void setupNamespaces(NodeBuilder system) {
        if (!system.hasChildNode("rep:namespaces")) {
            NodeBuilder namespaces = Namespaces.createStandardMappings(system);
            Namespaces.buildIndexNode(namespaces);
        }
    }

    public static NodeBuilder createStandardMappings(NodeBuilder system) {
        Preconditions.checkState((!system.hasChildNode("rep:namespaces") ? 1 : 0) != 0);
        NodeBuilder namespaces = system.setChildNode("rep:namespaces");
        namespaces.setProperty("jcr:primaryType", (Object)"rep:Unstructured", Type.NAME);
        namespaces.setProperty("jcr", (Object)"http://www.jcp.org/jcr/1.0");
        namespaces.setProperty("nt", (Object)"http://www.jcp.org/jcr/nt/1.0");
        namespaces.setProperty("mix", (Object)"http://www.jcp.org/jcr/mix/1.0");
        namespaces.setProperty("xml", (Object)"http://www.w3.org/XML/1998/namespace");
        namespaces.setProperty("sv", (Object)"http://www.jcp.org/jcr/sv/1.0");
        namespaces.setProperty("rep", (Object)"internal");
        namespaces.setProperty("oak", (Object)"http://jackrabbit.apache.org/oak/ns/1.0");
        return namespaces;
    }

    public static String addCustomMapping(NodeBuilder namespaces, String uri, String prefixHint) {
        for (PropertyState property : namespaces.getProperties()) {
            String prefix;
            if (property.getType() != Type.STRING || !Namespaces.isValidPrefix(prefix = property.getName()) || !uri.equals(property.getValue(Type.STRING))) continue;
            return prefix;
        }
        Object prefix = prefixHint;
        int iteration = 1;
        while (namespaces.hasProperty((String)prefix)) {
            prefix = prefixHint + ++iteration;
        }
        namespaces.setProperty((String)prefix, (Object)uri);
        return prefix;
    }

    public static void buildIndexNode(NodeBuilder namespaces) {
        HashSet prefixes = Sets.newHashSet((Object[])new String[]{""});
        HashSet uris = Sets.newHashSet((Object[])new String[]{""});
        Map<String, String> nsmap = Namespaces.collectNamespaces(namespaces.getProperties());
        prefixes.addAll(nsmap.keySet());
        uris.addAll(nsmap.values());
        NodeBuilder data = namespaces.setChildNode("rep:nsdata");
        data.setProperty("jcr:primaryType", (Object)"rep:Unstructured", Type.NAME);
        data.setProperty("rep:prefixes", (Object)prefixes, Type.STRINGS);
        data.setProperty("rep:uris", (Object)uris, Type.STRINGS);
        for (Map.Entry<String, String> e : nsmap.entrySet()) {
            data.setProperty(Namespaces.encodeUri(e.getValue()), (Object)e.getKey());
        }
    }

    private static Tree getNamespaceTree(Tree root) {
        return root.getChild("jcr:system").getChild("rep:namespaces");
    }

    public static Map<String, String> getNamespaceMap(Tree root) {
        Map<String, String> map = Namespaces.collectNamespaces(Namespaces.getNamespaceTree(root).getProperties());
        map.put("", "");
        return map;
    }

    static Map<String, String> collectNamespaces(Iterable<? extends PropertyState> properties) {
        HashMap map = Maps.newHashMap();
        for (PropertyState propertyState : properties) {
            String prefix = propertyState.getName();
            if (!Type.STRING.equals((Object)propertyState.getType()) || !Namespaces.isValidPrefix(prefix)) continue;
            map.put(prefix, (String)propertyState.getValue(Type.STRING));
        }
        return map;
    }

    public static String getNamespacePrefix(Tree root, String uri) {
        if (uri.isEmpty()) {
            return uri;
        }
        Tree nsdata = Namespaces.getNamespaceTree(root).getChild("rep:nsdata");
        PropertyState ps = nsdata.getProperty(Namespaces.encodeUri(uri));
        if (ps != null) {
            return (String)ps.getValue(Type.STRING);
        }
        return null;
    }

    public static String getNamespaceURI(Tree root, String prefix) {
        PropertyState property;
        if (prefix.isEmpty()) {
            return prefix;
        }
        if (Namespaces.isValidPrefix(prefix) && (property = Namespaces.getNamespaceTree(root).getProperty(prefix)) != null && property.getType() == Type.STRING) {
            return (String)property.getValue(Type.STRING);
        }
        return null;
    }

    public static String encodeUri(String uri) {
        String encoded = ENCODED_URIS.get(uri);
        if (encoded == null) {
            encoded = Text.escapeIllegalJcrChars((String)uri);
            if (ENCODED_URIS.size() > 1000) {
                ENCODED_URIS.clear();
            }
            ENCODED_URIS.put(uri, encoded);
        }
        return encoded;
    }

    public static boolean isValidPrefix(String prefix) {
        return prefix.indexOf(58) == -1;
    }

    public static boolean isValidLocalName(String local) {
        if (local.isEmpty() || ".".equals(local) || "..".equals(local)) {
            return false;
        }
        for (int i = 0; i < local.length(); ++i) {
            boolean spaceChar;
            char ch = local.charAt(i);
            if (disallowNonASCIIWhitespaceChars) {
                spaceChar = allowOtherWhitespaceChars ? Character.isSpaceChar(ch) : Character.isWhitespace(ch);
            } else {
                boolean bl = spaceChar = ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
            }
            if (spaceChar) {
                if (i == 0) {
                    return false;
                }
                if (i == local.length() - 1) {
                    return false;
                }
                if (ch == ' ') continue;
                return false;
            }
            if ("/:[]|*".indexOf(ch) != -1) {
                return false;
            }
            if (allowOtherControlChars || ch < '\u0000' || ch >= ' ' || ch == '\t' || ch == '\n' || ch == '\r') continue;
            return false;
        }
        return true;
    }
}

