/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class AsyncLaneSwitcher {
    static final String ASYNC_PREVIOUS = "async-previous";
    static final String ASYNC_PREVIOUS_NONE = "none";
    private static final String TEMP_LANE_PREFIX = "temp-";

    public static void switchLane(NodeBuilder idxBuilder, String laneName) {
        PropertyState currentAsyncState = idxBuilder.getProperty("async");
        PropertyState newAsyncState = PropertyStates.createProperty((String)"async", (Object)laneName, (Type)Type.STRING);
        if (idxBuilder.hasProperty(ASYNC_PREVIOUS)) {
            return;
        }
        PropertyState previousAsyncState = currentAsyncState == null ? PropertyStates.createProperty((String)ASYNC_PREVIOUS, (Object)ASYNC_PREVIOUS_NONE) : AsyncLaneSwitcher.clone(ASYNC_PREVIOUS, currentAsyncState);
        idxBuilder.setProperty(previousAsyncState);
        idxBuilder.setProperty(newAsyncState);
    }

    public static boolean isLaneSwitched(NodeBuilder idxBuilder) {
        return idxBuilder.hasProperty(ASYNC_PREVIOUS);
    }

    public static String getTempLaneName(String laneName) {
        return TEMP_LANE_PREFIX + laneName;
    }

    public static void revertSwitch(NodeBuilder idxBuilder, String indexPath) {
        PropertyState previousAsync = idxBuilder.getProperty(ASYNC_PREVIOUS);
        Preconditions.checkState((previousAsync != null ? 1 : 0) != 0, (String)"No previous async state property found for index [%s]", (Object)indexPath);
        if (AsyncLaneSwitcher.isNone(previousAsync)) {
            idxBuilder.removeProperty("async");
        } else {
            idxBuilder.setProperty(AsyncLaneSwitcher.clone("async", previousAsync));
        }
        idxBuilder.removeProperty(ASYNC_PREVIOUS);
        idxBuilder.setProperty("refresh", (Object)true);
    }

    public static boolean isNone(PropertyState previousAsync) {
        return !previousAsync.isArray() && ASYNC_PREVIOUS_NONE.equals(previousAsync.getValue(Type.STRING));
    }

    private static PropertyState clone(String newName, PropertyState currentAsyncState) {
        PropertyState clonedState = currentAsyncState.isArray() ? PropertyStates.createProperty((String)newName, (Object)currentAsyncState.getValue(Type.STRINGS), (Type)Type.STRINGS) : PropertyStates.createProperty((String)newName, (Object)currentAsyncState.getValue(Type.STRING), (Type)Type.STRING);
        return clonedState;
    }
}

