/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.registration.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.jcr.Repository;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerAdapterFactory;
import org.apache.sling.jcr.registration.AbstractRegistrationSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, name="org.apache.sling.jcr.jackrabbit.server.RmiRegistrationSupport", property={"service.vendor=The Apache Software Foundation", "service.description=RMI based Repository Registration"}, reference={@Reference(name="Repository", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, service=Repository.class), @Reference(name="Log", policy=ReferencePolicy.DYNAMIC, bind="bindLog", unbind="unbindLog", cardinality=ReferenceCardinality.OPTIONAL, service=LogService.class)})
@Designate(ocd=Configuration.class)
public class RmiRegistrationSupport
extends AbstractRegistrationSupport {
    public static final String PROP_REGISTRY_PORT = "port";
    private int registryPort;
    private Registry registry;
    private boolean registryIsPrivate;

    @Override
    protected boolean doActivate() {
        Object portProp = this.getComponentContext().getProperties().get(PROP_REGISTRY_PORT);
        if (portProp instanceof Number) {
            this.registryPort = ((Number)portProp).intValue();
        } else {
            try {
                this.registryPort = Integer.parseInt(String.valueOf(portProp));
            }
            catch (NumberFormatException nfe) {
                this.registryPort = 0;
            }
        }
        if (this.registryPort < 0) {
            this.log(2, "RMI registry disabled (no or negative RMI port configured)", null);
            return false;
        }
        if (this.registryPort == 0) {
            this.registryPort = 1099;
        } else if (this.registryPort == 0 || this.registryPort > 65535) {
            this.log(2, "Illegal RMI registry port number " + this.registryPort + ", disabling RMI registry", null);
            return false;
        }
        this.log(3, "Using RMI Registry port " + this.registryPort, null);
        return true;
    }

    @Override
    protected void doDeactivate() {
        if (this.registry != null && this.registryIsPrivate) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
                this.log(3, "Unexported private RMI Registry at " + this.registryPort, null);
            }
            catch (NoSuchObjectException nsoe) {
                this.log(3, "Cannot unexport private RMI Registry reference", nsoe);
            }
        }
        this.registry = null;
    }

    @Override
    protected Object bindRepository(String name, Repository repository) {
        return new RmiRegistration(name, repository);
    }

    @Override
    protected void unbindRepository(String name, Object data) {
        RmiRegistration rr = (RmiRegistration)data;
        rr.unregister();
    }

    private Registry getPrivateRegistry() {
        if (this.registry == null) {
            try {
                this.registry = LocateRegistry.createRegistry(this.registryPort);
                this.registryIsPrivate = true;
                this.log(3, "Using private RMI Registry at " + this.registryPort, null);
            }
            catch (RemoteException re) {
                this.log(3, "Cannot create private registry, trying existing registry at " + this.registryPort + ", reason: " + re.toString(), null);
                try {
                    this.registry = LocateRegistry.getRegistry(this.registryPort);
                    this.registryIsPrivate = false;
                    this.log(3, "Trying existing registry at " + this.registryPort, null);
                }
                catch (RemoteException pre) {
                    this.log(1, "Cannot get existing registry, will not register repositories on RMI", pre);
                }
            }
        }
        return this.registry;
    }

    protected RemoteAdapterFactory getRemoteAdapterFactory() {
        return new ServerAdapterFactory();
    }

    @Override
    protected void bindLog(LogService log) {
        super.bindLog(log);
    }

    @Override
    protected void unbindLog(LogService log) {
        super.unbindLog(log);
    }

    private class RmiRegistration {
        private String rmiName;
        private Remote rmiRepository;

        RmiRegistration(String rmiName, Repository repository) {
            this.register(rmiName, repository);
        }

        public String getRmiName() {
            return this.rmiName;
        }

        public String getRmiURL() {
            String host;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (IOException ignore) {
                host = "localhost";
            }
            return "//" + host + ":" + RmiRegistrationSupport.this.registryPort + "/" + this.getRmiName();
        }

        private void register(String rmiName, Repository repository) {
            System.setProperty("java.rmi.server.useCodebaseOnly", "true");
            try {
                RemoteAdapterFactory raf = RmiRegistrationSupport.this.getRemoteAdapterFactory();
                this.rmiRepository = raf.getRemoteRepository(repository);
            }
            catch (RemoteException e) {
                RmiRegistrationSupport.this.log(1, "Unable to create remote repository.", e);
                return;
            }
            catch (Exception e) {
                RmiRegistrationSupport.this.log(1, "Unable to create RMI repository. jcr-rmi.jar might be missing.", e);
                return;
            }
            try {
                Registry registry = RmiRegistrationSupport.this.getPrivateRegistry();
                if (registry != null) {
                    registry.bind(rmiName, this.rmiRepository);
                    this.rmiName = rmiName;
                    RmiRegistrationSupport.this.log(3, "Repository bound to " + this.getRmiURL(), null);
                }
            }
            catch (NoSuchObjectException nsoe) {
                RmiRegistrationSupport.this.log(2, "Cannot contact RMI registry at " + RmiRegistrationSupport.this.registryPort + ", repository not registered", null);
            }
            catch (Exception e) {
                RmiRegistrationSupport.this.log(1, "Unable to bind repository via RMI.", e);
            }
        }

        public void unregister() {
            if (this.rmiName != null) {
                try {
                    RmiRegistrationSupport.this.getPrivateRegistry().unbind(this.rmiName);
                    RmiRegistrationSupport.this.log(3, "Repository unbound from " + this.getRmiURL(), null);
                }
                catch (Exception e) {
                    RmiRegistrationSupport.this.log(1, "Error while unbinding repository from JNDI: " + e, null);
                }
            }
            if (this.rmiRepository != null) {
                try {
                    UnicastRemoteObject.unexportObject(this.rmiRepository, true);
                }
                catch (NoSuchObjectException nsoe) {
                    RmiRegistrationSupport.this.log(3, "Cannot unexport remote Repository reference", nsoe);
                }
            }
        }
    }

    @ObjectClassDefinition(name="Apache Sling JCR Repository RMI Registrar", description="The RMI Registrar listens for embedded repositories  to be registered as services and registers them in an RMI registry under the  name specified in the \"name\" service property.")
    public static @interface Configuration {
        @AttributeDefinition(name="Port Number", description="Port number of the RMI registry to use. The RMI Registrar first tries to create a private RMI registry at this port. If this fails, an existing registry is tried to connect at this port on local host. If this number is negative, the RMI egistrar is disabled. If this number is higher than 65535, an error message is logged and the RMI Registrar is also  disabled. If this number is zero, the system default RMI Registry port 1099 is used.")
        public int port() default 1099;
    }
}

