/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.r2f.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.Prototype;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.diff.DiffRequest;
import org.apache.sling.feature.diff.FeatureDiff;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.r2f.RuntimeEnvironment2FeatureModel;
import org.apache.sling.feature.r2f.impl.Bundle2ArtifactMapper;
import org.apache.sling.feature.r2f.impl.OSGiConfiguration2FeatureConfigurationMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={RuntimeEnvironment2FeatureModel.class})
public class RuntimeEnvironment2FeatureModelService
implements RuntimeEnvironment2FeatureModel,
FeatureProvider {
    private static final String SLING_FEATURE_PROPERTY_NAME = "sling.feature";
    private static final String RUNNING_CLASSIFIER = "running";
    private static final String RUNTIME_CLASSIFIER = "runtime";
    private static final String PACKAGING_FEATURE = "slingosgifeature";
    protected BundleContext bundleContext;
    private Feature launchFeature;

    @Activate
    public void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        String launchFeatureLocation = bundleContext.getProperty(SLING_FEATURE_PROPERTY_NAME);
        if (launchFeatureLocation == null) {
            throw new IllegalStateException("Framework property 'sling.feature' is not set, impossible to assemble the launch Feature");
        }
        URI launchFeatureURI = URI.create(launchFeatureLocation);
        Path launchFeaturePath = Paths.get(launchFeatureURI);
        try (BufferedReader reader = Files.newBufferedReader(launchFeaturePath);){
            this.launchFeature = FeatureJSONReader.read((Reader)reader, (String)launchFeatureLocation);
        }
        catch (IOException cause) {
            throw new UncheckedIOException(cause);
        }
    }

    @Deactivate
    public void stop() {
        this.bundleContext = null;
        this.launchFeature = null;
    }

    @Override
    public Feature getLaunchFeature() {
        return this.launchFeature;
    }

    @Override
    public Feature getRunningFeature() {
        ConfigurationAdmin configurationAdmin;
        ServiceReference configurationAdminReference;
        Feature targetFeature = new Feature(this.newId(RUNNING_CLASSIFIER));
        Bundle[] bundles = this.bundleContext.getBundles();
        if (bundles != null) {
            Bundle2ArtifactMapper mapper = new Bundle2ArtifactMapper(targetFeature);
            Stream.of(bundles).map(mapper).forEach(mapper);
        }
        if ((configurationAdminReference = this.bundleContext.getServiceReference(ConfigurationAdmin.class)) != null && (configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(configurationAdminReference)) != null) {
            try {
                Configuration[] configurations = configurationAdmin.listConfigurations(null);
                if (configurations != null) {
                    OSGiConfiguration2FeatureConfigurationMapper mapper = new OSGiConfiguration2FeatureConfigurationMapper(targetFeature);
                    Stream.of(configurations).map(mapper).forEach(mapper);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Something went wrong while iterating over all available Configurations", e);
            }
        }
        return targetFeature;
    }

    @Override
    public Feature getLaunch2RunningUpgradingFeature() {
        Feature runningFeature = this.getRunningFeature();
        return FeatureDiff.compareFeatures((DiffRequest)new DiffRequest().setPrevious(this.launchFeature).setCurrent(runningFeature).addIncludeComparator("bundles").addIncludeComparator("configurations"));
    }

    @Override
    public Feature getRuntimeFeature() {
        Feature launch2RunningUpgradingFeature = this.getLaunch2RunningUpgradingFeature();
        Prototype prototype = launch2RunningUpgradingFeature.getPrototype();
        if (launch2RunningUpgradingFeature.getBundles().isEmpty() && launch2RunningUpgradingFeature.getConfigurations().isEmpty() && prototype.getBundleRemovals().isEmpty() && prototype.getConfigurationRemovals().isEmpty()) {
            return this.launchFeature;
        }
        ArtifactId runtimeId = this.newId(RUNTIME_CLASSIFIER);
        BuilderContext context = new BuilderContext((FeatureProvider)this);
        return FeatureBuilder.assemble((ArtifactId)runtimeId, (BuilderContext)context, (Feature[])new Feature[]{launch2RunningUpgradingFeature});
    }

    public Feature provide(ArtifactId id) {
        if (this.launchFeature.getId().equals((Object)id)) {
            return this.launchFeature;
        }
        return null;
    }

    private ArtifactId newId(String classifier) {
        String groupId = this.launchFeature.getId().getGroupId();
        String artifactId = this.launchFeature.getId().getArtifactId();
        String version = this.launchFeature.getId().getVersion();
        return new ArtifactId(groupId, artifactId, version, classifier, PACKAGING_FEATURE);
    }
}

