/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.r2f.impl;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Properties;
import java.util.function.Function;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.r2f.impl.AbstractFeatureElementConsumer;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleWiring;

final class Bundle2ArtifactMapper
extends AbstractFeatureElementConsumer<Artifact>
implements Function<Bundle, Artifact> {
    private static final String MAVEN_METADATA_PATH = "/META-INF/maven";
    private static final String POM_PROPERTIES_RESOURCE_NAME = "pom.properties";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String CLASSIFIER = "classifier";

    public Bundle2ArtifactMapper(Feature targetFeature) {
        super(targetFeature);
    }

    @Override
    public Artifact apply(Bundle bundle) {
        Properties pomProperties = new Properties();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        Collection pomPropertiesResources = bundleWiring.listResources(MAVEN_METADATA_PATH, POM_PROPERTIES_RESOURCE_NAME, 1);
        if (pomPropertiesResources == null || pomPropertiesResources.isEmpty()) {
            return null;
        }
        URL pomPropertiesURL = Bundle2ArtifactMapper.getPomPropertiesURL(pomPropertiesResources, bundle);
        if (pomPropertiesURL == null) {
            return null;
        }
        try {
            URLConnection connection = pomPropertiesURL.openConnection();
            connection.connect();
            try (InputStream inStream = connection.getInputStream();){
                pomProperties.load(inStream);
            }
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while reading " + pomPropertiesURL + " properties file from Bundle " + bundle.getSymbolicName(), t);
        }
        if (pomProperties.isEmpty()) {
            throw new RuntimeException("Bundle " + bundle.getSymbolicName() + " does not export valid Maven metadata");
        }
        String groupId = pomProperties.getProperty(GROUP_ID);
        String artifactId = pomProperties.getProperty(ARTIFACT_ID);
        String version = pomProperties.getProperty(VERSION);
        String classifier = pomProperties.getProperty(CLASSIFIER);
        Artifact artifact = new Artifact(new ArtifactId(groupId, artifactId, version, classifier, null));
        BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        int startOrder = bundleStartLevel.getStartLevel();
        artifact.setStartOrder(startOrder);
        return artifact;
    }

    private static URL getPomPropertiesURL(Collection<String> pomPropertiesResources, Bundle bundle) {
        for (String pomPropertiesResource : pomPropertiesResources) {
            URL pomPropertiesURL = bundle.getEntry(pomPropertiesResource);
            if (pomPropertiesURL == null) continue;
            return pomPropertiesURL;
        }
        return null;
    }

    @Override
    public void accept(Artifact artifact) {
        if (artifact != null) {
            this.getTargetFeature().getBundles().add(artifact);
        }
    }
}

