/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.servlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;
import org.apache.felix.hc.core.impl.servlet.HealthCheckExecutorServlet;
import org.apache.felix.hc.core.impl.servlet.ResultHtmlSerializerConfiguration;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={ResultHtmlSerializer.class})
public class ResultHtmlSerializer {
    private String styleString;

    @Activate
    protected final void activate(ResultHtmlSerializerConfiguration configuration) {
        this.styleString = configuration.styleString();
    }

    public String serialize(Result overallResult, List<HealthCheckExecutionResult> executionResults, List<HealthCheckExecutorServlet.Param> paramList, boolean includeDebug) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("<html><head><title>System Health</title><meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /><style>" + this.styleString + "</style></head><body><h1>System Health</h1>");
        writer.println("<p><span class=\"" + this.getClassForStatus(overallResult.getStatus()) + "\" style=\"padding:4px\"><strong>Overall Result: " + overallResult.getStatus() + "</strong></span></p>");
        SimpleDateFormat dfShort = new SimpleDateFormat("HH:mm:ss.SSS");
        SimpleDateFormat dfLong = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        writer.println("<table id=\"healthCheckResults\" cellspacing=\"0\">");
        writer.println("<thead><tr><th>Health Check <span style='color:gray'>(tags)</span></th><th>Status</th><th>Log</th><th>Finished At</th><th>Time</th></tr></thead>");
        for (HealthCheckExecutionResult executionResult : executionResults) {
            Result result = executionResult.getHealthCheckResult();
            List tags = executionResult.getHealthCheckMetadata().getTags();
            boolean hasTags = tags != null && tags.size() > 0 && StringUtils.isNotBlank((CharSequence)tags.get(0));
            writer.print("<tr class=\"" + this.getClassForStatus(result.getStatus()) + "\">");
            String tooltipHint = this.getTooltipHint(executionResult.getHealthCheckMetadata());
            writer.print("<td><p title=\"" + this.escapeHtml(tooltipHint) + "\">" + this.escapeHtml(executionResult.getHealthCheckMetadata().getTitle()) + "");
            if (hasTags) {
                writer.println("<br/><span style='color:gray'>" + this.escapeHtml(String.join((CharSequence)", ", tags)) + "</span>");
            }
            writer.println("</p></td>");
            writer.println("<td style='font-weight:bold;'>" + this.escapeHtml(result.getStatus().toString()) + "</td>");
            writer.println("<td>");
            boolean isFirst = true;
            boolean isSingleResult = this.isSingleResult(result);
            for (ResultLog.Entry entry : result) {
                if (!includeDebug && entry.isDebug()) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    writer.println("<br/>\n");
                }
                boolean showStatus = !isSingleResult && !entry.isDebug() && entry.getStatus() != Result.Status.OK;
                String message = this.escapeHtml(entry.getMessage());
                if (entry.isDebug()) {
                    message = "<span style='color:gray'/>" + message + "</span>";
                }
                writer.println((showStatus ? this.escapeHtml(entry.getStatus().toString()) + " " : "") + message);
                Exception exception = entry.getException();
                if (exception == null) continue;
                writer.println("<span style='width:20px'/>" + this.escapeHtml(exception.toString()));
                writer.println("<!--");
                exception.printStackTrace(writer);
                writer.println("-->");
            }
            writer.println("</td>");
            Date finishedAt = executionResult.getFinishedAt();
            writer.println("<td>" + (this.isToday(finishedAt) ? dfShort.format(finishedAt) : dfLong.format(finishedAt)) + "</td>");
            writer.println("<td>" + FormattingResultLog.msHumanReadable((long)executionResult.getElapsedTimeInMs()) + "</td>");
            writer.println("</tr>");
        }
        writer.println("</table>");
        writer.println("<div class='helpText'>");
        writer.println(this.getHtmlHelpText(paramList));
        writer.println("</div>");
        writer.println("</body></html>");
        return stringWriter.toString();
    }

    private String getTooltipHint(HealthCheckMetadata healthCheckMetadata) {
        Bundle bundle;
        ArrayList<String> hints = new ArrayList<String>();
        ServiceReference serviceReference = healthCheckMetadata.getServiceReference();
        Object compName = serviceReference.getProperty("component.name");
        if (compName != null) {
            hints.add("Component Name: " + compName);
        }
        if ((bundle = serviceReference.getBundle()) != null) {
            hints.add("Bundle: " + bundle.getSymbolicName());
        }
        return String.join((CharSequence)" ", hints);
    }

    private String getClassForStatus(Result.Status status) {
        return "status" + status.name();
    }

    private boolean isSingleResult(Result result) {
        int count = 0;
        for (ResultLog.Entry entry : result) {
            if (++count <= 1) continue;
            return false;
        }
        return true;
    }

    private boolean isToday(Date date) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date);
        boolean isToday = cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        return isToday;
    }

    private String getHtmlHelpText(List<HealthCheckExecutorServlet.Param> paramList) {
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>Supported URL parameters</h3>\n");
        for (HealthCheckExecutorServlet.Param p : paramList) {
            sb.append("<b>").append(p.name).append("</b>:");
            sb.append(this.escapeHtml(p.description));
            sb.append("<br/>");
        }
        return sb.toString();
    }

    private String escapeHtml(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

