/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.scheduling;

import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorThreadPool;
import org.apache.felix.hc.core.impl.scheduling.AsyncJob;
import org.apache.felix.hc.core.impl.scheduling.cron.embedded.AsyncEmbeddedCronJob;
import org.apache.felix.hc.core.impl.scheduling.cron.embedded.EmbeddedCronSchedulerProvider;
import org.apache.felix.hc.core.impl.scheduling.cron.quartz.AsyncQuartzCronJob;
import org.apache.felix.hc.core.impl.scheduling.cron.quartz.QuartzCronSchedulerProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CronJobFactory.class})
public class CronJobFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CronJobFactory.class);
    private static final String QUARTZ_PACKAGE_PREFIX = "org.quartz";
    @Reference
    private HealthCheckExecutorThreadPool healthCheckExecutorThreadPool;
    @Reference
    private QuartzCronSchedulerProvider quartzCronSchedulerProvider;
    @Reference
    private EmbeddedCronSchedulerProvider embeddedCronSchedulerProvider;
    boolean isQuartzAvailable;

    @Activate
    protected synchronized void activate(BundleContext bundleContext) {
        this.isQuartzAvailable = this.isQuartzAvailable(bundleContext);
        LOG.info("Quartz is " + (this.isQuartzAvailable ? "" : "NOT ") + "available for scheduling cron jobs");
    }

    public AsyncJob createAsyncCronJob(Runnable runnable, String id, String group, String cronExpression) {
        if (this.isQuartzAvailable) {
            return new AsyncQuartzCronJob(runnable, this.quartzCronSchedulerProvider, id, group, cronExpression);
        }
        return new AsyncEmbeddedCronJob(runnable, this.embeddedCronSchedulerProvider, id, cronExpression);
    }

    private boolean isQuartzAvailable(BundleContext bundleContext) {
        BundleWiring wiring = (BundleWiring)bundleContext.getBundle().adapt(BundleWiring.class);
        for (BundleWire wire : wiring.getRequiredWires("osgi.wiring.package")) {
            String pkg = (String)wire.getCapability().getAttributes().get("osgi.wiring.package");
            if (!pkg.startsWith(QUARTZ_PACKAGE_PREFIX)) continue;
            return true;
        }
        return false;
    }
}

