/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.executor.CombinedExecutionResult;
import org.apache.felix.hc.core.impl.executor.ExtendedHealthCheckExecutor;
import org.apache.felix.hc.core.impl.servlet.ResultTxtVerboseSerializer;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.servlet.context.ServletContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class ServiceUnavailableFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceUnavailableFilter.class);
    private static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_PLAIN = "text/plain";
    private static final String CACHE_CONTROL_KEY = "Cache-control";
    private static final String CACHE_CONTROL_VALUE = "no-cache";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String CONTEXT_NAME = "internal.http.serviceunavailablefilter";
    private static final String PROP_STARTUP_CONTEXT_SERVICE_RANKING = "avoid404DuringStartup.contextServiceRanking";
    private static final String PROP_STARTUP_SERVLET_SERVICE_RANKING = "avoid404DuringStartup.servletServiceRanking";
    private String[] tags;
    private Result.Status statusFor503;
    private String responseTextFor503;
    private boolean includeExecutionResultInResponse;
    private boolean autoDisableFilter;
    private boolean avoid404DuringStartup;
    @Reference
    private ExtendedHealthCheckExecutor executor;
    @Reference
    ResultTxtVerboseSerializer verboseTxtSerializer;
    private BundleContext bundleContext;
    private Dictionary<String, Object> compProperties;
    private ServiceListener healthCheckServiceListener;
    private volatile ServiceRegistration<Filter> filterServiceRegistration;
    private volatile ServiceRegistration<ServletContextHelper> httpContextRegistration;
    private volatile ServiceRegistration<Servlet> defaultServletRegistration;
    private volatile ServiceReference<HealthCheck>[] relevantHealthCheckServiceReferences;

    @Activate
    protected final void activate(BundleContext bundleContext, ComponentContext componentContext, Config config) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.compProperties = componentContext.getProperties();
        this.tags = config.tags();
        this.statusFor503 = config.statusFor503();
        this.responseTextFor503 = this.getResponseText(bundleContext, config.responseTextFor503());
        this.includeExecutionResultInResponse = config.includeExecutionResult();
        this.autoDisableFilter = config.autoDisableFilter();
        this.avoid404DuringStartup = config.avoid404DuringStartup();
        if (this.avoid404DuringStartup && !this.autoDisableFilter) {
            LOG.debug("For avoid404DuringStartup set to true, avoid404DuringStartup is forced to true as well");
            this.autoDisableFilter = true;
        }
        this.registerHealthCheckServiceListener();
        this.selectHcServiceReferences();
        this.registerFilter();
        LOG.info("ServiceUnavailableFilter active (start level {})", (Object)this.getCurrentStartLevel());
    }

    @Deactivate
    protected final void deactivate() {
        this.unregisterHealthCheckServiceListener();
        this.unregisterFilter();
        LOG.info("ServiceUnavailableFilter deactivated");
    }

    String getResponseText(BundleContext bundleContext, String responseFor503) {
        if (StringUtils.isBlank(responseFor503)) {
            responseFor503 = (String)this.compProperties.get("htmlFor503");
        }
        if (responseFor503 != null && responseFor503.startsWith(CLASSPATH_PREFIX)) {
            String[] bits = responseFor503.split(":");
            String symbolicName = bits[1];
            String pathInBundle = bits[2];
            Optional<Bundle> bundleOptional = Arrays.stream(bundleContext.getBundles()).filter(b -> b.getSymbolicName().equals(symbolicName)).findFirst();
            if (bundleOptional.isPresent()) {
                URL entryUrl = bundleOptional.get().getEntry(pathInBundle);
                if (entryUrl != null) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(entryUrl.openStream(), StandardCharsets.UTF_8));){
                        responseFor503 = reader.lines().collect(Collectors.joining("\n"));
                    }
                    catch (Exception e) {
                        responseFor503 = "503 Service Unavailable\n(Could not read '" + pathInBundle + "' from bundle '" + symbolicName + "': " + e + ")";
                    }
                } else {
                    responseFor503 = "503 Service Unavailable\n(Could not read '" + pathInBundle + "' from bundle '" + symbolicName + "': file not found)";
                }
            } else {
                responseFor503 = "503 Service Unavailable\n(Could not read '" + pathInBundle + "' from bundle '" + symbolicName + "': bundle not found)";
            }
        }
        return responseFor503;
    }

    private int getCurrentStartLevel() {
        return ((FrameworkStartLevel)this.bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class)).getStartLevel();
    }

    private synchronized void registerFilter() {
        if (this.filterServiceRegistration == null) {
            if (this.avoid404DuringStartup) {
                this.registerHttpContext();
            }
            this.filterServiceRegistration = this.bundleContext.registerService(Filter.class, (Object)this, this.compProperties);
            LOG.debug("Registered ServiceUnavailableFilter for tags {}", Arrays.asList(this.tags));
            if (this.autoDisableFilter) {
                new UnregisteringFilterThread();
                LOG.debug("Started UnregisteringFilterThread since autoDisableFilter=true");
            }
        }
    }

    private synchronized void unregisterFilter() {
        if (this.filterServiceRegistration != null) {
            this.filterServiceRegistration.unregister();
            this.filterServiceRegistration = null;
            LOG.debug("Filter ServiceUnavailableFilter for tags {} unregistered", Arrays.asList(this.tags));
            if (this.avoid404DuringStartup) {
                this.unregisterHttpContext();
            }
        }
    }

    private synchronized void selectHcServiceReferences() {
        LOG.debug("Reloading HC references for tags {}", Arrays.asList(this.tags));
        this.relevantHealthCheckServiceReferences = this.executor.selectHealthCheckReferences(HealthCheckSelector.tags((String[])this.tags), new HealthCheckExecutionOptions().setCombineTagsWithOr(true));
        LOG.debug("Found {} health check service references for tags {}", (Object)this.relevantHealthCheckServiceReferences.length, (Object)this.tags);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CombinedExecutionResult combinedExecutionResult = this.executeRelevantChecks(false);
        if (this.is503Result(combinedExecutionResult)) {
            Result overallResult = combinedExecutionResult.getHealthCheckResult();
            LOG.debug("Result for tags {} is {}, sending 503 for {}", new Object[]{this.tags, overallResult.getStatus(), ((HttpServletRequest)request).getRequestURI()});
            String verboseTxtResult = this.includeExecutionResultInResponse ? this.verboseTxtSerializer.serialize(overallResult, combinedExecutionResult.getExecutionResults(), false) : null;
            this.send503((HttpServletResponse)response, verboseTxtResult);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    private boolean is503Result(CombinedExecutionResult combinedExecutionResult) {
        return combinedExecutionResult.getHealthCheckResult().getStatus().ordinal() >= this.statusFor503.ordinal();
    }

    private CombinedExecutionResult executeRelevantChecks(boolean forceInstantExecution) {
        long startTimeNs = System.nanoTime();
        List<HealthCheckExecutionResult> executionResults = this.executor.execute(this.relevantHealthCheckServiceReferences, new HealthCheckExecutionOptions().setCombineTagsWithOr(true).setForceInstantExecution(forceInstantExecution));
        CombinedExecutionResult combinedExecutionResult = new CombinedExecutionResult(executionResults, Result.Status.TEMPORARILY_UNAVAILABLE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Time consumed for executing checks: {}ns", (Object)(System.nanoTime() - startTimeNs));
        }
        return combinedExecutionResult;
    }

    private void send503(HttpServletResponse response, String verboseTxtResult) throws IOException {
        if (this.avoid404DuringStartup && LOG.isDebugEnabled()) {
            LOG.debug("Sending 503 at start level {}", (Object)this.getCurrentStartLevel());
        }
        String responseContent = this.responseTextFor503;
        boolean isHtml = responseContent.contains("<html");
        String bodyClosingTag = "</body>";
        if (verboseTxtResult != null) {
            responseContent = isHtml ? responseContent.replace(bodyClosingTag, "<!--\n\n" + verboseTxtResult + "\n\n-->" + bodyClosingTag) : responseContent + "\n" + verboseTxtResult;
        }
        response.setStatus(503);
        response.setContentType(isHtml ? CONTENT_TYPE_HTML : CONTENT_TYPE_PLAIN);
        response.setHeader(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
        response.setCharacterEncoding("UTF-8");
        response.getWriter().append(responseContent);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private synchronized void registerHealthCheckServiceListener() throws InvalidSyntaxException {
        if (this.healthCheckServiceListener == null) {
            this.healthCheckServiceListener = new HealthCheckServiceListener();
            this.bundleContext.addServiceListener(this.healthCheckServiceListener, "(objectclass=" + HealthCheck.class.getName() + ")");
        }
    }

    private synchronized void unregisterHealthCheckServiceListener() {
        if (this.healthCheckServiceListener != null) {
            this.bundleContext.removeServiceListener(this.healthCheckServiceListener);
        }
    }

    private void registerHttpContext() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.http.whiteboard.context.name", CONTEXT_NAME);
        ((Dictionary)properties).put("osgi.http.whiteboard.context.path", "/");
        Object contextServiceRanking = this.compProperties.get(PROP_STARTUP_CONTEXT_SERVICE_RANKING);
        ((Dictionary)properties).put("service.ranking", contextServiceRanking != null ? contextServiceRanking : Integer.valueOf(Integer.MAX_VALUE));
        this.httpContextRegistration = this.bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, properties);
        Hashtable<String, Object> servletProps = new Hashtable<String, Object>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=internal.http.serviceunavailablefilter)");
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/");
        Object servletServiceRanking = this.compProperties.get(PROP_STARTUP_SERVLET_SERVICE_RANKING);
        ((Dictionary)servletProps).put("service.ranking", servletServiceRanking != null ? servletServiceRanking : Integer.valueOf(0));
        this.defaultServletRegistration = this.bundleContext.registerService(Servlet.class, (Object)new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                ServiceUnavailableFilter.this.send503(resp, "Service Unavailable");
            }
        }, servletProps);
    }

    private void unregisterHttpContext() {
        if (this.defaultServletRegistration != null) {
            this.defaultServletRegistration.unregister();
            this.defaultServletRegistration = null;
        }
        if (this.httpContextRegistration != null) {
            this.httpContextRegistration.unregister();
            this.httpContextRegistration = null;
        }
    }

    private final class BundleListenerForReregisteringFilter
    implements BundleListener {
        private final Logger LOG = LoggerFactory.getLogger(this.getClass());
        private final int startLevelWhenFilterUnregistered;

        public BundleListenerForReregisteringFilter(BundleContext bundleContext, int startLevelWhenFilterUnregistered) {
            this.startLevelWhenFilterUnregistered = startLevelWhenFilterUnregistered;
            this.LOG.debug("BundleListenerForReregisteringFilter registered");
            bundleContext.addBundleListener((BundleListener)this);
        }

        public void bundleChanged(BundleEvent event) {
            int currentStartLevel = ServiceUnavailableFilter.this.getCurrentStartLevel();
            if (currentStartLevel != this.startLevelWhenFilterUnregistered) {
                this.LOG.debug("Start level changed (current={} previous={}) - reregistering filter", (Object)currentStartLevel, (Object)this.startLevelWhenFilterUnregistered);
                ServiceUnavailableFilter.this.registerFilter();
                ServiceUnavailableFilter.this.bundleContext.removeBundleListener((BundleListener)this);
                this.LOG.debug("Removed self from BundleListeners");
            }
        }
    }

    public class UnregisteringFilterThread
    extends Thread {
        UnregisteringFilterThread() {
            this.setDaemon(true);
            this.setName("UnregisteringFilterThread for ServiceUnavailableFilter with tags " + Arrays.asList(ServiceUnavailableFilter.this.tags));
            this.start();
        }

        @Override
        public void run() {
            while (ServiceUnavailableFilter.this.autoDisableFilter && ServiceUnavailableFilter.this.filterServiceRegistration != null) {
                CombinedExecutionResult executionResult = ServiceUnavailableFilter.this.executeRelevantChecks(true);
                boolean is503Result = ServiceUnavailableFilter.this.is503Result(executionResult);
                if (!is503Result) {
                    ServiceUnavailableFilter.this.unregisterFilter();
                    int startLevelWhenFilterUnregistered = ServiceUnavailableFilter.this.getCurrentStartLevel();
                    LOG.debug("Unregistered filter ServiceUnavailableFilter for tags {} since result was ok at start level {}", Arrays.asList(ServiceUnavailableFilter.this.tags), (Object)startLevelWhenFilterUnregistered);
                    new BundleListenerForReregisteringFilter(ServiceUnavailableFilter.this.bundleContext, startLevelWhenFilterUnregistered);
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.debug("UnregisteringFilterThread for tags {} was interrupted", Arrays.asList(ServiceUnavailableFilter.this.tags));
                    break;
                }
            }
        }
    }

    private final class HealthCheckServiceListener
    implements ServiceListener {
        private HealthCheckServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            LOG.debug("Service Event for Health Check: {}", (Object)event.getType());
            ServiceUnavailableFilter.this.selectHcServiceReferences();
        }
    }

    @ObjectClassDefinition(name="Health Check Service Unavailable Filter", description="Returns a 503 Service Unavailable Page if configured tags are in non-ok result")
    public static @interface Config {
        public static final String RESPONSE_TEXT_DEFAULT = "<html><head><title>Service Unavailable</title><meta http-equiv=\"refresh\" content=\"5\"></head><body><strong>Service Unavailable</strong></body></html>";

        @AttributeDefinition(name="Filter Request Path RegEx", description="Regex to be matched against request path. Either use regex or pattern.")
        public String osgi_http_whiteboard_filter_regex();

        @AttributeDefinition(name="Filter Context", description="Needs to be set to correct whiteboard context filter (e.g. '(osgi.http.whiteboard.context.name=default)'")
        public String osgi_http_whiteboard_context_select() default "(osgi.http.whiteboard.context.name=*)";

        @AttributeDefinition(name="Tags", description="List of tags to query the status in order to decide if it is 503 or not")
        public String[] tags() default {};

        @AttributeDefinition(name="Status for 503 response", description="First status that causes a 503 response. The default TEMPORARILY_UNAVAILABLE will not send 503 for OK and WARN but for TEMPORARILY_UNAVAILABLE, CRITICAL and HEALTH_CHECK_ERROR")
        public Result.Status statusFor503() default Result.Status.TEMPORARILY_UNAVAILABLE;

        @AttributeDefinition(name="Include execution result in response", description="Will include the execution result in the response (as html comment for html case, otherwise as text).")
        public boolean includeExecutionResult() default false;

        @AttributeDefinition(name="503 Response Text", description="Response text for 503 responses. Value can be either the content directly or in the format 'classpath:<symbolic-bundle-id>:/path/to/file.html'. The response content type is auto-detected to either text/html or text/plain.")
        public String responseTextFor503() default "<html><head><title>Service Unavailable</title><meta http-equiv=\"refresh\" content=\"5\"></head><body><strong>Service Unavailable</strong></body></html>";

        @AttributeDefinition(name="Avoid 404", description="If true, will automatically register a dummy servlet to ensure this filter becomes effective. Useful for server startup scenarios.")
        public boolean avoid404DuringStartup() default true;

        @AttributeDefinition(name="Auto-disable filter", description="If true, will automatically disable the filter once the filter continued the filter chain without 503 for the first time. Useful for server startup scenarios. Becomes automatically active if avoid404DuringStartup is configured to true.")
        public boolean autoDisableFilter() default false;

        @AttributeDefinition(name="Filter Service Ranking", description="The service.ranking for the filter as respected by http whiteboard.")
        public int service_ranking() default 0x7FFFFFFF;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Send 503 for tags {tags} at status {statusFor503} (and worse) for path(s) {osgi.http.whiteboard.filter.regex}";
    }
}

