/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.executor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckExecutor;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.executor.ExecutionResult;
import org.apache.felix.hc.core.impl.executor.ExtendedHealthCheckExecutor;
import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorImplConfiguration;
import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorThreadPool;
import org.apache.felix.hc.core.impl.executor.HealthCheckFuture;
import org.apache.felix.hc.core.impl.executor.HealthCheckResultCache;
import org.apache.felix.hc.core.impl.executor.TempUnavailableGracePeriodEvaluator;
import org.apache.felix.hc.core.impl.executor.async.AsyncHealthCheckExecutor;
import org.apache.felix.hc.core.impl.util.HealthCheckFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheckExecutor.class, ExtendedHealthCheckExecutor.class}, immediate=true)
@Designate(ocd=HealthCheckExecutorImplConfiguration.class)
public class HealthCheckExecutorImpl
implements ExtendedHealthCheckExecutor,
ServiceListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String HC_LOGGING_SYS_PROP = "org.apache.felix.hc.autoLogging";
    private long timeoutInMs;
    private long longRunningFutureThresholdForRedMs;
    private long resultCacheTtlInMs;
    private String[] defaultTags;
    private HealthCheckResultCache healthCheckResultCache = new HealthCheckResultCache();
    private TempUnavailableGracePeriodEvaluator tempUnavailableGracePeriodEvaluator;
    private final Map<HealthCheckMetadata, HealthCheckFuture> stillRunningFutures = new HashMap<HealthCheckMetadata, HealthCheckFuture>();
    @Reference
    private AsyncHealthCheckExecutor asyncHealthCheckExecutor;
    @Reference
    HealthCheckExecutorThreadPool healthCheckExecutorThreadPool;
    private BundleContext bundleContext;

    @Activate
    protected final void activate(HealthCheckExecutorImplConfiguration configuration, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.configure(configuration);
        try {
            this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + HealthCheck.class.getName() + ")");
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException("Unexpected problem with filter syntax", ise);
        }
        this.logger.info("HealthCheckExecutor active at start level {}", (Object)this.getCurrentStartLevel());
    }

    @Modified
    protected final void modified(HealthCheckExecutorImplConfiguration configuration) {
        this.configure(configuration);
    }

    @Deactivate
    protected final void deactivate() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.healthCheckResultCache.clear();
        this.logger.info("HealthCheckExecutor shutdown at start level {}", (Object)this.getCurrentStartLevel());
    }

    private int getCurrentStartLevel() {
        return ((FrameworkStartLevel)this.bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class)).getStartLevel();
    }

    protected final void configure(HealthCheckExecutorImplConfiguration configuration) {
        this.timeoutInMs = configuration.timeoutInMs();
        if (this.timeoutInMs <= 0L) {
            this.timeoutInMs = 2000L;
        }
        this.longRunningFutureThresholdForRedMs = configuration.longRunningFutureThresholdForCriticalMs();
        if (this.longRunningFutureThresholdForRedMs <= 0L) {
            this.longRunningFutureThresholdForRedMs = 300000L;
        }
        this.resultCacheTtlInMs = configuration.resultCacheTtlInMs();
        if (this.resultCacheTtlInMs <= 0L) {
            this.resultCacheTtlInMs = 2000L;
        }
        this.defaultTags = configuration.defaultTags();
        this.tempUnavailableGracePeriodEvaluator = new TempUnavailableGracePeriodEvaluator(configuration.temporarilyAvailableGracePeriodInMs());
        System.setProperty(HC_LOGGING_SYS_PROP, String.valueOf(configuration.autoLogging()));
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 4) {
            Long serviceId = (Long)event.getServiceReference().getProperty("service.id");
            this.healthCheckResultCache.removeCachedResult(serviceId);
        }
    }

    public List<HealthCheckExecutionResult> execute(HealthCheckSelector selector) {
        return this.execute(selector, new HealthCheckExecutionOptions());
    }

    public List<HealthCheckExecutionResult> execute(HealthCheckSelector selector, HealthCheckExecutionOptions options) {
        this.logger.debug("Starting executing checks for filter selector {} and execution options {}", (Object)selector, (Object)options);
        if (!(selector.names() != null && selector.names().length != 0 || selector.tags() != null && selector.tags().length != 0)) {
            this.logger.debug("Using default tags");
            selector.withTags(this.defaultTags);
        }
        ServiceReference<HealthCheck>[] healthCheckReferences = this.selectHealthCheckReferences(selector, options);
        List<HealthCheckExecutionResult> results = this.execute(healthCheckReferences, options);
        return results;
    }

    @Override
    public ServiceReference<HealthCheck>[] selectHealthCheckReferences(HealthCheckSelector selector, HealthCheckExecutionOptions options) {
        HealthCheckFilter filter = new HealthCheckFilter(this.bundleContext);
        ServiceReference<HealthCheck>[] healthCheckReferences = filter.getHealthCheckServiceReferences(selector, options.isCombineTagsWithOr());
        return healthCheckReferences;
    }

    @Override
    public HealthCheckExecutionResult execute(ServiceReference<HealthCheck> ref) {
        HealthCheckMetadata metadata = this.getHealthCheckMetadata((ServiceReference<?>)ref);
        return this.createResultsForDescriptor(metadata);
    }

    @Override
    public List<HealthCheckExecutionResult> execute(ServiceReference<HealthCheck>[] healthCheckReferences, HealthCheckExecutionOptions options) {
        long startTime = System.currentTimeMillis();
        ArrayList<HealthCheckExecutionResult> results = new ArrayList<HealthCheckExecutionResult>();
        List<HealthCheckMetadata> healthCheckDescriptors = this.getHealthCheckMetadata(healthCheckReferences);
        this.createResultsForDescriptors(healthCheckDescriptors, results, options);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Time consumed for all checks: {}", (Object)FormattingResultLog.msHumanReadable((long)(System.currentTimeMillis() - startTime)));
        }
        Collections.sort(results, new Comparator<HealthCheckExecutionResult>(){

            @Override
            public int compare(HealthCheckExecutionResult arg0, HealthCheckExecutionResult arg1) {
                return ((ExecutionResult)arg0).compareTo((ExecutionResult)arg1);
            }
        });
        return results;
    }

    private HealthCheckExecutionResult createResultsForDescriptor(HealthCheckMetadata metadata) {
        ArrayList<HealthCheckExecutionResult> results = new ArrayList<HealthCheckExecutionResult>();
        ArrayList<HealthCheckMetadata> healthCheckDescriptors = new ArrayList<HealthCheckMetadata>();
        healthCheckDescriptors.add(metadata);
        this.createResultsForDescriptors(healthCheckDescriptors, results, new HealthCheckExecutionOptions());
        if (results.size() != 1) {
            throw new IllegalStateException("Execute method for a single service reference unexpectedly resulted in " + results.size() + " results: " + results);
        }
        return (HealthCheckExecutionResult)results.get(0);
    }

    private void createResultsForDescriptors(List<HealthCheckMetadata> healthCheckDescriptors, List<HealthCheckExecutionResult> results, HealthCheckExecutionOptions options) {
        if (!options.isForceInstantExecution() && this.asyncHealthCheckExecutor != null) {
            this.asyncHealthCheckExecutor.collectAsyncResults(healthCheckDescriptors, results, this.healthCheckResultCache);
        }
        if (!options.isForceInstantExecution()) {
            this.healthCheckResultCache.useValidCacheResults(healthCheckDescriptors, results, this.resultCacheTtlInMs);
        }
        List<HealthCheckFuture> futures = this.createOrReuseFutures(healthCheckDescriptors);
        this.waitForFuturesRespectingTimeout(futures, options);
        this.collectResultsFromFutures(futures, results);
        this.appendStickyResultLogIfConfigured(results);
        this.tempUnavailableGracePeriodEvaluator.evaluateGracePeriodForTemporarilyUnavailableResults(results);
    }

    private void appendStickyResultLogIfConfigured(List<HealthCheckExecutionResult> results) {
        ListIterator<HealthCheckExecutionResult> resultsIt = results.listIterator();
        while (resultsIt.hasNext()) {
            HealthCheckExecutionResult result = resultsIt.next();
            Long warningsStickForMinutes = result.getHealthCheckMetadata().getKeepNonOkResultsStickyForSec();
            if (warningsStickForMinutes == null || warningsStickForMinutes <= 0L) continue;
            result = this.healthCheckResultCache.createExecutionResultWithStickyResults(result);
            resultsIt.set(result);
        }
    }

    private List<HealthCheckMetadata> getHealthCheckMetadata(ServiceReference<?> ... healthCheckReferences) {
        LinkedList<HealthCheckMetadata> descriptors = new LinkedList<HealthCheckMetadata>();
        for (ServiceReference<?> serviceReference : healthCheckReferences) {
            HealthCheckMetadata descriptor = this.getHealthCheckMetadata(serviceReference);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    private HealthCheckMetadata getHealthCheckMetadata(ServiceReference<?> healthCheckReference) {
        HealthCheckMetadata descriptor = new HealthCheckMetadata(healthCheckReference);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HealthCheckFuture> createOrReuseFutures(List<HealthCheckMetadata> healthCheckDescriptors) {
        LinkedList<HealthCheckFuture> futuresForResultOfThisCall = new LinkedList<HealthCheckFuture>();
        Map<HealthCheckMetadata, HealthCheckFuture> map = this.stillRunningFutures;
        synchronized (map) {
            for (HealthCheckMetadata md : healthCheckDescriptors) {
                futuresForResultOfThisCall.add(this.createOrReuseFuture(md));
            }
        }
        return futuresForResultOfThisCall;
    }

    private HealthCheckFuture createOrReuseFuture(final HealthCheckMetadata metadata) {
        HealthCheckFuture future = this.stillRunningFutures.get(metadata);
        if (future != null) {
            this.logger.debug("Found a future that is still running for {}", (Object)metadata);
        } else {
            this.logger.debug("Creating future for {}", (Object)metadata);
            future = new HealthCheckFuture(metadata, this.bundleContext, new HealthCheckFuture.Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void finished(HealthCheckExecutionResult result) {
                    HealthCheckExecutorImpl.this.healthCheckResultCache.updateWith(result);
                    HealthCheckExecutorImpl.this.asyncHealthCheckExecutor.updateWith(result);
                    HealthCheckExecutorImpl.this.tempUnavailableGracePeriodEvaluator.updateTemporarilyUnavailableTimestampWith(result);
                    Map map = HealthCheckExecutorImpl.this.stillRunningFutures;
                    synchronized (map) {
                        HealthCheckExecutorImpl.this.stillRunningFutures.remove(metadata);
                    }
                }
            });
            this.stillRunningFutures.put(metadata, future);
            final HealthCheckFuture newFuture = future;
            this.healthCheckExecutorThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    newFuture.run();
                    Map map = HealthCheckExecutorImpl.this.stillRunningFutures;
                    synchronized (map) {
                        HealthCheckExecutorImpl.this.stillRunningFutures.notifyAll();
                    }
                }
            });
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFuturesRespectingTimeout(List<HealthCheckFuture> futuresForResultOfThisCall, HealthCheckExecutionOptions options) {
        boolean allFuturesDone;
        long callExcutionStartTime = System.currentTimeMillis();
        long effectiveTimeout = this.timeoutInMs;
        if (options != null && options.getOverrideGlobalTimeout() > 0) {
            effectiveTimeout = options.getOverrideGlobalTimeout();
        }
        if (futuresForResultOfThisCall.isEmpty()) {
            return;
        }
        do {
            try {
                Map<HealthCheckMetadata, HealthCheckFuture> map = this.stillRunningFutures;
                synchronized (map) {
                    this.stillRunningFutures.wait(50L);
                }
            }
            catch (InterruptedException ie) {
                this.logger.warn("Unexpected InterruptedException while waiting for healthCheckContributors", (Throwable)ie);
            }
            allFuturesDone = true;
            for (HealthCheckFuture healthCheckFuture : futuresForResultOfThisCall) {
                allFuturesDone &= healthCheckFuture.isDone();
            }
        } while (!allFuturesDone && System.currentTimeMillis() - callExcutionStartTime < effectiveTimeout);
    }

    void collectResultsFromFutures(List<HealthCheckFuture> futuresForResultOfThisCall, Collection<HealthCheckExecutionResult> results) {
        HashSet<HealthCheckExecutionResult> resultsFromFutures = new HashSet<HealthCheckExecutionResult>();
        Iterator<HealthCheckFuture> futuresIt = futuresForResultOfThisCall.iterator();
        while (futuresIt.hasNext()) {
            HealthCheckFuture future = futuresIt.next();
            HealthCheckExecutionResult result = this.collectResultFromFuture(future);
            resultsFromFutures.add(result);
            futuresIt.remove();
        }
        this.logger.debug("Adding {} results from futures", (Object)resultsFromFutures.size());
        results.addAll(resultsFromFutures);
    }

    HealthCheckExecutionResult collectResultFromFuture(HealthCheckFuture future) {
        HealthCheckExecutionResult result;
        HealthCheckMetadata hcMetadata = future.getHealthCheckMetadata();
        if (future.isDone()) {
            this.logger.debug("Health Check is done: {}", (Object)hcMetadata);
            try {
                result = (HealthCheckExecutionResult)future.get();
            }
            catch (Exception e) {
                this.logger.warn("Unexpected Exception during future.get(): " + e, (Throwable)e);
                long futureElapsedTimeMs = new Date().getTime() - future.getCreatedTime().getTime();
                result = new ExecutionResult(hcMetadata, Result.Status.HEALTH_CHECK_ERROR, "Unexpected Exception during future.get(): " + e, futureElapsedTimeMs, false);
            }
        } else {
            this.logger.debug("Health Check timed out: {}", (Object)hcMetadata);
            long futureElapsedTimeMs = new Date().getTime() - future.getCreatedTime().getTime();
            FormattingResultLog resultLog = new FormattingResultLog();
            if (futureElapsedTimeMs < this.longRunningFutureThresholdForRedMs) {
                resultLog.warn("Timeout: Check still running after " + FormattingResultLog.msHumanReadable((long)futureElapsedTimeMs), new Object[0]);
            } else {
                resultLog.critical("Timeout: Check still running after " + FormattingResultLog.msHumanReadable((long)futureElapsedTimeMs) + " (exceeding the configured threshold for CRITICAL: " + FormattingResultLog.msHumanReadable((long)this.longRunningFutureThresholdForRedMs) + ")", new Object[0]);
            }
            HealthCheckExecutionResult lastCachedResult = this.healthCheckResultCache.getValidCacheResult(hcMetadata, 1471228928L);
            if (lastCachedResult != null) {
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
                resultLog.info("*** Result log of last execution finished at {} after {} ***", new Object[]{df.format(lastCachedResult.getFinishedAt()), FormattingResultLog.msHumanReadable((long)lastCachedResult.getElapsedTimeInMs())});
                for (ResultLog.Entry entry : lastCachedResult.getHealthCheckResult()) {
                    resultLog.add(entry);
                }
            }
            result = new ExecutionResult(hcMetadata, new Result((ResultLog)resultLog), futureElapsedTimeMs, true);
        }
        return result;
    }

    public void setTimeoutInMs(long timeoutInMs) {
        this.timeoutInMs = timeoutInMs;
    }

    public void setLongRunningFutureThresholdForRedMs(long longRunningFutureThresholdForRedMs) {
        this.longRunningFutureThresholdForRedMs = longRunningFutureThresholdForRedMs;
    }
}

