/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.jcr.repoinit.impl.NodePropertiesVisitor;
import org.apache.sling.jcr.repoinit.impl.RepoInitException;
import org.apache.sling.repoinit.parser.operations.AddMixins;
import org.apache.sling.repoinit.parser.operations.CreatePath;
import org.apache.sling.repoinit.parser.operations.EnsureNodes;
import org.apache.sling.repoinit.parser.operations.PathSegmentDefinition;
import org.apache.sling.repoinit.parser.operations.PropertyLine;
import org.apache.sling.repoinit.parser.operations.RemoveMixins;
import org.apache.sling.repoinit.parser.operations.SetProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeVisitor
extends DoNothingVisitor {
    private static final Logger slog = LoggerFactory.getLogger(NodeVisitor.class);

    protected NodeVisitor(Session s) {
        super(s);
    }

    @Override
    public void visitEnsureNodes(EnsureNodes en) {
        this.createNodes(en.getDefinitions(), en.getPropertyLines(), true);
    }

    @Override
    public void visitCreatePath(CreatePath cp) {
        this.createNodes(cp.getDefinitions(), cp.getPropertyLines(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createNodes(List<PathSegmentDefinition> pathSegmentDefinitions, List<PropertyLine> propertyLines, boolean strict) {
        StringBuilder parentPathBuilder = new StringBuilder();
        for (PathSegmentDefinition psd : pathSegmentDefinitions) {
            String parentPath = parentPathBuilder.toString();
            String fullPath = String.format("%s/%s", parentPath, psd.getSegment());
            try {
                List mixins;
                Node parent;
                Node node;
                if (strict) {
                    if (this.session.nodeExists(fullPath)) {
                        this.log.info("Node at {} already exists, checking/adjusting its types", (Object)fullPath);
                        node = this.session.getNode(fullPath);
                        if (psd.getPrimaryType() != null && !node.getPrimaryNodeType().getName().equals(psd.getPrimaryType())) {
                            this.log.info("Adjusting primary type of node {} to {}", (Object)fullPath, (Object)psd.getPrimaryType());
                            node.setPrimaryType(psd.getPrimaryType());
                        }
                    } else {
                        if (this.session.propertyExists(fullPath)) throw new RepoInitException("There is a property with the name of the to be created node already at " + fullPath + ", therefore bailing out here as potentially not supported by the underlying JCR");
                        parent = parentPath.equals("") ? this.session.getRootNode() : this.session.getNode(parentPath);
                        this.log.info("Creating node {} with primary type {}", (Object)fullPath, (Object)psd.getPrimaryType());
                        node = NodeVisitor.addChildNode(parent, psd);
                    }
                } else if (this.session.itemExists(fullPath)) {
                    this.log.info("Path already exists, nothing to do (and not checking its primary type for now): {}", (Object)fullPath);
                    node = null;
                } else {
                    parent = parentPath.equals("") ? this.session.getRootNode() : this.session.getNode(parentPath);
                    this.log.info("Creating node {} with primary type {}", (Object)fullPath, (Object)psd.getPrimaryType());
                    node = NodeVisitor.addChildNode(parent, psd);
                }
                if (node != null && (mixins = psd.getMixins()) != null) {
                    this.log.info("Adding mixins {} to node {}", (Object)mixins, (Object)fullPath);
                    for (String mixin : mixins) {
                        node.addMixin(mixin);
                    }
                }
            }
            catch (Exception e) {
                this.report(e, "CreatePath execution failed at " + psd + ": " + e);
            }
            parentPathBuilder.append("/").append(psd.getSegment());
        }
        if (!propertyLines.isEmpty()) {
            SetProperties sp = new SetProperties(Collections.singletonList(parentPathBuilder.toString()), propertyLines);
            NodePropertiesVisitor npv = new NodePropertiesVisitor(this.session);
            npv.visitSetProperties(sp);
        }
        try {
            this.session.save();
            return;
        }
        catch (Exception e) {
            this.report(e, "Session.save failed: " + e);
        }
    }

    @Override
    public void visitAddMixins(AddMixins am) {
        List paths = am.getPaths();
        if (paths != null) {
            for (String absPath : paths) {
                try {
                    if (!this.session.itemExists(absPath)) {
                        this.log.warn("Path does not exist, not adding mixins: {}", (Object)absPath);
                        continue;
                    }
                    List mixins = am.getMixins();
                    if (mixins == null) continue;
                    Node node = this.session.getNode(absPath);
                    this.log.info("Adding mixins {} to node {}", (Object)mixins, (Object)absPath);
                    for (String mixin : mixins) {
                        node.addMixin(mixin);
                    }
                }
                catch (Exception e) {
                    this.report(e, "AddMixins execution failed at " + absPath + ": " + e);
                }
            }
        }
    }

    @Override
    public void visitRemoveMixins(RemoveMixins rm) {
        List paths = rm.getPaths();
        if (paths != null) {
            for (String absPath : paths) {
                try {
                    if (!this.session.itemExists(absPath)) {
                        this.log.warn("Path does not exist, not removing mixins: {}", (Object)absPath);
                        continue;
                    }
                    List mixins = rm.getMixins();
                    if (mixins == null) continue;
                    Node node = this.session.getNode(absPath);
                    this.log.info("Removing mixins {} from node {}", (Object)mixins, (Object)absPath);
                    for (String mixin : mixins) {
                        node.removeMixin(mixin);
                    }
                }
                catch (Exception e) {
                    this.report(e, "RemoveMixins execution failed at " + absPath + ": " + e);
                }
            }
        }
    }

    @NotNull
    private static Node addChildNode(@NotNull Node parent, @NotNull PathSegmentDefinition psd) throws RepositoryException {
        String primaryType = psd.getPrimaryType();
        if (primaryType == null) {
            try {
                return parent.addNode(psd.getSegment());
            }
            catch (ConstraintViolationException e) {
                slog.info("Adding Node without node type failed ('{}'), retry with sling:Folder", (Object)e.getMessage());
                return parent.addNode(psd.getSegment(), "sling:Folder");
            }
        }
        return parent.addNode(psd.getSegment(), psd.getPrimaryType());
    }
}

