/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathGenerator {
    private List<List<String>> segments = new ArrayList<List<String>>();
    private String toAppend;

    private static List<String> cartesianJoin(List<List<String>> segments, String toAppend) {
        return PathGenerator.cartesianJoin0(0, segments, toAppend).stream().map(StringBuilder::toString).collect(Collectors.toList());
    }

    private static List<StringBuilder> cartesianJoin0(int index, List<List<String>> segments, String toAppend) {
        ArrayList<StringBuilder> out = new ArrayList<StringBuilder>();
        if (index == segments.size()) {
            out.add(new StringBuilder("/"));
        } else {
            for (String segment : segments.get(index)) {
                for (StringBuilder sb : PathGenerator.cartesianJoin0(index + 1, segments, toAppend)) {
                    sb.append(segment);
                    if (index != 0) {
                        sb.append('/');
                    } else if (toAppend != null) {
                        sb.append(toAppend);
                    }
                    out.add(sb);
                }
            }
        }
        return out;
    }

    public void insertSegment(@NotNull List<String> alias, @NotNull String name) {
        List<Object> filtered = Stream.concat(alias.stream(), Stream.of(name)).filter(e -> e != null && !e.isEmpty()).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            filtered = Collections.singletonList("");
        }
        this.segments.add(filtered);
    }

    public void setResolutionPathInfo(@Nullable String resolutionInfo) {
        this.toAppend = resolutionInfo;
    }

    public List<String> generatePaths() {
        return PathGenerator.cartesianJoin(this.segments, this.toAppend);
    }
}

