/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.davex.impl.servlets;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.osgi.service.http.context.ServletContextHelper;

@Component(metatype=false, policy=ConfigurationPolicy.IGNORE)
@Service(value={ServletContextHelper.class})
@Properties(value={@Property(name="service.description", value={"Sling JcrRemoting Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="osgi.http.whiteboard.context.name", value={"DavExAuthHttpContext"}), @Property(name="osgi.http.whiteboard.context.path", value={"/"}), @Property(name="service.ranking", intValue={5})})
public class AuthHttpContext
extends ServletContextHelper {
    static final String HTTP_CONTEXT_NAME = "DavExAuthHttpContext";
    @Reference
    private AuthenticationSupport authenticator;

    public Set<String> getResourcePaths(String path) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthenticationSupport localAuthenticator = this.authenticator;
        if (localAuthenticator != null) {
            String wsp = this.getWorkspace(request.getPathInfo());
            if (wsp != null) {
                request.setAttribute("j_workspace", (Object)wsp);
            }
            return localAuthenticator.handleSecurity(request, response);
        }
        response.sendError(503);
        response.flushBuffer();
        return false;
    }

    private final String getWorkspace(String uriPath) {
        if (uriPath != null && uriPath.length() > 1 && uriPath.charAt(0) == '/') {
            int end = uriPath.indexOf(47, 1);
            if (end > 1) {
                return uriPath.substring(1, end);
            }
            if (end < 0) {
                return uriPath.substring(1);
            }
        }
        return null;
    }

    protected void bindAuthenticator(AuthenticationSupport authenticationSupport) {
        this.authenticator = authenticationSupport;
    }

    protected void unbindAuthenticator(AuthenticationSupport authenticationSupport) {
        if (this.authenticator == authenticationSupport) {
            this.authenticator = null;
        }
    }
}

