/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import org.apache.sling.commons.threads.ModifiableThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={EventingThreadPool.class}, property={"service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class EventingThreadPool
implements ThreadPool {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ThreadPoolManager threadPoolManager;
    private ThreadPool threadPool;

    public EventingThreadPool() {
    }

    public EventingThreadPool(ThreadPoolManager tpm, int poolSize) {
        this.threadPoolManager = tpm;
        this.configure(poolSize);
    }

    public void release() {
        this.deactivate();
    }

    @Activate
    @Modified
    protected void activate(Config config) {
        this.configure(config.minPoolSize());
    }

    private void configure(int maxPoolSize) {
        ModifiableThreadPoolConfig config = new ModifiableThreadPoolConfig();
        config.setMinPoolSize(maxPoolSize);
        config.setMaxPoolSize(config.getMinPoolSize());
        config.setQueueSize(-1);
        config.setShutdownGraceful(true);
        config.setPriority(ThreadPoolConfig.ThreadPriority.NORM);
        config.setDaemon(true);
        this.threadPool = this.threadPoolManager.create((ThreadPoolConfig)config, "Apache Sling Job Thread Pool");
    }

    @Deactivate
    protected void deactivate() {
        this.threadPoolManager.release(this.threadPool);
    }

    public void execute(Runnable runnable) {
        this.threadPool.execute(runnable);
    }

    public ThreadPoolConfig getConfiguration() {
        return this.threadPool.getConfiguration();
    }

    public String getName() {
        return this.threadPool.getName();
    }

    @ObjectClassDefinition(name="Apache Sling Job Thread Pool", description="This is the thread pool used by the Apache Sling job handling. The threads from this pool are merely used for executing jobs. By limiting this pool, it is possible to limit the maximum number of parallel processed jobs - regardless of the queue configuration.")
    public static @interface Config {
        @AttributeDefinition(name="Pool Size", description="The size of the thread pool. This pool is used to execute jobs and therefore limits the maximum number of jobs executed in parallel.")
        public int minPoolSize() default 35;
    }
}

