/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.service.impl;

import com.composum.sling.core.usermanagement.service.AuthorizableWrapper;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.usermanagement.service.GroupWrapper;
import com.composum.sling.core.usermanagement.service.ServiceUserWrapper;
import com.composum.sling.core.usermanagement.service.UserWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.serviceusermapping.Mapping;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AuthorizablesImpl
implements Authorizables {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizablesImpl.class);
    @Reference
    protected ServiceUserMapper serviceUserMapper;
    private boolean incompatibleServiceMapper = false;

    @Activate
    protected void activate() {
        this.incompatibleServiceMapper = false;
    }

    @Override
    @Nullable
    public AuthorizableWrapper getAuthorizable(@NotNull Authorizables.Context context, @NotNull String id) throws RepositoryException {
        AuthorizableWrapper authorizable = context.getAuthorizables().get(id);
        if (authorizable == null) {
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                authorizable = AuthorizablesImpl.getAuthorizableWrapper(id, userManager);
            }
            if (authorizable == null) {
                authorizable = this.getServiceUser(id);
            }
            if (authorizable != null) {
                context.getAuthorizables().put(id, authorizable);
            }
            if (authorizable instanceof ServiceUserWrapper) {
                ((ServiceUserWrapper)authorizable).initialize(context);
            }
        }
        return authorizable;
    }

    private static AuthorizableWrapper getAuthorizableWrapper(@NotNull String id, UserManager userManager) throws RepositoryException {
        AuthorizableWrapper wrapper = null;
        Authorizable jcrAuthorizable = userManager.getAuthorizable(id);
        if (jcrAuthorizable != null) {
            wrapper = jcrAuthorizable instanceof User ? new UserWrapper((User)jcrAuthorizable) : (jcrAuthorizable instanceof Group ? new GroupWrapper((Group)jcrAuthorizable) : new AuthorizableWrapper(jcrAuthorizable));
        }
        return wrapper;
    }

    @Override
    @NotNull
    public Set<? extends AuthorizableWrapper> findAuthorizables(@NotNull Authorizables.Context context, @Nullable Class<? extends AuthorizableWrapper> selector, @Nullable String nameQueryPattern, @Nullable Authorizables.Filter filter) throws RepositoryException {
        UserManager userManager;
        HashSet<AuthorizableWrapper> result = new HashSet<AuthorizableWrapper>();
        if (StringUtils.isNotBlank((CharSequence)nameQueryPattern)) {
            nameQueryPattern = nameQueryPattern.replaceAll("\\.\\*", "%").replace('*', '%');
        }
        if ((userManager = context.getUserManager()) != null) {
            Iterator<AuthorizableWrapper> iterator = this.findAuthorizables(context, selector, nameQueryPattern);
            while (iterator.hasNext()) {
                AuthorizableWrapper authorizable = iterator.next();
                if (filter != null && !filter.accept(authorizable)) continue;
                result.add(authorizable);
            }
        }
        for (ServiceUserWrapper serviceUser : this.findServiceUsers(context, selector, nameQueryPattern)) {
            if (filter != null && !filter.accept(serviceUser)) continue;
            result.add(serviceUser);
        }
        return result;
    }

    @Override
    @NotNull
    public <T extends AuthorizableWrapper> Collection<T> loadAuthorizables(@NotNull Authorizables.Context context, @NotNull Class<T> selector, @NotNull Set<String> idSet) throws RepositoryException {
        ArrayList<AuthorizableWrapper> result = new ArrayList<AuthorizableWrapper>();
        for (String id : idSet) {
            AuthorizableWrapper authorizable = this.getAuthorizable(context, id);
            if (!selector.isInstance(authorizable)) continue;
            result.add((AuthorizableWrapper)selector.cast(authorizable));
        }
        return result;
    }

    @NotNull
    protected Iterator<AuthorizableWrapper> findAuthorizables(@NotNull Authorizables.Context context, final @Nullable Class<? extends AuthorizableWrapper> selector, final @Nullable String nameQueryPattern) throws RepositoryException {
        UserManager userManager;
        if (!(selector != null && selector.equals(ServiceUserWrapper.class) || (userManager = context.getUserManager()) == null)) {
            Query authorizableQuery = new Query(){

                public <T> void build(QueryBuilder<T> builder) {
                    builder.setCondition(builder.nameMatches(StringUtils.isNotBlank((CharSequence)nameQueryPattern) ? nameQueryPattern : "%"));
                    builder.setSortOrder("@name", QueryBuilder.Direction.ASCENDING);
                    if (selector != null) {
                        if (selector.isInstance(UserWrapper.class)) {
                            builder.setSelector(User.class);
                        } else if (selector.isInstance(GroupWrapper.class)) {
                            builder.setSelector(Group.class);
                        }
                    }
                }
            };
            return AuthorizablesImpl.getAuthorizableWrapperIterator(userManager, authorizableQuery);
        }
        return Collections.emptyIterator();
    }

    @NotNull
    private static Iterator<AuthorizableWrapper> getAuthorizableWrapperIterator(UserManager userManager, Query authorizableQuery) throws RepositoryException {
        Iterator jcrAuthorizableIterator = userManager.findAuthorizables(authorizableQuery);
        ArrayList<AuthorizableWrapper> result = new ArrayList<AuthorizableWrapper>();
        while (jcrAuthorizableIterator.hasNext()) {
            Authorizable jcrAuthorizable = (Authorizable)jcrAuthorizableIterator.next();
            if (jcrAuthorizable instanceof User) {
                result.add(new UserWrapper((User)jcrAuthorizable));
                continue;
            }
            if (jcrAuthorizable instanceof Group) {
                result.add(new GroupWrapper((Group)jcrAuthorizable));
                continue;
            }
            result.add(new AuthorizableWrapper(jcrAuthorizable));
        }
        return result.iterator();
    }

    @NotNull
    protected List<ServiceUserWrapper> findServiceUsers(@NotNull Authorizables.Context context, @Nullable Class<? extends AuthorizableWrapper> selector, @Nullable String nameQueryPattern) throws RepositoryException {
        ArrayList<ServiceUserWrapper> serviceUsers = new ArrayList<ServiceUserWrapper>();
        if (!this.incompatibleServiceMapper && (selector == null || selector.equals(ServiceUserWrapper.class))) {
            Pattern namePattern = StringUtils.isNotBlank((CharSequence)nameQueryPattern) ? Pattern.compile("^" + nameQueryPattern.replaceAll("%", ".*") + "$") : null;
            try {
                List mappings = this.serviceUserMapper.getActiveMappings();
                for (Mapping mapping : mappings) {
                    ServiceUserWrapper service = new ServiceUserWrapper(mapping);
                    if (namePattern != null && !namePattern.matcher(service.getID()).matches()) continue;
                    service.initialize(context);
                    serviceUsers.add(service);
                }
            }
            catch (NoSuchMethodError nsme) {
                this.incompatibleServiceMapper = true;
                LOG.warn("incompatible ServiceUserMapper - no service user support (" + nsme + ")");
            }
        }
        return serviceUsers;
    }

    @Nullable
    protected ServiceUserWrapper getServiceUser(@NotNull String id) {
        List mappings = this.serviceUserMapper.getActiveMappings();
        for (Mapping mapping : mappings) {
            ServiceUserWrapper service = new ServiceUserWrapper(mapping);
            if (!id.equals(service.getID())) continue;
            return service;
        }
        return null;
    }
}

