/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.service;

import com.composum.sling.core.usermanagement.service.AuthorizableWrapper;
import com.composum.sling.core.usermanagement.service.GroupWrapper;
import com.composum.sling.core.usermanagement.service.ServiceUserWrapper;
import com.composum.sling.core.usermanagement.service.UserWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public interface Authorizables {
    public static final Map<String, Class<? extends AuthorizableWrapper>> SELECTORS = new HashMap<String, Class<? extends AuthorizableWrapper>>(){
        {
            this.put("user", UserWrapper.class);
            this.put("group", GroupWrapper.class);
            this.put("service", ServiceUserWrapper.class);
        }
    };

    @Nullable
    public static Class<? extends AuthorizableWrapper> selector(@Nullable String key) {
        return StringUtils.isNotBlank((CharSequence)key) ? SELECTORS.get(key.toLowerCase()) : null;
    }

    @Nullable
    public AuthorizableWrapper getAuthorizable(@NotNull Context var1, @NotNull String var2) throws RepositoryException;

    @NotNull
    public Set<? extends AuthorizableWrapper> findAuthorizables(@NotNull Context var1, @Nullable Class<? extends AuthorizableWrapper> var2, @Nullable String var3, @Nullable Filter var4) throws RepositoryException;

    @NotNull
    public <T extends AuthorizableWrapper> Collection<T> loadAuthorizables(@NotNull Context var1, @NotNull Class<T> var2, @NotNull Set<String> var3) throws RepositoryException;

    public static class Context {
        private static final Logger LOG = LoggerFactory.getLogger(Authorizables.class);
        protected final Authorizables service;
        protected final SlingHttpServletRequest request;
        protected final SlingHttpServletResponse response;
        protected final ResourceResolver resolver;
        protected final Session session;
        private transient UserManager userManager;
        protected final Map<String, AuthorizableWrapper> authorizables = new HashMap<String, AuthorizableWrapper>();

        public Context(@NotNull Authorizables service, @NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
            this.service = service;
            this.request = request;
            this.response = response;
            this.resolver = request.getResourceResolver();
            this.session = (Session)this.resolver.adaptTo(Session.class);
        }

        public void commit() throws RepositoryException {
            if (this.session != null) {
                this.session.save();
            }
        }

        @NotNull
        public Authorizables getService() {
            return this.service;
        }

        @NotNull
        public ResourceResolver getResolver() {
            return this.resolver;
        }

        @NotNull
        public SlingHttpServletRequest getRequest() {
            return this.request;
        }

        @NotNull
        public SlingHttpServletResponse getResponse() {
            return this.response;
        }

        public Session getSession() {
            return this.session;
        }

        @Nullable
        public UserManager getUserManager() {
            if (this.userManager == null && this.session != null) {
                try {
                    this.userManager = this.session instanceof JackrabbitSession ? ((JackrabbitSession)this.session).getUserManager() : null;
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return this.userManager;
        }

        public Map<String, AuthorizableWrapper> getAuthorizables() {
            return this.authorizables;
        }
    }

    public static interface Filter {
        public boolean accept(AuthorizableWrapper var1) throws RepositoryException;

        public static Pattern createPattern(@NotNull String pattern) {
            return Pattern.compile(pattern.replaceAll("\\*", ".*").replaceAll("\\.\\.\\*", ".*").replaceAll("%", ".*"));
        }

        public static class Path
        implements Filter {
            protected final Pattern pattern;

            public Path(@NotNull String pattern) {
                this(Filter.createPattern(pattern));
            }

            public Path(@NotNull Pattern pattern) {
                this.pattern = pattern;
            }

            @Override
            public boolean accept(AuthorizableWrapper authorizable) {
                try {
                    return this.pattern.matcher(authorizable.getPath()).matches();
                }
                catch (RepositoryException repositoryException) {
                    return false;
                }
            }
        }
    }
}

