/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.usermanagement.service.ServiceUserWrapper;
import java.util.Collection;
import javax.jcr.RepositoryException;
import org.jetbrains.annotations.NotNull;

public class ServiceUserModel
extends UserModel {
    protected final String serviceName;
    protected final String serviceInfo;
    private transient Collection<AuthorizableModel> userOf;
    private transient Collection<AuthorizableModel> declaredUserOf;

    public ServiceUserModel(@NotNull Authorizables.Context context, @NotNull ServiceUserWrapper service) throws RepositoryException {
        super(context, service);
        this.serviceName = service.getServiceName();
        this.serviceInfo = service.getServiceInfo();
    }

    @Override
    protected int getRank() {
        return 2;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceInfo() {
        return this.serviceInfo;
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public boolean isServiceUser() {
        return true;
    }

    @NotNull
    public Collection<AuthorizableModel> getUserOf() throws RepositoryException {
        if (this.userOf == null) {
            this.userOf = ServiceUserModel.getModels(this.context, this.getMemberOf());
        }
        return this.userOf;
    }

    @NotNull
    public Collection<AuthorizableModel> getDeclaredUserOf() throws RepositoryException {
        if (this.declaredUserOf == null) {
            this.declaredUserOf = ServiceUserModel.getModels(this.context, this.getDeclaredMemberOf());
        }
        return this.declaredUserOf;
    }
}

