/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.GroupModel;
import com.composum.sling.core.usermanagement.model.ServiceUserModel;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.composum.sling.core.usermanagement.service.AuthorizableWrapper;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.usermanagement.service.GroupWrapper;
import com.composum.sling.core.usermanagement.service.ServiceUserWrapper;
import com.composum.sling.core.usermanagement.service.UserWrapper;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthorizablesView {
    protected int index = 0;
    protected final Map<String, Integer> indexes = new LinkedHashMap<String, Integer>();
    protected final Map<String, AuthorizableModel> nodes = new TreeMap<String, AuthorizableModel>();
    protected final AuthorizableModel singleFocus;
    protected final Authorizables.Context context;

    public AuthorizablesView(@NotNull Authorizables.Context context, @Nullable String selector, @Nullable String nameQueryPattern, @Nullable String pathPattern) throws RepositoryException {
        this(context, Authorizables.selector(selector), nameQueryPattern, StringUtils.isNotBlank((CharSequence)pathPattern) ? new Authorizables.Filter.Path(pathPattern) : null);
    }

    public AuthorizablesView(@NotNull Authorizables.Context context, @Nullable Class<? extends AuthorizableWrapper> selector, @Nullable String nameQueryPattern, @Nullable Authorizables.Filter filter) throws RepositoryException {
        this.context = context;
        Set<? extends AuthorizableWrapper> authorizables = context.getService().findAuthorizables(context, selector, nameQueryPattern, filter);
        for (AuthorizableWrapper authorizableWrapper : authorizables) {
            this.addNode(authorizableWrapper);
        }
        this.singleFocus = this.nodes.size() == 1 ? this.nodes.values().iterator().next() : null;
    }

    public AuthorizableModel getSingleFocus() {
        return this.singleFocus;
    }

    public Collection<AuthorizableModel> getAuthorizableModels() {
        return this.nodes.values();
    }

    protected AuthorizableModel addNode(@Nullable AuthorizableWrapper authorizable) throws RepositoryException {
        AuthorizableModel result = null;
        if (authorizable != null && (result = this.nodes.get(authorizable.getID())) == null && (result = this.createNode(authorizable)) != null) {
            this.nodes.put(result.getId(), result);
            this.indexes.put(result.getId(), ++this.index);
        }
        return result;
    }

    @Nullable
    protected AuthorizableModel createNode(@NotNull AuthorizableWrapper authorizable) throws RepositoryException {
        return authorizable instanceof GroupWrapper ? new GroupModel(this.context, (GroupWrapper)authorizable) : (authorizable instanceof UserWrapper ? new UserModel(this.context, (UserWrapper)authorizable) : (authorizable instanceof ServiceUserWrapper ? new ServiceUserModel(this.context, (ServiceUserWrapper)authorizable) : null));
    }

    public void toJson(@NotNull JsonWriter writer) throws IOException {
        writer.beginObject();
        if (this.singleFocus != null) {
            writer.name("focus");
            this.singleFocus.toJson(writer);
        } else {
            writer.name("nodes").beginArray();
            for (AuthorizableModel node : this.nodes.values()) {
                node.toJson(writer);
            }
            writer.endArray();
        }
        writer.endObject();
    }

    protected String getNodeClass(AuthorizableModel node) {
        StringBuilder builder = new StringBuilder();
        if (node.isGroup()) {
            builder.append("group");
        } else {
            UserModel user = (UserModel)node;
            if (user.isDisabled()) {
                builder.append("disabled");
            } else if (user.isAdmin()) {
                builder.append("admin");
            } else if (user.isServiceUser()) {
                builder.append("service");
            } else if (user.isSystemUser()) {
                builder.append("system");
            } else {
                builder.append("user");
            }
        }
        if (this.singleFocus != null && this.singleFocus.getId().equals(node.getId())) {
            builder.append(" focus");
        }
        return builder.toString();
    }

    public static interface PathUrlBuilder {
        @Nullable
        public String buildUrl(@NotNull AuthorizableModel var1, @NotNull String var2);
    }

    public static interface NodeUrlBuilder {
        @Nullable
        public String buildUrl(@NotNull AuthorizableModel var1);
    }
}

