/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.AuthorizableAcls;
import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.AuthorizablesMap;
import com.composum.sling.core.usermanagement.model.AuthorizablesView;
import com.composum.sling.core.usermanagement.service.AuthorizableWrapper;
import com.composum.sling.core.usermanagement.service.Authorizables;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthorizablesPaths
extends AuthorizablesMap {
    public static final Map<String, Object> DEFAULT_NODE_CFG = new HashMap<String, Object>(){
        {
            this.put("style", "filled");
            this.put("fontname", "sans-serif");
            this.put("fontsize", "10.0");
        }
    };
    protected final Pattern textPattern;

    public AuthorizablesPaths(@NotNull Authorizables.Context context, @Nullable String selector, @Nullable String nameQueryPattern, @Nullable String pathPattern, @Nullable String textPattern) throws RepositoryException {
        this(context, Authorizables.selector(selector), nameQueryPattern, StringUtils.isNotBlank((CharSequence)pathPattern) ? new Authorizables.Filter.Path(pathPattern) : null, textPattern);
    }

    public AuthorizablesPaths(@NotNull Authorizables.Context context, @Nullable Class<? extends AuthorizableWrapper> selector, @Nullable String nameQueryPattern, @Nullable Authorizables.Filter filter, @Nullable String textPattern) throws RepositoryException {
        super(context, selector, nameQueryPattern, filter);
        this.textPattern = StringUtils.isNotBlank((CharSequence)textPattern) ? Authorizables.Filter.createPattern(textPattern) : null;
    }

    @NotNull
    protected Collection<String> filterPaths(@NotNull Collection<String> pathSet) {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : pathSet) {
            if (this.textPattern != null && !this.textPattern.matcher(path).matches()) continue;
            result.add(path);
        }
        return result;
    }

    public void toPathsTable(@NotNull ResourceResolver resolver, @NotNull Writer writer, @Nullable Resource config, @Nullable AuthorizablesView.NodeUrlBuilder nodeUrlBuilder, @Nullable AuthorizablesView.PathUrlBuilder pathUrlBuilder) throws IOException {
        writer.append("<table class=\"composum-nodes-usermgr-paths_table table-striped table-condensed\">\n  <tbody>\n");
        for (AuthorizableModel node : this.nodes.values()) {
            AuthorizableAcls acls = new AuthorizableAcls(resolver, node.getId());
            Map<String, AuthorizableAcls.AcRuleSet> affectedPaths = acls.getAffectedPaths();
            Collection<String> pathSet = this.filterPaths(affectedPaths.keySet());
            if (pathSet.size() <= 0 && this.textPattern != null) continue;
            Iterator<String> pathIterator = pathSet.iterator();
            writer.append("    <tr class=\"").append(this.getNodeClass(node)).append("\">\n");
            writer.append("      <td class=\"authorizable-id\" rowspan=\"").append(Integer.toString(Math.max(1, pathSet.size()))).append("\"><i class=\"icon fa fa-").append(node.getTypeIcon()).append("\"></i>");
            String url = null;
            if (nodeUrlBuilder != null && StringUtils.isNotBlank((CharSequence)(url = nodeUrlBuilder.buildUrl(node)))) {
                writer.append("<a href=\"").append(url).append("\" data-path=\"").append(node.getPath()).append("\">");
            }
            writer.append(node.getId());
            if (url != null) {
                writer.append("</a>");
            }
            writer.append("</td>\n      ");
            String path = pathIterator.hasNext() ? pathIterator.next() : null;
            this.writePath(writer, node, pathUrlBuilder, path, path != null ? affectedPaths.get(path) : null, true);
            while (pathIterator.hasNext()) {
                path = pathIterator.next();
                this.writePath(writer, node, pathUrlBuilder, path, affectedPaths.get(path), false);
            }
            writer.append("    </tr>\n");
        }
        writer.append("  </tbody>\n</table>\n");
    }

    protected void writePath(@NotNull Writer writer, @NotNull AuthorizableModel node, @Nullable AuthorizablesView.PathUrlBuilder pathUrlBuilder, @Nullable String path, @Nullable AuthorizableAcls.AcRuleSet acRuleSet, boolean firstLine) throws IOException {
        if (!firstLine) {
            writer.append("    </tr>\n");
            writer.append("    <tr class=\"").append(this.getNodeClass(node)).append("\">\n      ");
        }
        writer.append("<td class=\"affected-path");
        if (path == null) {
            writer.append(" empty").append("\" colspan=\"2\"");
        }
        writer.append("\">");
        String url = null;
        if (path != null && pathUrlBuilder != null && StringUtils.isNotBlank((CharSequence)(url = pathUrlBuilder.buildUrl(node, path)))) {
            writer.append("<a href=\"").append(url).append("\" data-path=\"").append(path).append("\">");
        }
        writer.append(path != null ? path : this.i18n(this.context.getRequest(), "no affected paths found"));
        if (url != null) {
            writer.append("</a>");
        }
        writer.append("</td>");
        if (path != null && acRuleSet != null) {
            this.writeRules(writer, acRuleSet);
        }
        writer.append("\n");
    }

    protected void writeRules(@NotNull Writer writer, @NotNull AuthorizableAcls.AcRuleSet ruleSet) throws IOException {
        writer.append("<td class=\"ac-rules\">");
        int count = 0;
        for (AuthorizableAcls.AcRule rule : ruleSet.getRules()) {
            if (count > 0) {
                writer.append(" / ");
            }
            ++count;
            writer.append("<span class=\"").append(rule.getType().name().toLowerCase()).append("\">").append(rule.toString()).append("</span>");
        }
        writer.append("</td>");
    }

    @NotNull
    protected String i18n(@NotNull SlingHttpServletRequest request, @NotNull String text) {
        ResourceBundle bundle = request.getResourceBundle(request.getLocale());
        String translated = bundle != null ? bundle.getString(text) : null;
        return translated != null ? translated : text;
    }
}

