/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.GroupModel;
import com.composum.sling.core.usermanagement.model.ServiceUserModel;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.composum.sling.core.usermanagement.service.AuthorizableWrapper;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.usermanagement.service.GroupWrapper;
import com.composum.sling.core.usermanagement.service.ServiceUserWrapper;
import com.composum.sling.core.usermanagement.service.UserWrapper;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import org.jetbrains.annotations.NotNull;

public abstract class AuthorizableModel
implements Serializable,
Comparable<AuthorizableModel> {
    public static final String TYPE_GROUP = "group";
    public static final String TYPE_USER = "user";
    public static final String TYPE_SERVICE = "service";
    public static final Map<String, String> TYPE_TO_ICON = new HashMap<String, String>(){
        {
            this.put(AuthorizableModel.TYPE_GROUP, "users");
            this.put(AuthorizableModel.TYPE_USER, AuthorizableModel.TYPE_USER);
            this.put("system", "user-o");
            this.put(AuthorizableModel.TYPE_SERVICE, "cog");
        }
    };
    protected final String type;
    protected final String id;
    protected final String path;
    protected final String principalName;
    protected final Set<String> memberOf;
    protected final Set<String> declaredMemberOf;
    protected final Authorizables.Context context;
    private transient Collection<GroupModel> modelOf;
    private transient Collection<GroupModel> declaredModelOf;

    protected AuthorizableModel(@NotNull Authorizables.Context context, @NotNull AuthorizableWrapper authorizable) throws RepositoryException {
        this.context = context;
        this.type = AuthorizableModel.getType(authorizable);
        this.id = authorizable.getID();
        this.path = authorizable.getPath();
        this.principalName = authorizable.getPrincipal().getName();
        this.memberOf = AuthorizableModel.stripIDs(authorizable.memberOf());
        this.declaredMemberOf = AuthorizableModel.stripIDs(authorizable.declaredMemberOf());
    }

    public abstract boolean isGroup();

    public void toJson(JsonWriter writer) throws IOException {
        writer.beginObject();
        this.toJsonData(writer);
        writer.endObject();
    }

    protected void toJsonData(JsonWriter writer) throws IOException {
        writer.name("type").value(this.getType());
        writer.name("id").value(this.getId());
        writer.name("name").value(this.getPrincipalName());
        writer.name("path").value(this.getPath());
        writer.name("declaredMemberOf").beginArray();
        for (String id : this.getDeclaredMemberOf()) {
            writer.value(id);
        }
        writer.endArray();
        writer.name("memberOf").beginArray();
        for (String id : this.getMemberOf()) {
            writer.value(id);
        }
        writer.endArray();
        writer.name("principalName").value(this.getPrincipalName());
        writer.name("isGroup").value(this.isGroup());
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public String getTypeIcon() {
        return TYPE_TO_ICON.get(this.getType());
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String getPrincipalName() {
        return this.principalName;
    }

    @NotNull
    public Set<String> getMemberOf() {
        return this.memberOf;
    }

    @NotNull
    public Set<String> getDeclaredMemberOf() {
        return this.declaredMemberOf;
    }

    @NotNull
    public Collection<GroupModel> getModelOf() throws RepositoryException {
        if (this.modelOf == null) {
            this.modelOf = AuthorizableModel.getGroups(this.context, this.getMemberOf());
        }
        return this.modelOf;
    }

    @NotNull
    public Collection<GroupModel> getDeclaredModelOf() throws RepositoryException {
        if (this.declaredModelOf == null) {
            this.declaredModelOf = AuthorizableModel.getGroups(this.context, this.getDeclaredMemberOf());
        }
        return this.declaredModelOf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof AuthorizableModel)) return false;
        AuthorizableModel otherModel = (AuthorizableModel)other;
        if (!this.getId().equals(otherModel.getId())) return false;
        if (this.isGroup() != otherModel.isGroup()) return false;
        return true;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public int compareTo(AuthorizableModel other) {
        return this.getKey().compareTo(other.getKey());
    }

    protected String getKey() {
        return this.getRank() + 58 + this.getId();
    }

    protected abstract int getRank();

    @NotNull
    public static Collection<UserModel> getUsers(@NotNull Authorizables.Context context, @NotNull Set<String> idSet) throws RepositoryException {
        ArrayList<UserModel> result = new ArrayList<UserModel>();
        for (UserWrapper jcrUser : context.getService().loadAuthorizables(context, UserWrapper.class, idSet)) {
            result.add(new UserModel(context, jcrUser));
        }
        return result;
    }

    @NotNull
    public static Collection<GroupModel> getGroups(@NotNull Authorizables.Context context, @NotNull Set<String> idSet) throws RepositoryException {
        ArrayList<GroupModel> result = new ArrayList<GroupModel>();
        for (GroupWrapper jcrGroup : context.getService().loadAuthorizables(context, GroupWrapper.class, idSet)) {
            result.add(new GroupModel(context, jcrGroup));
        }
        return result;
    }

    @NotNull
    public static Collection<AuthorizableModel> getModels(@NotNull Authorizables.Context context, @NotNull Set<String> idSet) throws RepositoryException {
        ArrayList<AuthorizableModel> result = new ArrayList<AuthorizableModel>();
        for (AuthorizableWrapper authorizable : context.getService().loadAuthorizables(context, AuthorizableWrapper.class, idSet)) {
            if (authorizable instanceof GroupWrapper) {
                result.add(new GroupModel(context, (GroupWrapper)authorizable));
                continue;
            }
            if (authorizable instanceof UserWrapper) {
                result.add(new UserModel(context, (UserWrapper)authorizable));
                continue;
            }
            if (!(authorizable instanceof ServiceUserWrapper)) continue;
            result.add(new ServiceUserModel(context, (ServiceUserWrapper)authorizable));
        }
        return result;
    }

    @NotNull
    protected static Set<String> stripIDs(@NotNull Iterator<? extends AuthorizableWrapper> authorizableIterator) throws RepositoryException {
        TreeSet<String> idSet = new TreeSet<String>();
        while (authorizableIterator.hasNext()) {
            AuthorizableWrapper authorizable = authorizableIterator.next();
            idSet.add(authorizable.getID());
        }
        return idSet;
    }

    protected static String getType(@NotNull AuthorizableWrapper authorizable) {
        if (authorizable instanceof GroupWrapper) {
            return TYPE_GROUP;
        }
        if (authorizable instanceof ServiceUserWrapper) {
            return TYPE_SERVICE;
        }
        return TYPE_USER;
    }
}

