/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

public class AuthorizableAcls {
    protected final Map<String, AcRuleSet> affectedPaths = new TreeMap<String, AcRuleSet>();

    public AuthorizableAcls(@NotNull ResourceResolver resolver, @NotNull String authorizableId) {
        this.findACLs(resolver, authorizableId, AcType.Deny);
        this.findACLs(resolver, authorizableId, AcType.Grant);
    }

    public Map<String, AcRuleSet> getAffectedPaths() {
        return this.affectedPaths;
    }

    protected void addAcRule(@NotNull AcType type, @NotNull String path, @NotNull Resource aclResource) {
        AcRuleSet set = this.affectedPaths.get(path);
        if (set == null) {
            set = new AcRuleSet();
            this.affectedPaths.put(path, set);
        }
        set.add(type, aclResource);
    }

    protected void findACLs(@NotNull ResourceResolver resolver, @NotNull String authorizableId, @NotNull AcType type) {
        String query = "SELECT * FROM [rep:" + type.name() + "ACE] AS s WHERE  [rep:principalName] = '" + authorizableId + "'";
        Iterator aclResources = resolver.findResources(query, "JCR-SQL2");
        while (aclResources.hasNext()) {
            Resource aclResource = (Resource)aclResources.next();
            String path = aclResource.getPath();
            int repNodePos = path.indexOf("/rep:policy");
            if (repNodePos >= 0) {
                path = path.substring(0, repNodePos);
            }
            if (StringUtils.isBlank((CharSequence)path)) {
                path = "/";
            }
            this.addAcRule(type, path, aclResource);
        }
    }

    public class AcRuleSet {
        protected final List<AcRule> rules = new ArrayList<AcRule>();

        public List<AcRule> getRules() {
            return this.rules;
        }

        public void add(@NotNull AcType type, @NotNull Resource aclResource) {
            this.rules.add(new AcRule(type, aclResource));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (AcRule rule : this.rules) {
                if (builder.length() > 0) {
                    builder.append("; ");
                }
                builder.append(rule);
            }
            return builder.toString();
        }
    }

    public class AcRule {
        protected final AcType type;
        protected final String[] privileges;
        protected final Map<String, String[]> restrictions;

        public AcRule(@NotNull AcType type, Resource aclResource) {
            this.type = type;
            ValueMap values = aclResource.getValueMap();
            this.privileges = (String[])values.get("rep:privileges", (Object)new String[0]);
            this.restrictions = new TreeMap<String, String[]>();
            Resource restrictRes = aclResource.getChild("rep:restrictions");
            if (restrictRes != null) {
                for (Map.Entry entry : restrictRes.getValueMap().entrySet()) {
                    String[] stringArray;
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (!key.startsWith("rep:") || value == null) continue;
                    if (value instanceof String[]) {
                        stringArray = (String[])value;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = value.toString();
                    }
                    this.restrictions.put(key, stringArray);
                }
            }
        }

        public AcType getType() {
            return this.type;
        }

        public String[] getPrivileges() {
            return this.privileges;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.type.name().toLowerCase());
            builder.append(": ").append(StringUtils.join((Object[])this.getPrivileges(), (String)", "));
            if (this.restrictions.size() > 0) {
                builder.append(" (");
                int count = 0;
                for (Map.Entry<String, String[]> entry : this.restrictions.entrySet()) {
                    if (count > 0) {
                        builder.append(",");
                    }
                    ++count;
                    Object[] value = entry.getValue();
                    builder.append(entry.getKey()).append("=").append(value.length > 0 ? (value.length > 1 ? "[" + StringUtils.join((Object[])value, (String)",") + "]" : value[0]) : "");
                }
                builder.append(")");
            }
            return builder.toString();
        }
    }

    public static enum AcType {
        Grant,
        Deny;

    }
}

