/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.ScheduledDistributionTrigger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="Apache Sling Distribution Trigger - Scheduled Triggers Factory", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE, description="Triggers a distribution request of the given type (action) for the given path (path) at a periodical time interval (seconds).")
@Service(value={DistributionTrigger.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Trigger name: {name}"})
public class ScheduledDistributionTriggerFactory
implements DistributionTrigger {
    @Property(label="Name", description="The name of the trigger.")
    public static final String NAME = "name";
    @Property(label="Distribution Type", description="The type of the distribution request produced by this trigger in ('ADD', 'DELETE', 'PULL', 'TEST'). Default 'PULL'.")
    private static final String ACTION = "action";
    @Property(label="Distributed Path", description="The path to be distributed periodically.")
    private static final String PATH = "path";
    @Property(label="Interval in Seconds", description="The number of seconds between distribution requests. Default 30 seconds.")
    private static final String SECONDS = "seconds";
    @Property(label="Service Name", description="The name of the service used to trigger the distribution requests.")
    private static final String SERVICE_NAME = "serviceName";
    private ScheduledDistributionTrigger trigger;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private Scheduler scheduler;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> config) {
        String action = PropertiesUtil.toString((Object)config.get(ACTION), (String)DistributionRequestType.PULL.name());
        String path = PropertiesUtil.toString((Object)config.get(PATH), null);
        int interval = PropertiesUtil.toInteger((Object)config.get(SECONDS), (int)30);
        String serviceName = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(SERVICE_NAME), null));
        this.trigger = new ScheduledDistributionTrigger(action, path, interval, serviceName, this.scheduler, this.resolverFactory);
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }
}

