/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.PersistedJcrEventDistributionTrigger;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="Apache Sling Distribution Trigger - Persisted Jcr Event Triggers Factory", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionTrigger.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Trigger name: {name}"})
public class PersistedJcrEventDistributionTriggerFactory
implements DistributionTrigger {
    @Property(label="Name", description="The name of the trigger.")
    public static final String NAME = "name";
    @Property(label="Path", description="The path for which changes are listened and distributed as persisted nugget events.")
    private static final String PATH = "path";
    @Property(label="Service Name", description="The service used to listen for jcr events")
    private static final String SERVICE_NAME = "serviceName";
    @Property(value={"/var/sling/distribution/nuggets"}, label="Nuggets Path", description="The location where serialization of jcr events will be stored")
    private static final String NUGGETS_PATH = "nuggetsPath";
    private PersistedJcrEventDistributionTrigger trigger;
    @Reference
    private SlingRepository repository;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resolverFactory;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> config) {
        String path = PropertiesUtil.toString((Object)config.get(PATH), null);
        String serviceName = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(SERVICE_NAME), null));
        String nuggetsPath = PropertiesUtil.toString((Object)config.get(NUGGETS_PATH), null);
        this.trigger = new PersistedJcrEventDistributionTrigger(this.repository, this.scheduler, this.resolverFactory, path, serviceName, nuggetsPath);
        this.trigger.enable();
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

