/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageBuilderProvider;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.exporter.AgentDistributionPackageExporter;
import org.jetbrains.annotations.NotNull;

@Component(label="Apache Sling Distribution Exporter - Agent Based Package Exporter", metatype=true, configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionPackageExporter.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Exporter name: {name}"})
public class AgentDistributionPackageExporterFactory
implements DistributionPackageExporter {
    @Property(label="Name", description="The name of the exporter.")
    private static final String NAME = "name";
    @Property(label="Queue", description="The name of the queue from which the packages should be exported.")
    private static final String QUEUE_NAME = "queue";
    @Property(label="Drop invalid queue items", description="Remove invalid items from the queue.", boolValue={false})
    private static final String DROP_INVALID_QUEUE_ITEMS = "drop.invalid.items";
    @Property(name="agent.target", label="The target reference for the DistributionAgent that will be used to export packages.")
    @Reference(name="agent")
    private DistributionAgent agent;
    @Reference
    private DistributionPackageBuilderProvider packageBuilderProvider;
    private DistributionPackageExporter packageExporter;

    @Activate
    public void activate(Map<String, Object> config) throws Exception {
        String queueName = PropertiesUtil.toString((Object)config.get(QUEUE_NAME), (String)"default");
        queueName = (queueName = SettingsUtils.removeEmptyEntry(queueName)) == null ? "default" : queueName;
        String name = PropertiesUtil.toString((Object)config.get(NAME), (String)"");
        boolean dropInvalidItems = PropertiesUtil.toBoolean((Object)config.get(DROP_INVALID_QUEUE_ITEMS), (boolean)false);
        this.packageExporter = new AgentDistributionPackageExporter(queueName, this.agent, this.packageBuilderProvider, name, dropInvalidItems);
    }

    @Override
    public void exportPackages(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest, @NotNull DistributionPackageProcessor packageProcessor) throws DistributionException {
        this.packageExporter.exportPackages(resourceResolver, distributionRequest, packageProcessor);
    }

    @Override
    public DistributionPackage getPackage(@NotNull ResourceResolver resourceResolver, @NotNull String distributionPackageId) throws DistributionException {
        return this.packageExporter.getPackage(resourceResolver, distributionPackageId);
    }

    protected void bindAgent(DistributionAgent distributionAgent) {
        this.agent = distributionAgent;
    }

    protected void unbindAgent(DistributionAgent distributionAgent) {
        if (this.agent == distributionAgent) {
            this.agent = null;
        }
    }

    protected void bindPackageBuilderProvider(DistributionPackageBuilderProvider distributionPackageBuilderProvider) {
        this.packageBuilderProvider = distributionPackageBuilderProvider;
    }

    protected void unbindPackageBuilderProvider(DistributionPackageBuilderProvider distributionPackageBuilderProvider) {
        if (this.packageBuilderProvider == distributionPackageBuilderProvider) {
            this.packageBuilderProvider = null;
        }
    }
}

