/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.sling.commons.threads.ModifiableThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.impl.ExtendedThreadFactory;
import org.apache.sling.commons.threads.impl.ThreadLocalChangeListener;
import org.apache.sling.commons.threads.impl.ThreadPoolExecutorCleaningThreadLocals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThreadPool
implements ThreadPool {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String name;
    protected ThreadPoolExecutor executor;
    protected final ModifiableThreadPoolConfig configuration;

    public DefaultThreadPool(String name, ThreadPoolConfig origConfig) {
        SynchronousQueue<Runnable> queue;
        ThreadFactory delegateThreadFactory;
        this.name = name != null ? name : "default";
        this.logger.info("Initializing thread pool [{}]  ...", (Object)this.name);
        this.configuration = new ModifiableThreadPoolConfig(origConfig);
        if (this.configuration.getFactory() == null) {
            this.logger.debug("Thread pool [{}] ; No ThreadFactory is configured. Will use JVM default thread factory: {}", (Object)this.name, (Object)ExtendedThreadFactory.class.getName());
            delegateThreadFactory = Executors.defaultThreadFactory();
        } else {
            delegateThreadFactory = this.configuration.getFactory();
        }
        if (this.configuration.getMinPoolSize() < 0) {
            this.configuration.setMinPoolSize(1);
            this.logger.warn("min-pool-size < 0 for pool \"" + this.name + "\". Set to 1");
        }
        if (this.configuration.getMaxPoolSize() < 0) {
            this.configuration.setMaxPoolSize(Integer.MAX_VALUE);
        }
        ExtendedThreadFactory threadFactory = new ExtendedThreadFactory(delegateThreadFactory, this.name, this.configuration.getPriority(), this.configuration.isDaemon());
        if (this.configuration.getKeepAliveTime() < 0L) {
            this.configuration.setKeepAliveTime(1000L);
            this.logger.warn("keep-alive-time-ms < 0 for pool \"" + this.name + "\". Set to 1000");
        }
        if (this.configuration.getQueueSize() != 0) {
            if (this.configuration.getQueueSize() > 0) {
                queue = new ArrayBlockingQueue(this.configuration.getQueueSize());
            } else {
                if (this.configuration.getMinPoolSize() < this.configuration.getMaxPoolSize()) {
                    this.logger.info("min-pool-size (" + this.configuration.getMinPoolSize() + ") < max-pool-size (" + this.configuration.getMaxPoolSize() + ") for pool \"" + this.name + "\" which has unbounded queue (queue size -1). Set to " + this.configuration.getMaxPoolSize());
                    this.configuration.setMinPoolSize(this.configuration.getMaxPoolSize());
                }
                queue = new LinkedBlockingQueue();
            }
        } else {
            queue = new SynchronousQueue();
        }
        RejectedExecutionHandler handler = null;
        switch (this.configuration.getBlockPolicy()) {
            case ABORT: {
                handler = new ThreadPoolExecutor.AbortPolicy();
                break;
            }
            case DISCARD: {
                handler = new ThreadPoolExecutor.DiscardPolicy();
                break;
            }
            case DISCARDOLDEST: {
                handler = new ThreadPoolExecutor.DiscardOldestPolicy();
                break;
            }
            case RUN: {
                handler = new ThreadPoolExecutor.CallerRunsPolicy();
            }
        }
        try {
            this.executor = new ThreadPoolExecutorCleaningThreadLocals(this.configuration.getMinPoolSize(), this.configuration.getMaxPoolSize(), this.configuration.getKeepAliveTime(), TimeUnit.MILLISECONDS, queue, threadFactory, handler, new LoggingThreadLocalChangeListener());
        }
        catch (Error | RuntimeException e) {
            this.logger.warn("Unsupported JRE, cannot register ThreadPoolExecutorCleaningThreadLocals due to '{}', fall back to regular ThreadPoolExecutor", (Object)e.getMessage(), (Object)e);
            this.executor = new ThreadPoolExecutor(this.configuration.getMinPoolSize(), this.configuration.getMaxPoolSize(), this.configuration.getKeepAliveTime(), TimeUnit.MILLISECONDS, queue, threadFactory, handler);
        }
        this.logger.info("Thread pool [{}] initialized.", (Object)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ThreadPoolConfig getConfiguration() {
        return this.configuration;
    }

    @Override
    public void execute(Runnable runnable) {
        this.checkExecutor();
        if (runnable != null) {
            if (this.logger.isDebugEnabled()) {
                this.logOperation("Executing runnable: ", runnable);
            }
            this.executor.execute(runnable);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        this.checkExecutor();
        if (this.logger.isDebugEnabled()) {
            this.logOperation("Submitting callable: ", callable);
        }
        return this.executor.submit(callable);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        this.checkExecutor();
        if (this.logger.isDebugEnabled()) {
            this.logOperation("Submitting runnable: ", runnable);
        }
        return this.executor.submit(runnable);
    }

    public void shutdown() {
        this.logger.info("Shutting down thread pool [{}] ...", (Object)this.name);
        if (this.executor != null) {
            if (this.configuration.isShutdownGraceful()) {
                this.executor.shutdown();
            } else {
                this.executor.shutdownNow();
            }
            try {
                if (this.configuration.getShutdownWaitTimeMs() > 0 && !this.executor.awaitTermination(this.configuration.getShutdownWaitTimeMs(), TimeUnit.MILLISECONDS)) {
                    this.logger.warn("Running commands have not terminated within " + this.configuration.getShutdownWaitTimeMs() + "ms. Will shut them down by interruption");
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                this.logger.error("Cannot shutdown thread pool [" + this.name + "]", (Throwable)ie);
            }
            this.executor = null;
        }
        this.logger.info("Thread pool [{}] is shut down.", (Object)this.name);
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    private void checkExecutor() {
        if (this.executor == null) {
            throw new RejectedExecutionException("Thread pool " + this.name + " is already shutdown.");
        }
    }

    private void logOperation(String msg, Object obj) {
        this.logger.debug("{} {}, pool={}, active={}, corePoolSize={}, maxPoolSize={}, queueSize={}", new Object[]{msg, obj, this.name, this.executor.getActiveCount(), this.executor.getCorePoolSize(), this.executor.getMaximumPoolSize(), this.executor.getQueue().size()});
    }

    private static class LoggingThreadLocalChangeListener
    implements ThreadLocalChangeListener {
        private LoggingThreadLocalChangeListener() {
        }

        @Override
        public void changed(ThreadLocalChangeListener.Mode mode, Thread thread, ThreadLocal<?> threadLocal, Object value) {
            LOGGER.debug("Thread '{}' {} ThreadLocal {} with value {}", new Object[]{thread, mode, threadLocal != null ? threadLocal.getClass() : "<null>", value});
        }

        @Override
        public boolean isEnabled() {
            return LOGGER.isDebugEnabled();
        }
    }
}

