/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.update;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.nodes.update.SourceUpdateService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.Importer;
import org.apache.jackrabbit.vault.fs.io.ZipStreamArchive;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Composum Nodes Source Update Service : service to update content trees from XML"})
public class SourceUpdateServiceImpl
implements SourceUpdateService {
    private static final Logger LOG = LoggerFactory.getLogger(SourceUpdateServiceImpl.class);
    private static final Collection<String> ignoredMetadataAttributes = new HashSet<String>(Arrays.asList("jcr:uuid", "jcr:lastModified", "jcr:lastModifiedBy", "jcr:created", "jcr:createdBy", "jcr:isCheckedOut", "jcr:baseVersion", "jcr:versionHistory", "jcr:predecessors", "jcr:mergeFailed", "jcr:mergeFailed", "jcr:configuration", "jcr:activity", "jcr:etag", "rep:hold", "rep:retentionPolicy", "rep:versions", "jcr:mixinTypes"));
    private static final Collection<String> noRemoveNodeNames = new HashSet<String>(Arrays.asList("rep:policy", "oak:index", "rep:repoPolicy"));
    private static final Collection<String> noRemoveMixins = new HashSet<String>(Arrays.asList("rep:AccessControllable", "rep:RepoAccessControllable", "rep:Impersonatable", "rep:VersionablePaths", "rep:VersionReference", "rep:RetentionManageable", "mix:indexable"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFromZip(@NotNull ResourceResolver resolver, @NotNull InputStream rawZipInputStream, @NotNull String nodePath) throws IOException, RepositoryException {
        Importer importer;
        Session session = Objects.requireNonNull((Session)resolver.adaptTo(Session.class));
        Resource tmpdir = this.makeTempdir(resolver);
        String tmpPath = tmpdir.getPath();
        ImportErrorListener errorListener = new ImportErrorListener();
        ZipStreamArchive archive = new ZipStreamArchive(rawZipInputStream);
        try {
            importer = new Importer();
            importer.getOptions().setFilter((WorkspaceFilter)new DefaultWorkspaceFilter());
            importer.getOptions().setListener((ProgressTrackerListener)errorListener);
            archive.open(true);
            LOG.info("Importing {}", (Object)archive.getMetaInf().getProperties());
            importer.run((Archive)archive, session, tmpdir.getPath());
        }
        catch (IOException | RepositoryException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new IOException(e3);
        }
        finally {
            rawZipInputStream.close();
        }
        if (importer.hasErrors()) {
            StringBuilder buf = new StringBuilder("Errors during import: ");
            errorListener.errors.forEach(e -> buf.append((String)e.getLeft()).append(" : ").append(e.getRight()).append("\n"));
            throw new RepositoryException(buf.toString());
        }
        try {
            Resource topnode = tmpdir.getChild(nodePath.replaceFirst("^/+", ""));
            if (topnode == null) {
                throw new IllegalArgumentException("Archive does not contain given root path " + nodePath);
            }
            if (StringUtils.countMatches((CharSequence)nodePath, (CharSequence)"/") < 3) {
                throw new IllegalArgumentException("Suspicious / short root path: " + nodePath);
            }
            Resource resource = resolver.getResource(nodePath);
            if (resource == null) {
                throw new IllegalArgumentException("Node does not exist, so we cannot update it: " + nodePath);
            }
            this.equalize(topnode, resource, session);
            LOG.info("Have changes: {}", (Object)session.hasPendingChanges());
            session.save();
        }
        finally {
            session.refresh(false);
            if (resolver.getResource(tmpPath) != null) {
                session.removeItem(tmpdir.getPath());
            }
            session.save();
        }
    }

    protected Resource makeTempdir(ResourceResolver resolver) throws RepositoryException {
        String path = "/tmp/composum/nodes/SourceUpdateService/" + UUID.randomUUID().toString();
        return ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)path, (String)"sling:Folder");
    }

    private void equalize(@NotNull Resource templateresource, @NotNull Resource resource, Session session) throws PersistenceException, RepositoryException {
        boolean thisNodeChanged = false;
        ValueMap templatevalues = ResourceUtil.getValueMap((Resource)templateresource);
        ModifiableValueMap newvalues = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (newvalues == null) {
            throw new IllegalArgumentException("Node not modifiable: " + resource.getPath());
        }
        try {
            this.copyTypeInformation(templatevalues, newvalues);
            this.checkForSamenameSiblings(templateresource, resource);
            for (Map.Entry entry : templatevalues.entrySet()) {
                if (ignoredMetadataAttributes.contains(entry.getKey()) || Objects.deepEquals(entry.getValue(), newvalues.get(entry.getKey()))) continue;
                thisNodeChanged = true;
                if (this.isArray(entry.getValue()) != this.isArray(newvalues.get(entry.getKey()))) {
                    newvalues.remove(entry.getKey());
                }
                newvalues.put((Object)((String)entry.getKey()), entry.getValue());
            }
            for (String key : new HashSet(newvalues.keySet())) {
                if (ignoredMetadataAttributes.contains(key) || templatevalues.containsKey((Object)key)) continue;
                thisNodeChanged = true;
                newvalues.remove((Object)key);
            }
            for (Object child : resource.getChildren()) {
                Resource templateChild = templateresource.getChild(child.getName());
                if (templateChild == null) {
                    if (noRemoveNodeNames.contains(child.getName()) || ResourceUtil.isSyntheticResource((Resource)child)) continue;
                    thisNodeChanged = true;
                    try {
                        resource.getResourceResolver().delete((Resource)child);
                        continue;
                    }
                    catch (RuntimeException | PersistenceException e) {
                        LOG.error("Can't delete {}", (Object)child.getPath(), (Object)e);
                        throw e;
                    }
                }
                this.equalize(templateChild, (Resource)child, session);
            }
            List templatechildren = IteratorUtils.toList((Iterator)templateresource.listChildren());
            for (Resource templateChild : templateresource.getChildren()) {
                if (null != resource.getChild(templateChild.getName())) continue;
                session.move(templateChild.getPath(), resource.getPath() + "/" + templateChild.getName());
                thisNodeChanged = true;
            }
            this.ensureSameOrdering(templatechildren, resource);
            if (thisNodeChanged) {
                Resource modifcandidate;
                for (modifcandidate = resource; modifcandidate != null && !ResourceUtil.isNodeType((Resource)modifcandidate, (String)"mix:lastModified"); modifcandidate = modifcandidate.getParent()) {
                }
                if (modifcandidate != null) {
                    ResourceHandle.use((Resource)modifcandidate).setProperty("jcr:lastModified", Calendar.getInstance());
                }
            }
        }
        catch (RuntimeException | RepositoryException | PersistenceException e) {
            LOG.error("Error at {} : {}", (Object)resource.getPath(), (Object)e.toString());
            throw e;
        }
    }

    protected boolean isArray(Object value) {
        return value != null && value.getClass().isArray();
    }

    private void copyTypeInformation(ValueMap templatevalues, ModifiableValueMap newvalues) {
        newvalues.put((Object)"jcr:primaryType", templatevalues.get((Object)"jcr:primaryType"));
        ArrayList<String> newMixins = new ArrayList<String>(Arrays.asList((String[])templatevalues.get("jcr:mixinTypes", (Object)new String[0])));
        for (String mixin : (String[])newvalues.get("jcr:mixinTypes", (Object)new String[0])) {
            if (!noRemoveMixins.contains(mixin) || newMixins.contains(mixin)) continue;
            newMixins.add(mixin);
        }
        if (!newMixins.isEmpty() || newvalues.containsKey((Object)"jcr:mixinTypes")) {
            newvalues.put((Object)"jcr:mixinTypes", (Object)newMixins.toArray(new String[0]));
        }
    }

    private void ensureSameOrdering(List<Resource> templatechildren, Resource resource) throws RepositoryException {
        if (((Node)resource.adaptTo(Node.class)).getPrimaryNodeType().hasOrderableChildNodes()) {
            templatechildren = this.filterNoRemoveNodes(templatechildren);
            Node node = Objects.requireNonNull((Node)resource.adaptTo(Node.class));
            List<Resource> resourcechildren = this.filterNoRemoveNodes(IteratorUtils.toList((Iterator)resource.listChildren()));
            if (templatechildren.size() != resourcechildren.size()) {
                throw new IllegalStateException("Bug: template and resource of " + resource.getPath() + " should have same size now but have " + templatechildren.size() + " and " + resourcechildren.size());
            }
            if (resourcechildren.size() < 2) {
                return;
            }
            for (int i = 0; i < resourcechildren.size(); ++i) {
                if (StringUtils.equals((CharSequence)resourcechildren.get(i).getName(), (CharSequence)templatechildren.get(i).getName())) continue;
                node.orderBefore(templatechildren.get(i).getName(), resourcechildren.get(i).getName());
                resourcechildren = this.filterNoRemoveNodes(IteratorUtils.toList((Iterator)resource.listChildren()));
            }
        }
    }

    private List<Resource> filterNoRemoveNodes(List<Resource> children) {
        return children.stream().filter(r -> !noRemoveNodeNames.contains(r.getName())).collect(Collectors.toList());
    }

    private void checkForSamenameSiblings(Resource templateresource, @NotNull Resource resource) throws IllegalArgumentException, RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        NodeDefinition definition = node.getDefinition();
        if (definition.allowsSameNameSiblings()) {
            HashSet<String> nodenames = new HashSet<String>();
            for (Resource child : templateresource.getChildren()) {
                if (nodenames.contains(child.getName())) {
                    throw new IllegalArgumentException("Equally named children not supported yet: existing resource " + templateresource.getPath() + " has two " + child.getName());
                }
                nodenames.add(child.getName());
            }
            nodenames.clear();
            for (Resource child : resource.getChildren()) {
                if (nodenames.contains(child.getName())) {
                    throw new IllegalArgumentException("Equally named children not supported yet: imported resource " + resource.getPath() + " has two " + child.getName());
                }
                nodenames.add(child.getName());
            }
        }
    }

    protected static class ImportErrorListener
    implements ProgressTrackerListener {
        public final List<Pair<String, Exception>> errors = new ArrayList<Pair<String, Exception>>();

        protected ImportErrorListener() {
        }

        public void onMessage(ProgressTrackerListener.Mode mode, String action, String path) {
            LOG.debug("Import message {} : {} : {}", new Object[]{mode, action, path});
        }

        public void onError(ProgressTrackerListener.Mode mode, String path, Exception e) {
            this.errors.add((Pair<String, Exception>)Pair.of((Object)path, (Object)e));
            LOG.debug("Import error {} : {} : {}", new Object[]{mode, path, String.valueOf(e)});
        }
    }
}

