/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.tools;

import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.servlet.NodeTreeServlet;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.tika.io.IOUtils;
import org.apache.tika.mime.MimeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="system/runtime/files")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Runtime File Servlet", "sling.servlet.paths=/bin/cpm/system/file", "sling.servlet.methods=GET"})
public class RuntimeFileServlet
extends SlingSafeMethodsServlet
implements RestrictedService {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeFileServlet.class);
    public static final String SERVICE_KEY = "system/runtime/files";
    public static final String PATH_RESTRICTION_PREFIX = "path:";
    public static final String SERVLET_LABEL = "Composum Runtime File Servlet";
    public static final String SERVLET_PATH = "/bin/cpm/system/file";
    public static final Pattern IS_LOGFILE = Pattern.compile("^((/.*)?/)?.+\\.log(\\.[\\d-]+)?$");
    public static final String SA_SESSIONS = RuntimeFileServlet.class.getName() + "#session";
    public static final String RUNTIME_ROOT = new File(".").getAbsolutePath();
    @Reference
    protected ServiceRestrictions restrictions;
    private ServiceRestrictions.Key serviceKey;
    private ServiceRestrictions.Permission permission;
    private boolean enabled = false;
    private Pattern fileRestrictions;

    protected void activate() {
        this.serviceKey = new ServiceRestrictions.Key(SERVICE_KEY);
        this.permission = this.restrictions.getPermission(this.serviceKey);
        this.enabled = this.permission != ServiceRestrictions.Permission.none;
        String pattern = this.restrictions.getRestrictions(this.serviceKey);
        if (StringUtils.isNotBlank((CharSequence)pattern) && pattern.startsWith(PATH_RESTRICTION_PREFIX)) {
            pattern = pattern.substring(PATH_RESTRICTION_PREFIX.length());
        }
        this.fileRestrictions = StringUtils.isNotBlank((CharSequence)pattern) ? Pattern.compile(pattern) : null;
    }

    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return this.serviceKey;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final ServiceRestrictions.Permission getPermission() {
        return this.permission;
    }

    @Nullable
    protected RuntimeFile getFile(@NotNull SlingHttpServletRequest request, @Nullable String suffix) {
        File file;
        RuntimeFile rtFile = null;
        if (suffix != null && (file = new File("." + suffix)).exists()) {
            RuntimeFile candidate = new RuntimeFile(request, file);
            if (this.isEnabled() && (this.fileRestrictions == null || this.fileRestrictions.matcher(candidate.getPath()).matches())) {
                rtFile = candidate;
            }
        }
        return rtFile;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        if (this.isEnabled()) {
            RequestPathInfo pathInfo = request.getRequestPathInfo();
            String suffix = pathInfo.getSuffix();
            String[] selectors = pathInfo.getSelectors();
            if (selectors.length > 0) {
                switch (selectors[0]) {
                    case "tree": {
                        this.treeNode(request, response, suffix);
                        return;
                    }
                    case "tail": {
                        this.tailLogfile(request, response, selectors, suffix);
                        return;
                    }
                }
            }
            this.downloadFile(request, response, suffix);
        } else {
            response.sendError(403);
        }
    }

    protected void downloadFile(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable String suffix) throws IOException {
        File file;
        RuntimeFile rtFile = this.getFile(request, suffix);
        if (rtFile != null && (file = rtFile.getFile()).isFile() && file.canRead()) {
            LogfileFilter filter;
            MimeType mimeType = rtFile.getMimeType();
            response.setContentType(mimeType != null ? mimeType.toString() : "text/plain");
            response.setHeader("Content-Disposition", "attachment; filename=" + rtFile.getName());
            response.setDateHeader("Last-Modified", file.lastModified());
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            if (rtFile.isLog && (filter = new LogfileFilter(request)).isFilter()) {
                PrintWriter writer = response.getWriter();
                try (RandomAccessFile fileAccess = new RandomAccessFile(file, "r");){
                    String line;
                    while ((line = filter.readLine(fileAccess)) != null) {
                        writer.println(line);
                    }
                }
            } else {
                try (FileInputStream in = new FileInputStream(file);){
                    IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
                }
            }
        } else {
            response.sendError(403);
        }
    }

    protected void tailLogfile(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull String[] selectors, @Nullable String suffix) throws IOException {
        LoggerSession loggerSession = this.getLoggerSession(request, suffix);
        if (loggerSession != null) {
            Long position = selectors.length > 1 ? Long.valueOf(Long.parseLong(selectors[1])) : null;
            Long limit = selectors.length > 2 ? Long.valueOf(Long.parseLong(selectors[2])) : null;
            String filter = request.getParameter("filter");
            String around = request.getParameter("around");
            response.setContentType("text/plain");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            loggerSession.tail(response.getWriter(), position, limit, new LogfileFilter(request));
        } else {
            response.sendError(403);
        }
    }

    protected LoggerSession getLoggerSession(@NotNull SlingHttpServletRequest request, @Nullable String path) {
        HttpSession httpSession;
        LoggerSession loggerSession = null;
        if (StringUtils.isNotBlank((CharSequence)path) && (httpSession = request.getSession(true)) != null) {
            HashMap<String, LoggerSession> sessionSet = null;
            try {
                sessionSet = (HashMap<String, LoggerSession>)httpSession.getAttribute(SA_SESSIONS);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (sessionSet == null) {
                sessionSet = new HashMap<String, LoggerSession>();
                httpSession.setAttribute(SA_SESSIONS, sessionSet);
            }
            try {
                loggerSession = (LoggerSession)sessionSet.get(path);
            }
            catch (ClassCastException ignore) {
                sessionSet = new HashMap();
                httpSession.setAttribute(SA_SESSIONS, sessionSet);
            }
            if (loggerSession == null) {
                File file;
                RuntimeFile rtFile = this.getFile(request, path);
                if (rtFile != null && (file = rtFile.getFile()).isFile() && file.canRead()) {
                    loggerSession = new LoggerSession(rtFile, new LogfileFilter(request));
                    sessionSet.put(path, loggerSession);
                } else {
                    LOG.error("can't read file '{}' ({})", (Object)(rtFile != null ? rtFile.getPath() : "???"), (Object)path);
                }
            }
        }
        return loggerSession;
    }

    protected void treeNode(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable String suffix) throws IOException {
        RuntimeFile rtFile = this.getFile(request, suffix);
        if (rtFile != null) {
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginObject();
            this.writeFileNode(request, writer, rtFile);
            writer.endObject();
        } else {
            response.sendError(403);
        }
    }

    protected void writeFileNode(@NotNull SlingHttpServletRequest request, @NotNull JsonWriter writer, @NotNull RuntimeFile rtFile) throws IOException {
        this.writeFileIdentifiers(request, writer, rtFile);
        writer.name("children").beginArray();
        File[] files = rtFile.file.listFiles();
        TreeSet<File> fileSet = new TreeSet<File>(Comparator.comparing(o -> (o.isDirectory() ? "0:" : "1:") + o.getName()));
        fileSet.addAll(Arrays.asList(files != null ? files : new File[]{}));
        for (File child : fileSet) {
            RuntimeFile rtChild = new RuntimeFile(request, child);
            if (this.fileRestrictions != null && !this.fileRestrictions.matcher(rtChild.getPath()).matches()) continue;
            writer.beginObject();
            this.writeFileIdentifiers(request, writer, new RuntimeFile(request, child));
            writer.name("state").beginObject();
            writer.name("loaded").value(false);
            writer.endObject();
            writer.endObject();
        }
        writer.endArray();
    }

    protected void writeFileIdentifiers(@NotNull SlingHttpServletRequest request, @NotNull JsonWriter writer, @NotNull RuntimeFile rtFile) throws IOException {
        File file = rtFile.getFile();
        writer.name("id").value(rtFile.getPath());
        writer.name("name").value(rtFile.getName());
        writer.name("text").value(rtFile.getName());
        writer.name("path").value(rtFile.getPath());
        MimeType mimeType = rtFile.getMimeType();
        if (mimeType != null) {
            writer.name("type").value("file-" + NodeTreeServlet.getMimeTypeKey((String)mimeType.toString()));
            writer.name("mimeType").value(mimeType.toString());
            writer.name("isText").value(rtFile.isText);
            writer.name("isLog").value(rtFile.isLog);
        } else {
            writer.name("type").value(file.isDirectory() ? "folder" : "file");
        }
        if (file.isFile()) {
            writer.name("size").value(file.length());
            writer.name("modified").value(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(file.lastModified())));
        }
        if (StringUtils.isNotBlank((CharSequence)rtFile.getUri())) {
            writer.name("uri").value(rtFile.getUri());
        }
    }

    public static class LoggerSession
    implements Serializable {
        private final RuntimeFile rtFile;
        private LogfileFilter logfileFilter;
        private long lastPosition = 0L;

        public LoggerSession(@NotNull RuntimeFile rtFile, @NotNull LogfileFilter filter) {
            this.rtFile = rtFile;
            this.logfileFilter = filter;
        }

        public synchronized void tail(@NotNull PrintWriter writer, @Nullable Long position, @Nullable Long limit, @NotNull LogfileFilter filter) {
            if (position == null && this.logfileFilter.equals(filter)) {
                position = this.lastPosition;
            } else {
                this.logfileFilter = filter;
                position = 0L;
            }
            File file = this.rtFile.getFile();
            long length = file.length();
            if (position < length) {
                try (RandomAccessFile fileAccess = new RandomAccessFile(file, "r");){
                    String line;
                    if (limit != null && limit > 0L) {
                        long count = limit;
                        long limitStart = length;
                        while (count > 0L && limitStart > position) {
                            fileAccess.seek(--limitStart);
                            if (fileAccess.readByte() != 10) continue;
                            --count;
                        }
                        while (limitStart > 0L) {
                            fileAccess.seek(--limitStart);
                            if (fileAccess.readByte() != 10) continue;
                            ++limitStart;
                            break;
                        }
                        if (limitStart > position) {
                            position = limitStart;
                        }
                    }
                    fileAccess.seek(position);
                    while ((line = this.logfileFilter.readLine(fileAccess)) != null) {
                        writer.println(line);
                    }
                    this.lastPosition = fileAccess.getFilePointer();
                }
                catch (IOException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public static class RuntimeFile
    implements Serializable {
        private final File file;
        private final String name;
        private final String path;
        private final String uri;
        private final MimeType mimeType;
        private final boolean isText;
        private final boolean isLog;

        public RuntimeFile(@NotNull SlingHttpServletRequest request, @NotNull File file) {
            this.file = file;
            String path = file.getAbsolutePath();
            if (path.startsWith(RUNTIME_ROOT)) {
                path = path.substring(RUNTIME_ROOT.length());
            }
            if (StringUtils.isBlank((CharSequence)path)) {
                path = "/";
            }
            this.path = path;
            String string = this.name = "/".equals(this.path) ? "/" : file.getName();
            if (this.file.isFile()) {
                this.mimeType = MimeTypeUtil.getMimeType((String)this.name.replaceAll("\\.log\\.[\\d-]+$", ".log"));
                this.uri = request.getContextPath() + RuntimeFileServlet.SERVLET_PATH + (this.mimeType != null ? this.mimeType.getExtension() : ".bin") + this.path;
            } else {
                this.mimeType = null;
                this.uri = null;
            }
            this.isText = this.mimeType != null && this.mimeType.toString().startsWith("text/");
            this.isLog = this.isText && IS_LOGFILE.matcher(path).matches();
        }

        @NotNull
        public File getFile() {
            return this.file;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        @Nullable
        public String getUri() {
            return this.uri;
        }

        @Nullable
        public MimeType getMimeType() {
            return this.mimeType;
        }

        public boolean isText() {
            return this.isText;
        }

        public boolean isLog() {
            return this.isLog;
        }
    }

    public static class LogfileFilter
    implements Serializable {
        protected final Pattern pattern;
        protected final int prepend;
        protected final int append;
        protected int more = 0;
        protected boolean matched = false;
        protected boolean skipped = false;
        protected boolean flushed = false;
        protected boolean flushBuffer = false;
        protected final List<String> buffer = new ArrayList<String>();

        public LogfileFilter(@Nullable Pattern pattern, int prepend, int append) {
            this.pattern = pattern;
            this.prepend = prepend;
            this.append = append;
        }

        public LogfileFilter(@NotNull SlingHttpServletRequest request) {
            String filter = request.getParameter("filter");
            String[] around = StringUtils.split((String)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"around", (String)"3,1"), (String)",");
            this.pattern = StringUtils.isNotBlank((CharSequence)filter) ? Pattern.compile(filter) : null;
            this.prepend = around.length > 0 ? this.getInt(around[0], 3) : 3;
            this.append = around.length > 1 ? this.getInt(around[1], 1) : 1;
        }

        protected int getInt(@Nullable String str, int defaultValue) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                try {
                    return Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        public LogfileFilter(@NotNull LogfileFilter template) {
            this(template.pattern, template.prepend, template.append);
        }

        public String toString() {
            return (this.pattern != null ? this.pattern.toString() : "") + "${" + this.prepend + "," + this.append + "}";
        }

        public boolean equals(Object other) {
            return other instanceof LogfileFilter && this.toString().equals(other.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean isFilter() {
            return this.pattern != null;
        }

        @Nullable
        public String readLine(@NotNull RandomAccessFile fileAccess) throws IOException {
            if (this.isFilter()) {
                String line;
                String result = null;
                if (!this.flushBuffer || this.buffer.size() < 1 && this.more < 1) {
                    this.flushBuffer = false;
                    while (!this.flushBuffer && (line = fileAccess.readLine()) != null) {
                        this.buffer.add(line);
                        if (this.checkMatch(line) || this.buffer.size() <= this.prepend) continue;
                        this.buffer.remove(0);
                        this.skipped = true;
                    }
                    if (this.flushBuffer && this.flushed && this.skipped) {
                        this.buffer.add(0, "----");
                    }
                }
                if (this.flushBuffer && (this.buffer.size() > 0 || this.more > 0)) {
                    this.flushed = true;
                    this.skipped = false;
                    if (this.buffer.size() < 1) {
                        --this.more;
                        line = fileAccess.readLine();
                        this.checkMatch(line);
                        return line;
                    }
                    result = this.buffer.get(0);
                    this.buffer.remove(0);
                }
                return result;
            }
            return fileAccess.readLine();
        }

        protected boolean checkMatch(@Nullable String line) {
            Matcher matcher;
            if (line != null && ((matcher = this.pattern.matcher(line)).find() || this.matched && line.matches("^(Caused)?\\s+.*$"))) {
                this.matched = true;
                this.flushBuffer = true;
                this.more = this.append;
                return true;
            }
            this.matched = false;
            return false;
        }
    }
}

