/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.tools;

import com.composum.sling.core.AbstractSlingBean;
import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.nodes.tools.OsgiBundlesModel;
import com.composum.sling.nodes.tools.OsgiServiceModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

@Restricted(key="system/osgi/bundles")
public class OsgiBundleModel
extends AbstractSlingBean {
    public static final Pattern BUNDLE_ID_SUFFIX = Pattern.compile("/(?<id>[0-9]+)$");
    public static final String HD_ARCHIVER_VERSION = "Archiver Version";
    public static final String HD_BUNDLE_CATEGORY = "Category";
    public static final String HD_BUNDLE_LICENSE = "License";
    public static final String HD_BUNDLE_NAME = "Name";
    public static final String HD_BUNDLE_VENDOR = "Vendor";
    public static final String HD_CREATED_BY = "Created By";
    public static final String HD_DESCRIPTION = "Description";
    public static final String HD_DYNAMIC_IMPORT_PACKAGE = "Dynamic Import";
    public static final String HD_EMBED_DEPENDENCY = "Embed Dependency";
    public static final String HD_EXPORT_PACKAGE = "Export Package";
    public static final String HD_IMPLEMENTATION_BUILD = "Implementation Build";
    public static final String HD_IMPLEMENTATION_TITLE = "Implementation Title";
    public static final String HD_IMPLEMENTATION_VENDOR = "Implementation Vendor";
    public static final String HD_IMPLEMENTATION_VENDOR_ID = "Impl. Vendor-Id";
    public static final String HD_IMPLEMENTATION_VERSION = "Implementation Version";
    public static final String HD_IMPORT_PACKAGE = "Import Package";
    public static final String HD_INCLUDE_RESOURCE = "Include Resource";
    public static final String HD_PRIVATE_PACKAGE = "Private Package";
    public static final String HD_PROVIDE_CAPABILITY = "Provide Capability";
    public static final String HD_REQUIRE_CAPABILITY = "Require Capability";
    public static final String HD_REQ_EXEC_ENVIRONMENT = "Required Environment";
    public static final String HD_SERVICE_COMPONENT = "Service Component";
    public static final String HD_SPECIFICATION_TITLE = "Specification Title";
    public static final String HD_SPECIFICATION_VENDOR = "Specification Vendor";
    public static final String HD_SPECIFICATION_VERSION = "Specification Version";
    public static final Map<String, String> HEADER_NAME_MAP = new TreeMap<String, String>();
    public static final List<String> REFERENCE_NAMES;
    protected Bundle bundle;
    protected Map<String, String> headers;
    protected String name;
    protected String category;
    private transient State state;
    private transient Boolean fragment;
    private transient Map<String, Imported> importedSet;
    private transient Map<String, Exported> exportedSet;
    private transient Map<String, Resolved> resolvedSet;
    private transient BundleContext bundleContext;
    public static final Pattern PACKAGE_REF_START;
    public static final Pattern PACKAGE_REF_OPTION;

    public void initialize(BeanContext context, Resource resource) {
        Bundle bundle;
        Matcher matcher;
        super.initialize(context, resource);
        RequestPathInfo pathInfo = context.getRequest().getRequestPathInfo();
        String suffix = pathInfo.getSuffix();
        if (suffix != null && (matcher = BUNDLE_ID_SUFFIX.matcher(suffix)).matches() && (bundle = this.getBundleContext().getBundle(Long.parseLong(matcher.group("id")))) != null) {
            this.initialize(bundle);
        }
    }

    protected void initialize(@NotNull Bundle bundle) {
        this.bundle = bundle;
        this.headers = new TreeMap<String, String>();
        Dictionary bundleHeaders = bundle.getHeaders();
        Enumeration keys = bundleHeaders.keys();
        block8: while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String name = HEADER_NAME_MAP.get(key);
            if (name == null) continue;
            String value = (String)bundleHeaders.get(key);
            switch (name) {
                case "Name": {
                    this.name = value;
                    continue block8;
                }
                case "Category": {
                    this.category = value;
                    continue block8;
                }
            }
            this.headers.put(name, (String)bundleHeaders.get(key));
        }
    }

    public boolean isValid() {
        return this.bundle != null;
    }

    public boolean isFragment() {
        if (this.fragment == null) {
            this.fragment = OsgiBundleModel.isFragment(this.bundle);
        }
        return this.fragment;
    }

    protected static boolean isFragment(@NotNull Bundle bundle) {
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return revision != null && (revision.getTypes() & 1) != 0;
    }

    @NotNull
    public Long getBundleId() {
        return this.bundle.getBundleId();
    }

    @NotNull
    public Set<Map.Entry<String, String>> getHeaders() {
        return this.headers.entrySet();
    }

    @NotNull
    public String getName() {
        return this.name != null ? this.name : this.getSymbolicName();
    }

    @NotNull
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @NotNull
    public String getCategory() {
        return this.category;
    }

    @NotNull
    public State getState() {
        if (this.state == null) {
            this.state = OsgiBundleModel.getState(this.bundle);
        }
        return this.state;
    }

    protected static State getState(@NotNull Bundle bundle) {
        State state = State.valueOf(bundle.getState());
        if (OsgiBundleModel.isFragment(bundle) && state == State.resolved) {
            state = State.fragment;
        }
        return state;
    }

    public boolean isActive() {
        State state = this.getState();
        return state == State.active || state == State.fragment;
    }

    protected static boolean isActive(Bundle bundle) {
        State state = OsgiBundleModel.getState(bundle);
        return state == State.active || state == State.fragment;
    }

    @NotNull
    public String getLastModified() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.bundle.getLastModified()));
    }

    @NotNull
    public String getVersion() {
        return this.bundle.getVersion().toString();
    }

    @NotNull
    public String getLocation() {
        return this.bundle.getLocation();
    }

    @NotNull
    public Iterator<OsgiServiceModel> getProvidedServices() {
        ServiceReference[] registered = this.bundle.getRegisteredServices();
        final Iterator services = Stream.of(registered != null ? registered : new ServiceReference[]{}).iterator();
        return new Iterator<OsgiServiceModel>(){

            @Override
            public boolean hasNext() {
                return services.hasNext();
            }

            @Override
            public OsgiServiceModel next() {
                return new OsgiServiceModel((ServiceReference)services.next());
            }
        };
    }

    @NotNull
    public Iterator<OsgiServiceModel> getUsedServices() {
        ServiceReference[] registered = this.bundle.getServicesInUse();
        final Iterator services = Stream.of(registered != null ? registered : new ServiceReference[]{}).iterator();
        return new Iterator<OsgiServiceModel>(){

            @Override
            public boolean hasNext() {
                return services.hasNext();
            }

            @Override
            public OsgiServiceModel next() {
                return new OsgiServiceModel((ServiceReference)services.next());
            }
        };
    }

    public Collection<Exported> getExported() {
        return this.getExportedSet().values();
    }

    @Nullable
    public Exported getExported(@NotNull String symbolicName) {
        while (symbolicName.indexOf(46) > 0) {
            Exported exported = this.getExportedSet().get(symbolicName);
            if (exported != null) {
                return exported;
            }
            symbolicName = symbolicName.substring(0, symbolicName.lastIndexOf(46));
        }
        return null;
    }

    public Map<String, Exported> getExportedSet() {
        if (this.exportedSet == null) {
            this.exportedSet = new TreeMap<String, Exported>();
            PackageSet packageSet = this.scanPackgeReferences((String)this.bundle.getHeaders().get("Export-Package"));
            for (PackageReference pckgRef : packageSet.getPackages()) {
                String symbolicName = pckgRef.getName();
                String version = pckgRef.getVersion();
                this.exportedSet.put(symbolicName, new Exported(pckgRef.getName(), StringUtils.isNotBlank((CharSequence)version) ? new Version(version) : null));
            }
        }
        return this.exportedSet;
    }

    public Collection<Imported> getImported() {
        return this.getImportedSet().values();
    }

    @Nullable
    public Imported getImported(@NotNull String symbolicName) {
        return this.getImportedSet().get(symbolicName);
    }

    public Map<String, Imported> getImportedSet() {
        if (this.importedSet == null) {
            this.importedSet = new TreeMap<String, Imported>();
            PackageSet packageSet = this.scanPackgeReferences((String)this.bundle.getHeaders().get("Import-Package"));
            for (PackageReference pckgRef : packageSet.getPackages()) {
                String symbolicName = pckgRef.getName();
                String version = pckgRef.getVersion();
                if (this.getExported(symbolicName) != null) continue;
                this.importedSet.put(symbolicName, new Imported(pckgRef.getName(), StringUtils.isNotBlank((CharSequence)version) ? new VersionRange(version) : null, "optional".equals(pckgRef.getResolution())));
            }
            for (Imported imported : this.importedSet.values()) {
                imported.resolved = this.getResolved(imported.symbolicName);
            }
        }
        return this.importedSet;
    }

    public Collection<Resolved> getResolved() {
        return this.getResolvedSet().values();
    }

    @Nullable
    public Resolved getResolved(@NotNull String symbolicName) {
        while (symbolicName.indexOf(46) > 0) {
            Resolved resolved = this.getResolvedSet().get(symbolicName);
            if (resolved != null) {
                return resolved;
            }
            symbolicName = symbolicName.substring(0, symbolicName.lastIndexOf(46));
        }
        return null;
    }

    public Map<String, Resolved> getResolvedSet() {
        block6: {
            block7: {
                if (this.resolvedSet != null) break block6;
                this.resolvedSet = new TreeMap<String, Resolved>();
                BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
                if (wiring == null) break block7;
                List wires = wiring.getRequiredWires(null);
                for (BundleWire wire : wires) {
                    BundleCapability capability = wire.getCapability();
                    String symbolicName = (String)capability.getAttributes().get("osgi.wiring.package");
                    BundleRevision provider = wire.getProvider();
                    if (provider == null || !StringUtils.isNotBlank((CharSequence)symbolicName)) continue;
                    Version version = (Version)capability.getAttributes().get("version");
                    this.resolvedSet.put(symbolicName, new Resolved(provider.getBundle(), symbolicName, version));
                }
                break block6;
            }
            if (this.importedSet == null) break block6;
            OsgiBundlesModel bundles = new OsgiBundlesModel(this.context);
            for (OsgiBundleModel model : bundles.getBundles()) {
                Bundle bundle = model.bundle;
                List capabilities = ((BundleRevision)bundle.adapt(BundleRevision.class)).getDeclaredCapabilities(null);
                for (BundleCapability capability : capabilities) {
                    String symbolicName = (String)capability.getAttributes().get("osgi.wiring.package");
                    block3: for (Imported imported : this.importedSet.values()) {
                        if (!imported.symbolicName.equals(symbolicName)) continue;
                        Object value = capability.getAttributes().get("version");
                        if (value instanceof List) {
                            for (Version version : (List)value) {
                                if (imported.version != null && !imported.version.includes(version)) continue;
                                this.resolvedSet.put(symbolicName, new Resolved(bundle, symbolicName, version));
                                continue block3;
                            }
                            continue;
                        }
                        Version version = (Version)value;
                        if (imported.version != null && version != null && !imported.version.includes(version)) continue;
                        this.resolvedSet.put(symbolicName, new Resolved(bundle, symbolicName, version));
                    }
                }
            }
        }
        return this.resolvedSet;
    }

    @NotNull
    protected PackageSet scanPackgeReferences(@NotNull String references) {
        PackageSet result = new PackageSet();
        if (StringUtils.isNotBlank((CharSequence)references)) {
            int optPos;
            Matcher matcher = PACKAGE_REF_START.matcher(references);
            for (int pos = 0; matcher.find(pos) && matcher.start() == pos; pos += optPos) {
                PackageReference packageRef = new PackageReference(matcher.group("name"));
                pos = matcher.end();
                String tail = references.substring(pos);
                Matcher options = PACKAGE_REF_OPTION.matcher(tail);
                optPos = 0;
                while (options.find(optPos) && options.start() == optPos) {
                    String values = options.group("values");
                    packageRef.addOption(options.group("key"), StringUtils.isNotBlank((CharSequence)values) ? values : options.group("value"));
                    optPos = options.end();
                }
                result.add(packageRef);
            }
        }
        return result;
    }

    protected BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = FrameworkUtil.getBundle(BeanContext.class).getBundleContext();
        }
        return this.bundleContext;
    }

    public OsgiBundleModel(@NotNull BeanContext context, @NotNull Bundle bundle) {
        this.context = context;
        this.resource = ResourceHandle.use((Resource)context.getResource());
        this.initialize(bundle);
    }

    public OsgiBundleModel(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public OsgiBundleModel(BeanContext context) {
        super(context);
    }

    public OsgiBundleModel() {
    }

    static {
        HEADER_NAME_MAP.put("Bundle-Category", HD_BUNDLE_CATEGORY);
        HEADER_NAME_MAP.put("Bundle-License", HD_BUNDLE_LICENSE);
        HEADER_NAME_MAP.put("Bundle-Name", HD_BUNDLE_NAME);
        HEADER_NAME_MAP.put("Bundle-Vendor", HD_BUNDLE_VENDOR);
        HEADER_NAME_MAP.put("Bundle-Description", HD_DESCRIPTION);
        HEADER_NAME_MAP.put("DynamicImport-Package", HD_DYNAMIC_IMPORT_PACKAGE);
        HEADER_NAME_MAP.put("Implementation-Build", HD_IMPLEMENTATION_BUILD);
        HEADER_NAME_MAP.put("Implementation-Title", HD_IMPLEMENTATION_TITLE);
        HEADER_NAME_MAP.put("Implementation-Vendor", HD_IMPLEMENTATION_VENDOR);
        HEADER_NAME_MAP.put("Implementation-Vendor-Id", HD_IMPLEMENTATION_VENDOR_ID);
        HEADER_NAME_MAP.put("Implementation-Version", HD_IMPLEMENTATION_VERSION);
        HEADER_NAME_MAP.put("Private-Package", HD_PRIVATE_PACKAGE);
        HEADER_NAME_MAP.put("Bundle-RequiredExecutionEnvironment", HD_REQ_EXEC_ENVIRONMENT);
        HEADER_NAME_MAP.put("Specification-Title", HD_SPECIFICATION_TITLE);
        HEADER_NAME_MAP.put("Specification-Vendor", HD_SPECIFICATION_VENDOR);
        HEADER_NAME_MAP.put("Specification-Version", HD_SPECIFICATION_VERSION);
        REFERENCE_NAMES = Arrays.asList(HD_DYNAMIC_IMPORT_PACKAGE, HD_EXPORT_PACKAGE, HD_IMPORT_PACKAGE, HD_PRIVATE_PACKAGE);
        PACKAGE_REF_START = Pattern.compile("( *,)? *(?<name>[^ ;,]+)");
        PACKAGE_REF_OPTION = Pattern.compile(" *; *(?<key>[^:= \"']+) *:?= *(([\"'](?<values>[^\"']+)[\"'])|(?<value>[^;,]+))");
    }

    public class PackageSet {
        protected final Map<String, PackageReference> packages = new TreeMap<String, PackageReference>();

        public boolean isEmpty() {
            return this.packages.isEmpty();
        }

        @NotNull
        public Set<String> getKeys() {
            return this.packages.keySet();
        }

        public void add(@NotNull PackageReference packageRef) {
            this.packages.put(packageRef.getName(), packageRef);
        }

        public void remove(@NotNull String key) {
            this.packages.remove(key);
        }

        @NotNull
        public Collection<PackageReference> getPackages() {
            return this.packages.values();
        }
    }

    public class PackageReference {
        private final String name;
        private final Map<String, List<String>> options = new HashMap<String, List<String>>();

        public PackageReference(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getOption(@NotNull String key) {
            List<String> values = this.getOptionValues(key);
            return values != null ? StringUtils.join(values, (String)",") : null;
        }

        @Nullable
        public List<String> getOptionValues(@NotNull String key) {
            return this.options.get(key);
        }

        protected void addOption(@NotNull String key, @NotNull String value) {
            List values = this.options.computeIfAbsent(key, k -> new ArrayList());
            values.add(value);
        }

        @Nullable
        public String getVersion() {
            return this.getOption("version");
        }

        @Nullable
        public String getResolution() {
            return this.getOption("resolution");
        }

        @NotNull
        public String toString() {
            String version = this.getVersion();
            return this.name + (StringUtils.isNotBlank((CharSequence)version) ? ";" + version : "");
        }
    }

    public class Resolved {
        protected final Bundle bundle;
        protected final String symbolicName;
        protected final Version version;
        protected final boolean active;

        public Resolved(@NotNull Bundle bundle, @Nullable String symbolicName, Version version) {
            this.bundle = bundle;
            this.symbolicName = symbolicName;
            this.version = version;
            this.active = OsgiBundleModel.isActive(bundle);
        }
    }

    public class Imported {
        protected final String symbolicName;
        protected final VersionRange version;
        protected final boolean optional;
        protected Resolved resolved;

        public Imported(@Nullable String symbolicName, VersionRange version, boolean optional) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.optional = optional;
        }
    }

    public class Exported {
        protected final String symbolicName;
        protected final Version version;

        public Exported(@Nullable String symbolicName, Version version) {
            this.symbolicName = symbolicName;
            this.version = version;
        }
    }

    public static enum State {
        uninstalled(1),
        installed(2),
        resolved(4),
        starting(8),
        stopping(16),
        active(32),
        fragment(64);

        public final int value;
        static final Map<Integer, State> MAP;

        private State(int value) {
            this.value = value;
        }

        public static State valueOf(int value) {
            return MAP.get(value);
        }

        static {
            MAP = new HashMap<Integer, State>();
            for (State state : State.values()) {
                MAP.put(state.value, state);
            }
        }
    }
}

