/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/repository/versions")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Version Servlet", "sling.servlet.paths=/bin/cpm/nodes/version", "sling.servlet.methods=GET", "sling.servlet.methods=PUT", "sling.servlet.methods=POST", "sling.auth.requirements=/bin/cpm/nodes/version"})
public class VersionServlet
extends AbstractServiceServlet {
    public static final String SERVLET_PATH = "/bin/cpm/nodes/version";
    public static final String SERVICE_KEY = "nodes/repository/versions";
    private static final Logger LOG = LoggerFactory.getLogger(VersionServlet.class);
    @Reference
    private NodesConfiguration coreConfig;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.versions, (ServletOperation)new GetVersions());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.labels, (ServletOperation)new GetLabels());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.addlabel, (ServletOperation)new AddLabel());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.restore, (ServletOperation)new RestoreVersion());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, (Enum)Extension.json, (Enum)Operation.deletelabel, (ServletOperation)new DeleteLabel());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, (Enum)Extension.json, (Enum)Operation.version, (ServletOperation)new DeleteVersion());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.checkout, (ServletOperation)new CheckoutOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.checkin, (ServletOperation)new CheckinOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.checkpoint, (ServletOperation)new CheckpointOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.activity, (ServletOperation)new CreateActivity());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.configuration, (ServletOperation)new CreateConfiguration());
    }

    @NotNull
    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    public static class CheckpointOperation
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                if (versionManager.isCheckedOut(path)) {
                    versionManager.checkpoint(path);
                }
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class CheckinOperation
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                versionManager.checkin(path);
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class CheckoutOperation
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                versionManager.checkout(path);
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class GetVersions
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException, ServletException {
            block13: {
                try {
                    boolean isVersionable;
                    Node node = (Node)resource.adaptTo(Node.class);
                    if (node == null) {
                        ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                        break block13;
                    }
                    boolean bl = isVersionable = node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable") || node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
                    if (!isVersionable) {
                        ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                        break block13;
                    }
                    ResourceResolver resolver = request.getResourceResolver();
                    JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                    String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                    VersionManager versionManager = session.getWorkspace().getVersionManager();
                    VersionHistory versionHistory = versionManager.getVersionHistory(path);
                    String currentVersion = versionManager.getBaseVersion(path).getName();
                    VersionIterator allVersions = versionHistory.getAllVersions();
                    ArrayList<VersionEntry> entries = new ArrayList<VersionEntry>();
                    while (allVersions.hasNext()) {
                        Version version = allVersions.nextVersion();
                        Calendar cal = version.getCreated();
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        dateFormat.setTimeZone(cal.getTimeZone());
                        VersionEntry versionEntry = new VersionEntry(version.getName(), dateFormat.format(cal.getTime()));
                        versionEntry.labels.addAll(Arrays.asList(versionHistory.getVersionLabels(version)));
                        entries.add(versionEntry);
                    }
                    try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);){
                        jsonWriter.beginArray();
                        for (VersionEntry e : entries) {
                            jsonWriter.beginObject();
                            jsonWriter.name("current").value(e.versionName.equals(currentVersion));
                            jsonWriter.name("name").value(e.versionName);
                            jsonWriter.name("date").value(e.date);
                            jsonWriter.name("labels").beginArray();
                            for (String l : e.labels) {
                                jsonWriter.value(l);
                            }
                            jsonWriter.endArray();
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.sendError(400, ex.getMessage());
                }
            }
        }
    }

    public static class GetLabels
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException, ServletException {
            block11: {
                try {
                    boolean isVersionable;
                    Node node = (Node)resource.adaptTo(Node.class);
                    if (node == null) {
                        ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                        break block11;
                    }
                    boolean bl = isVersionable = node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable") || node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
                    if (!isVersionable) {
                        ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                        break block11;
                    }
                    ResourceResolver resolver = request.getResourceResolver();
                    JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                    String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                    VersionManager versionManager = session.getWorkspace().getVersionManager();
                    VersionHistory versionHistory = versionManager.getVersionHistory(path);
                    String[] versionLabels = versionHistory.getVersionLabels();
                    RequestParameter labelParam = request.getRequestParameter("label");
                    String label = labelParam == null ? "" : labelParam.getString();
                    try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);){
                        jsonWriter.beginArray();
                        for (String e : versionLabels) {
                            if (!e.startsWith(label)) continue;
                            jsonWriter.value(e);
                        }
                        jsonWriter.endArray();
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.sendError(400, ex.getMessage());
                }
            }
        }
    }

    public static class AddLabel
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resourc) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                VersionHistory versionHistory = versionManager.getVersionHistory(path);
                Gson gson = new Gson();
                Param p = (Param)gson.fromJson((Reader)new InputStreamReader((InputStream)request.getInputStream(), MappingRules.CHARSET.name()), Param.class);
                versionHistory.addVersionLabel(p.version, p.label, false);
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class DeleteLabel
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                VersionHistory versionHistory = versionManager.getVersionHistory(path);
                Gson gson = new Gson();
                Param p = (Param)gson.fromJson((Reader)new InputStreamReader((InputStream)request.getInputStream(), MappingRules.CHARSET.name()), Param.class);
                versionHistory.removeVersionLabel(p.label);
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class CreateActivity
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String activity = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                versionManager.createActivity(activity.startsWith("/") ? activity.substring(1) : activity);
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class CreateConfiguration
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                versionManager.createConfiguration(path);
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class DeleteVersion
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                VersionHistory versionHistory = versionManager.getVersionHistory(path);
                Gson gson = new Gson();
                Param p = (Param)gson.fromJson((Reader)new InputStreamReader((InputStream)request.getInputStream(), MappingRules.CHARSET.name()), Param.class);
                versionHistory.removeVersion(p.version);
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class RestoreVersion
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                Gson gson = new Gson();
                Param p = (Param)gson.fromJson((Reader)new InputStreamReader((InputStream)request.getInputStream(), MappingRules.CHARSET.name()), Param.class);
                versionManager.restore(path, p.version, false);
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    static class Param {
        String version;
        String label;
        String path;

        Param() {
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    static class VersionEntry {
        String versionName;
        String date;
        List<String> labels = new ArrayList<String>();

        VersionEntry(String versionName, String date) {
            this.versionName = versionName;
            this.date = date;
        }
    }

    public static enum Operation {
        checkout,
        checkin,
        addlabel,
        deletelabel,
        versions,
        labels,
        version,
        restore,
        configuration,
        checkpoint,
        activity;

    }

    public static enum Extension {
        json,
        html;

    }
}

