/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.clientlibs.handle.FileHandle;
import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.config.FilterConfiguration;
import com.composum.sling.core.exception.ParameterValidationException;
import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.resource.SyntheticQueryResult;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.NodeTreeServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.I18N;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.cpnl.CpnlElFunctions;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.mount.ExtendedResolver;
import com.composum.sling.nodes.servlet.NodeFactory;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.tika.mime.MimeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/repository/resources")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Node Servlet", "sling.servlet.paths=/bin/cpm/nodes/node", "sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.methods=PUT", "sling.servlet.methods=DELETE", "sling.auth.requirements=/bin/cpm/nodes/node"})
public class NodeServlet
extends NodeTreeServlet {
    private static final Logger LOG = LoggerFactory.getLogger(NodeServlet.class);
    public static final String SERVICE_KEY = "nodes/repository/resources";
    public static final String SERVLET_PATH = "/bin/cpm/nodes/node";
    public static final String SCRIPT_STATUS_HEADER = "Script-Status";
    public static final String FILE_CONTENT_TYPE = "application/binary";
    public static final String FILE_NAME_EXT = ".json";
    public static final String KEY_DEFAULT = "default";
    public static final String KEY_PAGE = "page";
    public static final String KEY_REFERENCEABLE = "referenceable";
    public static final String KEY_UNFILTERD = "unfiltered";
    public static final String ILLEGAL_NAME_CHARS = "<>&\"";
    public static final Pattern NODE_NAME_PATTERN = Pattern.compile("^[^/<>&\"]+$");
    public static final Pattern NODE_PATH_PATTERN = Pattern.compile("^(/[^/<>&\"]+)+$");
    @Reference
    private ServiceRestrictions restrictions;
    @Reference
    protected CoreConfiguration coreConfig;
    @Reference
    protected NodesConfiguration nodesConfig;
    protected final Map<String, ResourceFilter> nodeFilters = new LinkedHashMap<String, ResourceFilter>();
    protected final List<FilterConfiguration> filterConfigurations = new ArrayList<FilterConfiguration>();
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);
    public static final String WORDS = "[^/( \\[*]+( +[^/ (\\[]+)*";
    public static final Pattern XPATH_QUERY = Pattern.compile("^(?<path>(/jcr:root)?/[^ (\\[*]*)( +(?<words>[^/( \\[*]+( +[^/ (\\[]+)*)*|(.*))$");
    public static final Pattern SQL2_QUERY = Pattern.compile("(?i)^\\s?select(\\s+(?<words>[^/( \\[*]+( +[^/ (\\[]+)*)\\s*|(.*))$");
    public static final Pattern MAP_DEPTH_SELECTOR = Pattern.compile("^d([\\d]+)$");
    public static final Pattern MAP_INDENT_SELECTOR = Pattern.compile("^i([\\d]+)$");

    @Reference(service=FilterConfiguration.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void bindFilterConfiguration(FilterConfiguration config) {
        this.filterConfigurations.add(config);
        if (this.nodesConfig != null) {
            String key = config.getName();
            ResourceFilter filter = config.getFilter();
            if (StringUtils.isNotBlank((CharSequence)key) && filter != null) {
                this.nodeFilters.put(key, this.buildTreeFilter(filter));
            }
        }
    }

    protected synchronized void unbindFilterConfiguration(FilterConfiguration config) {
        this.nodeFilters.remove(config.getName());
        this.filterConfigurations.remove(config);
    }

    @Activate
    protected synchronized void activate() {
        for (FilterConfiguration config : this.filterConfigurations) {
            String key = config.getName();
            ResourceFilter filter = config.getFilter();
            if (!StringUtils.isNotBlank((CharSequence)key) || filter == null) continue;
            this.nodeFilters.put(key, this.buildTreeFilter(filter));
        }
    }

    @Deactivate
    protected synchronized void deactivate() {
        this.nodeFilters.clear();
        this.filterConfigurations.clear();
    }

    protected ResourceFilter buildTreeFilter(ResourceFilter configuredFilter) {
        return new ResourceFilter.FilterSet(ResourceFilter.FilterSet.Rule.tree, new ResourceFilter[]{new ResourceFilter.FilterSet(ResourceFilter.FilterSet.Rule.and, new ResourceFilter[]{configuredFilter, this.nodesConfig.getDefaultNodeFilter()}), this.nodesConfig.getTreeIntermediateFilter()});
    }

    protected ResourceFilter getNodeFilter(SlingHttpServletRequest request) {
        ResourceFilter filter = null;
        String filterParam = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"filter", (String)null);
        if (StringUtils.isNotBlank((CharSequence)filterParam)) {
            filter = this.nodeFilters.get(filterParam);
        }
        if (filter == null) {
            String selector;
            RequestPathInfo pathInfo = request.getRequestPathInfo();
            String[] stringArray = pathInfo.getSelectors();
            int n = stringArray.length;
            for (int i = 0; i < n && (filter = this.nodeFilters.get(selector = stringArray[i])) == null; ++i) {
            }
        }
        if (filter == null) {
            filter = this.nodesConfig.getDefaultNodeFilter();
        }
        return filter;
    }

    protected boolean checkNodeName(@Nullable String name) {
        return name != null && NODE_NAME_PATTERN.matcher(name).matches();
    }

    protected boolean checkNodePath(@Nullable String path) {
        return path != null && NODE_PATH_PATTERN.matcher(path).matches();
    }

    @NotNull
    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    public void init() throws ServletException {
        super.init();
        this.nodeFilters.put(KEY_REFERENCEABLE, this.buildTreeFilter(this.nodesConfig.getReferenceableNodesFilter()));
        this.nodeFilters.put(KEY_UNFILTERD, ResourceFilter.ALL);
        this.nodeFilters.put(KEY_PAGE, this.buildTreeFilter(this.nodesConfig.getPageNodeFilter()));
        this.nodeFilters.put(KEY_DEFAULT, this.nodesConfig.getDefaultNodeFilter());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.map, (ServletOperation)new MapGetOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.tree, (ServletOperation)new NodeTreeServlet.TreeOperation((NodeTreeServlet)this));
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.reference, (ServletOperation)new ReferenceOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.mixins, (ServletOperation)new GetMixinsOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.filters, (ServletOperation)new ListFiltersAsJson());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.html, (Enum)Operation.filters, (ServletOperation)new ListFiltersAsHtml());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.typeahead, (ServletOperation)new TypeaheadOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.resolve, (ServletOperation)new ResolveOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.query, (ServletOperation)new JsonQueryOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.html, (Enum)Operation.query, (ServletOperation)new HtmlQueryOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.bin, (Enum)Operation.load, (ServletOperation)new LoadBinaryOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.bin, (Enum)Operation.download, (ServletOperation)new DownloadBinaryOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.map, (ServletOperation)new MapPostOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.create, (ServletOperation)new CreateOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.bin, (Enum)Operation.query, (ServletOperation)new ExportQueryOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.copy, (ServletOperation)new CopyOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.move, (ServletOperation)new MoveOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.lock, (Enum)Operation.toggle, (ServletOperation)new ToggleLockOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.fileUpdate, (ServletOperation)new UpdateFileOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.map, (ServletOperation)new MapPutOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.create, (ServletOperation)new PutCreateOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.copy, (ServletOperation)new PutCopyOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.move, (ServletOperation)new PutMoveOperation());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, (Enum)Extension.json, (Enum)Operation.delete, (ServletOperation)new DeleteOperation());
    }

    protected List<Resource> prepareTreeItems(ResourceHandle resource, List<Resource> items) {
        if (!this.nodesConfig.getOrderableNodesFilter().accept((Resource)resource)) {
            items.sort(Comparator.comparing(arg_0 -> ((NodeServlet)this).getSortName(arg_0)));
        }
        return items;
    }

    public static MappingRules getJsonSelectorRules(SlingHttpServletRequest request) {
        boolean asSource = RequestUtil.checkSelector((SlingHttpServletRequest)request, (String)"source");
        boolean embedTypes = !asSource && !RequestUtil.checkSelector((SlingHttpServletRequest)request, (String)"notype");
        ResourceFilter.FilterSet nodeFilter = null;
        if (asSource || RequestUtil.checkSelector((SlingHttpServletRequest)request, (String)"nofile")) {
            nodeFilter = new ResourceFilter.FilterSet(ResourceFilter.FilterSet.Rule.and, new ResourceFilter[]{new ResourceFilter.PrimaryTypeFilter((StringFilter)new StringFilter.BlackList("^nt:(file|resource)$")), MappingRules.MAPPING_NODE_FILTER});
        }
        return new MappingRules(MappingRules.getDefaultMappingRules(), (ResourceFilter)nodeFilter, (StringFilter)(asSource ? MappingRules.SOURCE_EXPORT_FILTER : null), null, new MappingRules.PropertyFormat((MappingRules.PropertyFormat.Scope)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"format", (Enum)((MappingRules.PropertyFormat.Scope)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)MappingRules.PropertyFormat.Scope.value))), (MappingRules.PropertyFormat.Binary)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"binary", (Enum)((MappingRules.PropertyFormat.Binary)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)MappingRules.PropertyFormat.Binary.base64))), embedTypes), RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"depth", (Integer)RequestUtil.getIntSelector((SlingHttpServletRequest)request, (Pattern)MAP_DEPTH_SELECTOR, (int)RequestUtil.getIntSelector((SlingHttpServletRequest)request, (int)0))), null);
    }

    public static int getJsonSelectorIndent(SlingHttpServletRequest request) {
        return RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"indent", (Integer)RequestUtil.getIntSelector((SlingHttpServletRequest)request, (Pattern)MAP_INDENT_SELECTOR, (int)0));
    }

    protected class MapPutOperation
    implements ServletOperation {
        protected MapPutOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            request.setCharacterEncoding(MappingRules.CHARSET.name());
            Reader reader = this.getReader(request);
            if (reader != null) {
                try {
                    String path = this.getPath(request);
                    LOG.info(path + ": update PUT with JSON data...");
                    ResourceResolver resolver = request.getResourceResolver();
                    JsonReader jsonReader = new JsonReader(reader);
                    Resource newResource = JsonUtil.importJson((JsonReader)jsonReader, (ResourceResolver)resolver, (String)path);
                    Session session = Objects.requireNonNull((Session)resolver.adaptTo(Session.class));
                    session.save();
                    response.setStatus(200);
                    response.setContentLength(0);
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.sendError(400, ex.getMessage());
                }
            } else {
                response.sendError(400, "no data found");
            }
        }

        protected String getPath(SlingHttpServletRequest request) {
            return AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
        }

        protected Reader getReader(SlingHttpServletRequest request) throws IOException {
            return request.getReader();
        }
    }

    protected class MapPostOperation
    extends MapPutOperation {
        protected MapPostOperation() {
        }

        @Override
        protected String getPath(SlingHttpServletRequest request) {
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            String name = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"name", (String)"");
            if (StringUtils.isNotBlank((CharSequence)name)) {
                path = path + "/" + name;
            }
            return path;
        }

        @Override
        protected Reader getReader(SlingHttpServletRequest request) throws IOException {
            InputStream input;
            RequestParameterMap parameters = request.getRequestParameterMap();
            RequestParameter file = parameters.getValue("file");
            BufferedReader reader = null;
            if (file != null && (input = file.getInputStream()) != null) {
                reader = new BufferedReader(new InputStreamReader(input, MappingRules.CHARSET.name()));
            }
            return reader;
        }
    }

    protected class MapGetOperation
    implements ServletOperation {
        protected MapGetOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                MappingRules rules = NodeServlet.getJsonSelectorRules(request);
                int indent = NodeServlet.getJsonSelectorIndent(request);
                if (RequestUtil.checkSelector((SlingHttpServletRequest)request, (String)"download")) {
                    response.setContentType(NodeServlet.FILE_CONTENT_TYPE);
                    String filename = MimeTypeUtil.getFilename((Resource)resource, null);
                    if (filename.endsWith(".bin")) {
                        filename = filename.substring(0, filename.length() - 4);
                    }
                    if (!filename.endsWith(NodeServlet.FILE_NAME_EXT)) {
                        filename = filename + NodeServlet.FILE_NAME_EXT;
                    }
                    if (StringUtils.isNotBlank((CharSequence)filename)) {
                        response.setHeader("Content-Disposition", "inline; filename=" + filename);
                    }
                }
                response.setStatus(200);
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                if (indent > 0) {
                    jsonWriter.setIndent(StringUtils.repeat((char)' ', (int)indent));
                }
                JsonUtil.exportJson((JsonWriter)jsonWriter, (Resource)resource, (MappingRules)rules);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class DeleteOperation
    implements ServletOperation {
        protected DeleteOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    Session session = node.getSession();
                    node.remove();
                    session.save();
                } else {
                    ResourceResolver resolver = resource.getResourceResolver();
                    resolver.delete(resource.getResource());
                    resolver.commit();
                }
                response.setStatus(200);
                response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class PutCopyOperation
    extends CopyOperation {
        protected PutCopyOperation() {
        }

        @Override
        public NodeTreeServlet.NodeParameters getNodeParameters(SlingHttpServletRequest request) throws IOException {
            return (NodeTreeServlet.NodeParameters)AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, NodeTreeServlet.NodeParameters.class);
        }
    }

    protected class CopyOperation
    implements ServletOperation {
        protected CopyOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                NodeTreeServlet.NodeParameters params = this.getNodeParameters(request);
                String path = params.path;
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    ResourceResolver resolver = resource.getResourceResolver();
                    Node node = (Node)resource.adaptTo(Node.class);
                    if (node != null) {
                        Session session = node.getSession();
                        Node templateNode = session.getNode(path);
                        if (templateNode != null) {
                            try {
                                String name;
                                String string = name = StringUtils.isNotBlank((CharSequence)params.name) ? params.name : templateNode.getName();
                                if (!NodeServlet.this.checkNodeName(name)) {
                                    throw new ParameterValidationException("invalid node name '" + name + "'");
                                }
                                String newNodePath = node.getPath() + "/" + name;
                                Workspace workspace = session.getWorkspace();
                                workspace.copy(path, newNodePath);
                                session.save();
                                ResourceHandle newResource = ResourceHandle.use((Resource)resolver.getResource(newNodePath));
                                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                                NodeServlet.this.writeJsonNode(jsonWriter, MappingRules.DEFAULT_TREE_NODE_STRATEGY, newResource, NodeTreeServlet.LabelType.name, false);
                            }
                            catch (ItemExistsException itex) {
                                NodeServlet.this.jsonAnswerItemExists(request, response);
                            }
                        } else {
                            response.sendError(400, "can't determine template node '" + path + "'");
                        }
                    } else {
                        Resource template = resolver.getResource(path);
                        if (template != null) {
                            resolver.copy(template.getPath(), resource.getPath());
                            resolver.commit();
                        } else {
                            response.sendError(400, "can't determine template node '" + path + "'");
                        }
                    }
                }
            }
            catch (ParameterValidationException pvex) {
                response.sendError(400, pvex.getMessage());
            }
        }

        public NodeTreeServlet.NodeParameters getNodeParameters(SlingHttpServletRequest request) throws IOException {
            return NodeServlet.this.getFormParameters(request);
        }
    }

    protected class PutCreateOperation
    extends CreateOperation {
        protected PutCreateOperation() {
        }

        @Override
        public NodeTreeServlet.NodeParameters getNodeParameters(SlingHttpServletRequest request) throws IOException {
            return (NodeTreeServlet.NodeParameters)AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, NodeTreeServlet.NodeParameters.class);
        }
    }

    protected class CreateOperation
    implements ServletOperation {
        protected CreateOperation() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            ResourceResolver resolver = resource.getResourceResolver();
            NodeTreeServlet.NodeParameters params = this.getNodeParameters(request);
            String name = params.name;
            try {
                if (StringUtils.isBlank((CharSequence)params.type)) {
                    throw new ParameterValidationException("invalid node type '" + params.type + "'");
                }
                if (!NodeServlet.this.checkNodeName(name)) {
                    throw new ParameterValidationException("invalid node name '" + name + "'");
                }
                ResourceHandle newResource = null;
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    Node newNode = NodeFactory.SINGLETON.createNode(request, node, name, params);
                    if (newNode == null) {
                        response.sendError(400, "creation failed for node '" + resource.getPath() + "/" + name + "'");
                        return;
                    }
                    Session session = node.getSession();
                    session.save();
                    newResource = ResourceHandle.use((Resource)resolver.getResource(newNode.getPath()));
                } else {
                    InputStream input;
                    RequestParameterMap parameters;
                    RequestParameter file;
                    if (resolver instanceof ExtendedResolver && "nt:file".equals(params.type) && (file = (parameters = request.getRequestParameterMap()).getValue("file")) != null && (input = file.getInputStream()) != null) {
                        MimeType mimeType = MimeTypeUtil.getMimeType((String)(StringUtils.isNotBlank((CharSequence)params.mimeType) ? params.mimeType : name));
                        String contentType = mimeType != null ? mimeType.getName() : null;
                        newResource = ResourceHandle.use((Resource)((ExtendedResolver)resolver).upload(resource.getPath() + "/" + name, input, null, contentType, contentType != null ? StandardCharsets.UTF_8.name() : null));
                    }
                    if (newResource == null) {
                        newResource = ResourceHandle.use((Resource)resolver.create((Resource)resource, name, params.asMap()));
                    }
                    resolver.commit();
                }
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                NodeServlet.this.writeJsonNode(jsonWriter, MappingRules.DEFAULT_TREE_NODE_STRATEGY, newResource, NodeTreeServlet.LabelType.name, false);
                return;
            }
            catch (ParameterValidationException pvex) {
                response.sendError(400, pvex.getMessage());
            }
        }

        public NodeTreeServlet.NodeParameters getNodeParameters(SlingHttpServletRequest request) throws IOException {
            return NodeServlet.this.getFormParameters(request);
        }
    }

    protected class PutMoveOperation
    extends MoveOperation {
        protected PutMoveOperation() {
        }

        @Override
        public NodeTreeServlet.NodeParameters getNodeParameters(SlingHttpServletRequest request) throws IOException {
            return (NodeTreeServlet.NodeParameters)AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, NodeTreeServlet.NodeParameters.class);
        }
    }

    protected class MoveOperation
    implements ServletOperation {
        protected MoveOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            String newPath;
            if (!(resource = AbstractServiceServlet.tryToUseRawSuffix((SlingHttpServletRequest)request, (ResourceHandle)resource)).isValid()) {
                response.setStatus(404);
                return;
            }
            ResourceResolver resolver = resource.getResourceResolver();
            NodeTreeServlet.NodeParameters params = this.getNodeParameters(request);
            String name = params.name;
            if (StringUtils.isBlank((CharSequence)name)) {
                name = resource.getName();
            }
            if (!(newPath = params.path).endsWith("/")) {
                newPath = newPath + "/";
            }
            if (NodeServlet.this.checkNodePath(newPath = newPath + name)) {
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    ResourceHandle newResource;
                    NodeIterator siblingsIterator;
                    Session session = node.getSession();
                    String oldPath = node.getPath();
                    Node oldParentNode = node.getParent();
                    Node newParentNode = session.getNode(params.path);
                    String beforeName = null;
                    if (StringUtils.isNotBlank((CharSequence)params.before) && NODE_PATH_PATTERN.matcher(beforeName = params.before).matches()) {
                        beforeName = null;
                        try {
                            Node before = session.getNode(params.before);
                            beforeName = before.getName();
                        }
                        catch (PathNotFoundException ex) {
                            LOG.error(ex.toString());
                        }
                    }
                    Integer index = null;
                    if (beforeName == null && (index = params.index()) != null && index >= 0) {
                        siblingsIterator = newParentNode.getNodes();
                        int i = 0;
                        while (i < index && siblingsIterator.hasNext()) {
                            if (siblingsIterator.nextNode().getPath().equals(oldPath)) continue;
                            ++i;
                        }
                        if (siblingsIterator.hasNext()) {
                            beforeName = siblingsIterator.nextNode().getName();
                        }
                    }
                    if (beforeName == null && index == null && oldParentNode != null && params.path.equals(oldParentNode.getPath())) {
                        siblingsIterator = oldParentNode.getNodes();
                        while (siblingsIterator.hasNext()) {
                            Node sibling = siblingsIterator.nextNode();
                            if (!sibling.getPath().equals(oldPath)) continue;
                            if (!siblingsIterator.hasNext()) break;
                            beforeName = siblingsIterator.nextNode().getName();
                            break;
                        }
                    }
                    boolean changesMade = false;
                    if (!oldPath.equals(newPath)) {
                        session.move(oldPath, newPath);
                        changesMade = true;
                    }
                    if ((newResource = ResourceHandle.use((Resource)resolver.getResource(newPath))).isValid()) {
                        String newName = newResource.getName();
                        if (!newName.equals(beforeName)) {
                            try {
                                newParentNode.orderBefore(newName, beforeName);
                                changesMade = true;
                            }
                            catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
                                // empty catch block
                            }
                        }
                        JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                        if (changesMade) {
                            session.save();
                            response.setStatus(200);
                            NodeServlet.this.writeJsonNode(jsonWriter, MappingRules.DEFAULT_TREE_NODE_STRATEGY, newResource, NodeTreeServlet.LabelType.name, false);
                        } else {
                            response.setStatus(202);
                            jsonWriter.beginObject();
                            jsonWriter.name("success").value(true);
                            jsonWriter.name("messages").beginArray();
                            jsonWriter.beginObject();
                            jsonWriter.name("level").value("info");
                            jsonWriter.name("text").value(I18N.get((SlingHttpServletRequest)request, (String)"no modification"));
                            jsonWriter.endObject();
                            jsonWriter.endArray();
                            jsonWriter.endObject();
                        }
                    } else {
                        response.sendError(404, "invalid node after move '" + newPath + "'");
                    }
                } else {
                    String parentPath = StringUtils.substringBeforeLast((String)newPath, (String)"/");
                    if (resolver instanceof ExtendedResolver) {
                        String order = null;
                        if (StringUtils.isNotBlank((CharSequence)params.before)) {
                            order = "before " + StringUtils.substringAfterLast((String)params.before, (String)"/");
                        } else if (params.index() != null && params.index() >= 0) {
                            order = "" + params.index;
                        }
                        ((ExtendedResolver)resolver).move(resource.getPath(), parentPath, name, order);
                    } else {
                        resolver.move(resource.getPath(), parentPath);
                    }
                    resolver.commit();
                }
            } else {
                response.sendError(400, "invalid node path '" + newPath + "'");
            }
        }

        public NodeTreeServlet.NodeParameters getNodeParameters(SlingHttpServletRequest request) throws IOException {
            return NodeServlet.this.getFormParameters(request);
        }
    }

    protected class ToggleLockOperation
    implements ServletOperation {
        protected ToggleLockOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            Node node = (Node)resource.adaptTo(Node.class);
            if (node != null) {
                Session session = node.getSession();
                Workspace workspace = session.getWorkspace();
                LockManager lockManager = workspace.getLockManager();
                try {
                    if (node.isLocked()) {
                        Lock lock = lockManager.getLock(node.getPath());
                        String token = lock.getLockToken();
                        lockManager.addLockToken(token);
                        lockManager.unlock(node.getPath());
                    } else {
                        if (!node.isNodeType("mix:lockable")) {
                            node.addMixin("mix:lockable");
                            session.save();
                        }
                        lockManager.lock(node.getPath(), true, false, Long.MAX_VALUE, session.getUserID());
                    }
                    session.save();
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.sendError(400, ex.getMessage());
                }
            }
        }
    }

    protected class UpdateFileOperation
    implements ServletOperation {
        protected UpdateFileOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            ResourceHandle content = resource;
            if (resource != null && resource.isValid() && ("jcr:content".equals(content.getName()) || (content = resource.getChild("jcr:content")) != null)) {
                InputStream input;
                RequestParameterMap parameters = request.getRequestParameterMap();
                RequestParameter file = parameters.getValue("file");
                if (file != null && (input = file.getInputStream()) != null) {
                    ModifiableValueMap values = (ModifiableValueMap)content.adaptTo(ModifiableValueMap.class);
                    if (values != null) {
                        ResourceResolver resolver = resource.getResourceResolver();
                        if (resolver instanceof ExtendedResolver) {
                            ((ExtendedResolver)resolver).upload(resource.getPath(), input, file.getFileName(), file.getContentType(), null);
                        } else {
                            values.put((Object)"jcr:data", (Object)input);
                            if (RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"adjustLastModified", (Boolean)Boolean.FALSE).booleanValue()) {
                                values.put((Object)"jcr:lastModified", (Object)GregorianCalendar.getInstance());
                                values.put((Object)"jcr:lastModifiedBy", (Object)resolver.getUserID());
                            }
                        }
                        resolver.commit();
                        JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                        NodeServlet.this.writeJsonNode(jsonWriter, MappingRules.DEFAULT_TREE_NODE_STRATEGY, resource, NodeTreeServlet.LabelType.name, false);
                    } else {
                        response.sendError(400, "can't modify '" + resource.getPath() + "'");
                    }
                } else {
                    response.sendError(400, "no file content found");
                }
            } else {
                response.sendError(400, "no valid file resource '" + (resource != null ? resource.getPath() : "NULL") + "'");
            }
        }

        public NodeTreeServlet.NodeParameters getNodeParameters(SlingHttpServletRequest request) {
            return NodeServlet.this.getFormParameters(request);
        }
    }

    protected class DownloadBinaryOperation
    extends LoadBinaryOperation {
        protected DownloadBinaryOperation() {
        }

        @Override
        protected void prepareResponse(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull ResourceHandle resource) {
            Calendar lastModified;
            super.prepareResponse(request, response, resource);
            String filename = MimeTypeUtil.getFilename((Resource)resource, null);
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                Disposition disposition = (Disposition)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)Disposition.inline);
                response.setHeader("Content-Disposition", disposition.name() + "; filename=" + filename);
            }
            if ((lastModified = (Calendar)resource.getProperty("jcr:lastModified", Calendar.class)) != null) {
                response.setDateHeader("Last-Modified", lastModified.getTimeInMillis());
            }
        }
    }

    protected class LoadBinaryOperation
    implements ServletOperation {
        protected LoadBinaryOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws ServletException, IOException {
            block30: {
                Binary binary;
                Binary binary2 = binary = resource != null ? ResourceUtil.getBinaryData((Resource)resource) : null;
                if (binary != null) {
                    try {
                        this.prepareResponse(request, response, resource);
                        response.setContentLength((int)binary.getSize());
                        response.setStatus(200);
                        try (InputStream input = binary.getStream();
                             BufferedInputStream buffered = new BufferedInputStream(input);){
                            IOUtils.copy((InputStream)buffered, (OutputStream)response.getOutputStream());
                        }
                    }
                    catch (RepositoryException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                        response.sendError(400, ex.getMessage());
                    }
                    finally {
                        binary.dispose();
                    }
                } else {
                    FileHandle fileHandle = new FileHandle((Resource)resource);
                    if (fileHandle.isValid()) {
                        this.prepareResponse(request, response, Objects.requireNonNull(resource));
                        response.setStatus(200);
                        try (InputStream input = fileHandle.getStream();
                             BufferedInputStream buffered = new BufferedInputStream(input);){
                            IOUtils.copy((InputStream)buffered, (OutputStream)response.getOutputStream());
                            break block30;
                        }
                    }
                    response.setStatus(404);
                }
            }
        }

        protected void prepareResponse(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull ResourceHandle resource) {
            MimeType mimeType = MimeTypeUtil.getMimeType((Resource)resource);
            if (mimeType != null) {
                response.setContentType(mimeType.toString());
            }
        }
    }

    protected class GetMixinsOperation
    implements ServletOperation {
        protected GetMixinsOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                response.setStatus(200);
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                jsonWriter.beginArray();
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    NodeType[] mixins = node.getMixinNodeTypes();
                    if (mixins != null) {
                        for (NodeType type : mixins) {
                            jsonWriter.value(type.getName());
                        }
                    }
                } else {
                    ValueMap values = resource.getValueMap();
                    for (String mixin : (String[])values.get("jcr:mixinTypes", (Object)new String[0])) {
                        jsonWriter.value(mixin);
                    }
                }
                jsonWriter.endArray();
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class TypeaheadOperation
    implements ServletOperation {
        protected TypeaheadOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            ResourceResolver resolver;
            String query = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            String parentPath = "";
            if (query.startsWith("/")) {
                parentPath = query.substring(0, query.lastIndexOf(47));
                query = query.substring(parentPath.length() + 1);
            }
            if (StringUtils.isBlank((CharSequence)parentPath)) {
                parentPath = "/";
            }
            if ((resource = ResourceHandle.use((Resource)(resolver = request.getResourceResolver()).getResource(parentPath))).isValid()) {
                ResourceFilter.FilterSet filter = new ResourceFilter.FilterSet(ResourceFilter.FilterSet.Rule.and, new ResourceFilter[]{new ResourceFilter.NameFilter((StringFilter)new StringFilter.WhiteList(".*" + query + ".*")), NodeServlet.this.getNodeFilter(request)});
                ArrayList<Resource> matchingChilds = new ArrayList<Resource>();
                for (Resource child : resource.getChildren()) {
                    if (!filter.accept(child)) continue;
                    matchingChilds.add(child);
                }
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                response.setStatus(200);
                jsonWriter.beginArray();
                for (Resource matching : matchingChilds) {
                    jsonWriter.value(matching.getPath());
                }
                jsonWriter.endArray();
            }
        }
    }

    protected class ResolveOperation
    implements ServletOperation {
        protected ResolveOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            ResourceResolver resolver = request.getResourceResolver();
            String paramUrl = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"url", (String)"");
            if (StringUtils.isNotBlank((CharSequence)paramUrl)) {
                String contextPath;
                URL url = new URL(paramUrl);
                String path = url.getPath();
                Resource target = resolver.resolve((HttpServletRequest)request, path);
                if (ResourceUtil.isNonExistingResource((Resource)target) && path.startsWith(contextPath = request.getContextPath())) {
                    path = path.substring(contextPath.length());
                    target = resolver.resolve((HttpServletRequest)request, path);
                }
                if (!ResourceUtil.isNonExistingResource((Resource)target)) {
                    ResourceHandle handle = ResourceHandle.use((Resource)target);
                    NodeTreeServlet.DefaultTreeNodeStrategy strategy = new NodeTreeServlet.DefaultTreeNodeStrategy(NodeServlet.this.getNodeFilter(request));
                    NodeTreeServlet.LabelType labelType = (NodeTreeServlet.LabelType)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"label", (Enum)((NodeTreeServlet.LabelType)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)NodeTreeServlet.LabelType.name)));
                    JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                    response.setStatus(200);
                    NodeServlet.this.writeJsonNode(jsonWriter, (NodeTreeServlet.TreeNodeStrategy)strategy, handle, labelType, false);
                } else {
                    response.sendError(404, "no resource found for url: " + url);
                }
            } else {
                response.sendError(400, "no URL for node resolving");
            }
        }
    }

    protected class ReferenceOperation
    implements ServletOperation {
        protected ReferenceOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            block6: {
                String reference = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"id", (String)AbstractServiceServlet.getPath((SlingHttpServletRequest)request));
                if (reference != null) {
                    while (reference.startsWith("/")) {
                        reference = reference.substring(1);
                    }
                    try {
                        Resource nodeResource;
                        ResourceResolver resolver = request.getResourceResolver();
                        Session session = Objects.requireNonNull((Session)resolver.adaptTo(Session.class));
                        Node node = session.getNodeByIdentifier(reference);
                        if (node != null && (nodeResource = resolver.getResource(node.getPath())) != null) {
                            resource = ResourceHandle.use((Resource)nodeResource);
                            NodeTreeServlet.DefaultTreeNodeStrategy strategy = new NodeTreeServlet.DefaultTreeNodeStrategy(NodeServlet.this.getNodeFilter(request));
                            NodeTreeServlet.LabelType labelType = (NodeTreeServlet.LabelType)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"label", (Enum)((NodeTreeServlet.LabelType)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)NodeTreeServlet.LabelType.name)));
                            JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                            response.setStatus(200);
                            NodeServlet.this.writeJsonNode(jsonWriter, (NodeTreeServlet.TreeNodeStrategy)strategy, resource, labelType, false);
                            break block6;
                        }
                        response.sendError(404, "no resource found for id: " + reference);
                    }
                    catch (RepositoryException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                        response.sendError(400, ex.getMessage());
                    }
                } else {
                    response.sendError(400, "no reference found");
                }
            }
        }
    }

    protected class ExportQueryOperation
    extends AbstractQueryOperation {
        protected ExportQueryOperation() {
        }

        @Override
        @Nullable
        protected Long getQueryLimit() {
            return null;
        }

        @Override
        protected void writeQueryResult(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull String queryString, @NotNull QueryResult result, @NotNull ResourceFilter filter, @NotNull ResourceResolver resolver) throws ServletException, IOException {
            String rendererType = XSS.filter((String)request.getParameter("export"));
            String syntheticPath = NodeServlet.this.coreConfig.getComposumBase() + "composum/nodes/browser/query/export";
            SyntheticQueryResult resultResource = new SyntheticQueryResult(resolver, syntheticPath, result, filter, rendererType);
            resultResource.putValue("query", (Object)queryString);
            Enumeration parameters = request.getParameterNames();
            block6: while (parameters.hasMoreElements()) {
                String name = (String)parameters.nextElement();
                String value = XSS.filter((String)request.getParameter(name));
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                switch (name) {
                    case "properties": {
                        resultResource.putValue(name, (Object)StringUtils.split((String)value, (char)','));
                        continue block6;
                    }
                }
                resultResource.putValue(name, (Object)value);
            }
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            options.setForceResourceType(rendererType);
            RequestDispatcher dispatcher = request.getRequestDispatcher((Resource)resultResource, options);
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected class HtmlQueryOperation
    extends AbstractQueryOperation {
        protected HtmlQueryOperation() {
        }

        @Override
        protected void writeQueryResult(SlingHttpServletRequest request, SlingHttpServletResponse response, String queryString, QueryResult result, ResourceFilter filter, ResourceResolver resolver) throws RepositoryException, IOException {
            response.setStatus(200);
            response.setContentType("text/html;charset=" + MappingRules.CHARSET);
            PrintWriter writer = response.getWriter();
            NodeTreeServlet.DefaultTreeNodeStrategy nodeStrategy = new NodeTreeServlet.DefaultTreeNodeStrategy(NodeServlet.this.getNodeFilter(request));
            NodeIterator iterator = result.getNodes();
            writer.append("<tbody>");
            try {
                long limit = NodeServlet.this.nodesConfig.getQueryResultLimit();
                int count = 0;
                while ((long)count < limit && iterator.hasNext()) {
                    boolean isLocked;
                    Node node = iterator.nextNode();
                    ResourceHandle resource = ResourceHandle.use((Resource)resolver.getResource(node.getPath()));
                    if (!resource.isValid() || !this.accept(filter, (Resource)resource)) continue;
                    StringBuilder classes = new StringBuilder();
                    String nodePath = node.getPath();
                    Session session = node.getSession();
                    Workspace workspace = session.getWorkspace();
                    LockManager lockManager = workspace.getLockManager();
                    if (node.isCheckedOut()) {
                        classes.append(" checked-out");
                    }
                    if (isLocked = node.isLocked()) {
                        classes.append(" locked");
                        Lock lock = lockManager.getLock(nodePath);
                        String holderPath = lock.getNode().getPath();
                        if (lock.isDeep()) {
                            classes.append(" deep-lock");
                        }
                        if (holderPath.equals(nodePath)) {
                            classes.append(" lock-holder");
                        }
                    }
                    String path = resource.getPath();
                    writer.append("<tr class=\"").append(classes.toString().trim()).append("\" data-path=\"").append(path).append("\">");
                    writer.append("<td class=\"icon\" data-type=\"").append(nodeStrategy.getTypeKey(resource)).append("\"><span></span></td>");
                    writer.append("<td class=\"id\">").append(resource.getId()).append("</td>");
                    writer.append("<td class=\"name\">").append(CpnlElFunctions.text((String)resource.getName())).append("</td>");
                    writer.append("<td class=\"text\">").append(CpnlElFunctions.text((String)NodeServlet.this.getNodeLabel(resource, NodeTreeServlet.LabelType.title))).append("</td>");
                    writer.append("<td class=\"path\"><a href=\"").append(CpnlElFunctions.path((String)path)).append("\">").append(CpnlElFunctions.text((String)path)).append("</a></td>");
                    writer.append("<td class=\"type\">").append(resource.getPrimaryType()).append("</td>");
                    writer.append("</tr>");
                    ++count;
                }
                StringBuilder message = new StringBuilder();
                message.append(count).append(" items found");
                if ((long)count >= limit) {
                    message.append(" (current limit: ").append(limit).append(", ").append(iterator.hasNext() ? "more items present" : "no more items").append(")");
                }
                message.append(".");
                this.writeSummary(queryString, message.toString(), writer, "summary info");
            }
            catch (RuntimeException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                this.writeSummary(queryString, ex.getMessage(), writer, "error danger");
            }
            writer.append("</tbody>");
        }

        protected void writeSummary(String queryString, String message, PrintWriter writer, String cssClasses) {
            writer.append("<tr class=\"").append(cssClasses).append("\">");
            writer.append("<td class=\"icon\" data-type=\"summary\" rowspan=\"2\"><span></span></td>");
            writer.append("<td class=\"message\" colspan=\"5\">").append(CpnlElFunctions.text((String)message)).append("<br/>query: '").append(CpnlElFunctions.text((String)queryString)).append("'</td>");
            writer.append("</tr>");
        }

        @Override
        protected void writeError(SlingHttpServletResponse response, String queryString, Exception ex) throws IOException {
            PrintWriter writer = response.getWriter();
            writer.append("<tbody>");
            this.writeSummary(queryString, ex.getMessage(), writer, "error danger");
            writer.append("</tbody>");
        }
    }

    protected class JsonQueryOperation
    extends AbstractQueryOperation {
        protected JsonQueryOperation() {
        }

        @Override
        protected void writeQueryResult(SlingHttpServletRequest request, SlingHttpServletResponse response, String queryString, QueryResult result, ResourceFilter filter, ResourceResolver resolver) throws RepositoryException, IOException {
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            response.setStatus(200);
            NodeTreeServlet.DefaultTreeNodeStrategy nodeStrategy = new NodeTreeServlet.DefaultTreeNodeStrategy(NodeServlet.this.getNodeFilter(request));
            NodeIterator iterator = result.getNodes();
            writer.beginArray();
            writer.name("result").beginArray();
            int count = 0;
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                ResourceHandle resource = ResourceHandle.use((Resource)resolver.getResource(node.getPath()));
                if (!resource.isValid() || !this.accept(filter, (Resource)resource)) continue;
                writer.beginObject();
                String type = NodeServlet.this.writeNodeIdentifiers(writer, (NodeTreeServlet.TreeNodeStrategy)nodeStrategy, resource, NodeTreeServlet.LabelType.name, false);
                NodeServlet.this.writeNodeJcrState(writer, resource);
                writer.endObject();
                ++count;
            }
            writer.endArray();
            writer.name("summary").beginObject();
            writer.name("query").value(CpnlElFunctions.script((String)queryString));
            writer.name("count").value((long)count);
            writer.name("limit").value(NodeServlet.this.nodesConfig.getQueryResultLimit());
            writer.endObject();
            writer.endObject();
        }
    }

    protected abstract class AbstractQueryOperation
    implements ServletOperation {
        protected AbstractQueryOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            String queryString = StringUtils.defaultString((String)request.getParameter("query")).trim();
            String queryLang = "xpath";
            Matcher matcher = XPATH_QUERY.matcher(queryString);
            if (matcher.matches()) {
                String text = matcher.group("words");
                if (StringUtils.isNotBlank((CharSequence)text)) {
                    queryString = this.getSimpleQuery(matcher.group("path"), text);
                }
                if (!queryString.startsWith("/jcr:root")) {
                    queryString = "/jcr:root" + queryString;
                }
            } else {
                matcher = SQL2_QUERY.matcher(queryString);
                if (matcher.matches()) {
                    queryLang = "JCR-SQL2";
                } else {
                    queryString = this.getSimpleQuery(AbstractServiceServlet.getPath((SlingHttpServletRequest)request), queryString);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)queryString)) {
                try {
                    ResourceResolver resolver = request.getResourceResolver();
                    Session session = Objects.requireNonNull((Session)resolver.adaptTo(Session.class));
                    Workspace workspace = session.getWorkspace();
                    QueryManager queryManager = workspace.getQueryManager();
                    Query query = queryManager.createQuery(queryString, queryLang);
                    Long queryLimit = this.getQueryLimit();
                    if (queryLimit != null) {
                        query.setLimit(queryLimit.longValue());
                    }
                    QueryResult result = query.execute();
                    ResourceFilter filter = NodeServlet.this.getNodeFilter(request);
                    this.writeQueryResult(request, response, queryString, result, filter, resolver);
                }
                catch (RepositoryException rex) {
                    LOG.error(rex.getMessage(), (Throwable)rex);
                    this.writeError(response, queryString, (Exception)((Object)rex));
                }
            }
        }

        public String getSimpleQuery(String path, String text) {
            String queryString = "/jcr:root";
            if (StringUtils.isNotBlank((CharSequence)path)) {
                queryString = queryString + path;
            }
            queryString = queryString + (queryString.endsWith("/") ? "/*" : "//*");
            String escapedText = StringUtils.replaceAll((String)text, (String)"'", (String)"''");
            queryString = queryString + "[jcr:contains(.,'" + escapedText + "')] order by @path";
            return queryString;
        }

        protected boolean accept(ResourceFilter filter, Resource resource) {
            if (filter instanceof ResourceFilter.FilterSet) {
                ResourceFilter.FilterSet set = (ResourceFilter.FilterSet)filter;
                if (ResourceFilter.FilterSet.Rule.tree == set.getRule()) {
                    return filter.accept(resource) && !set.isIntermediate(resource);
                }
                return filter.accept(resource);
            }
            return filter.accept(resource);
        }

        @Nullable
        protected Long getQueryLimit() {
            return NodeServlet.this.nodesConfig.getQueryResultLimit() + 1L;
        }

        protected abstract void writeQueryResult(SlingHttpServletRequest var1, SlingHttpServletResponse var2, String var3, QueryResult var4, ResourceFilter var5, ResourceResolver var6) throws RepositoryException, ServletException, IOException;

        protected void writeError(SlingHttpServletResponse response, String queryString, Exception ex) throws IOException {
            response.sendError(400, "query: '" + CpnlElFunctions.text((String)queryString) + "' (" + ex.getMessage() + ")");
        }
    }

    protected class ListFiltersAsJson
    implements ServletOperation {
        protected ListFiltersAsJson() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            response.setStatus(200);
            jsonWriter.beginArray();
            for (String key : NodeServlet.this.nodeFilters.keySet()) {
                jsonWriter.value(key);
            }
            jsonWriter.endArray();
        }
    }

    protected class ListFiltersAsHtml
    implements ServletOperation {
        protected ListFiltersAsHtml() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            response.setStatus(200);
            response.setContentType("text/html;charset=" + MappingRules.CHARSET);
            PrintWriter writer = response.getWriter();
            for (String key : NodeServlet.this.nodeFilters.keySet()) {
                ((Writer)writer).append("<li data-filter=\"").append(key).append("\"><a href=\"#\">").append(key).append("</a></li>");
            }
        }
    }

    public static enum Operation {
        create,
        copy,
        move,
        reorder,
        delete,
        toggle,
        tree,
        reference,
        mixins,
        resolve,
        typeahead,
        query,
        filters,
        map,
        load,
        download,
        fileUpdate;

    }

    public static enum Extension {
        json,
        html,
        lock,
        groovy,
        bin;

    }

    public static enum Disposition {
        inline,
        attachment;

    }
}

