/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.servlet.Status;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.service.ComponentsService;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/components/operations")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Components Servlet", "sling.servlet.paths=/bin/cpm/nodes/components", "sling.servlet.methods=GET", "sling.servlet.methods=POST"})
public class ComponentsServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentsServlet.class);
    public static final String SERVICE_KEY = "nodes/components/operations";
    public static final String SERVLET_PATH = "/bin/cpm/nodes/components";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_TYPE = "type";
    @Reference
    protected ComponentsService componentsService;
    @Reference
    protected NodesConfiguration nodesConfig;
    protected BundleContext bundleContext;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);

    @NotNull
    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.createOverlay, (ServletOperation)new CreateOverlayOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.removeOverlay, (ServletOperation)new RemoveOverlayOperation());
    }

    @Nullable
    protected static String getComponentType(@NotNull SlingHttpServletRequest request, @Nullable ResourceHandle resource) {
        String parameter = request.getParameter(PARAM_TYPE);
        if (StringUtils.isBlank((CharSequence)parameter) && StringUtils.isBlank((CharSequence)(parameter = request.getParameter(PARAM_PATH)))) {
            return resource != null ? resource.getPath() : null;
        }
        return parameter;
    }

    protected class RemoveOverlayOperation
    implements ServletOperation {
        protected RemoveOverlayOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException {
            Status status = new Status(request, response, LOG);
            String type = ComponentsServlet.getComponentType(request, resource);
            if (StringUtils.isNotBlank((CharSequence)type)) {
                ResourceResolver resolver = request.getResourceResolver();
                try {
                    ComponentsServlet.this.componentsService.removeOverlay(resolver, type);
                    resolver.commit();
                }
                catch (PersistenceException ex) {
                    status.error(ex.getMessage(), (Throwable)ex);
                }
            } else {
                status.error("type expected", new Object[0]);
            }
            status.sendJson();
        }
    }

    protected class CreateOverlayOperation
    implements ServletOperation {
        protected CreateOverlayOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException {
            Status status = new Status(request, response, LOG);
            String type = ComponentsServlet.getComponentType(request, resource);
            if (StringUtils.isNotBlank((CharSequence)type)) {
                ResourceResolver resolver = request.getResourceResolver();
                try {
                    ComponentsServlet.this.componentsService.createOverlay(resolver, type);
                    resolver.commit();
                }
                catch (PersistenceException ex) {
                    status.error(ex.getMessage(), (Throwable)ex);
                }
            } else {
                status.error("type expected", new Object[0]);
            }
            status.sendJson();
        }
    }

    public static enum Operation {
        createOverlay,
        removeOverlay;

    }

    public static enum Extension {
        json;

    }
}

