/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.service.impl;

import com.composum.sling.nodes.service.ComponentsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component
public class NodesComponentsService
implements ComponentsService {
    public static final List<String> IGNORED_PROPERTIES = new ArrayList<String>(){
        {
            this.add("jcr:uuid");
            this.add("jcr:created");
            this.add("jcr:createdBy");
            this.add("jcr:isCheckedOut");
            this.add("jcr:versionHistory");
            this.add("jcr:baseVersion");
            this.add("jcr:predecessors");
        }
    };

    @Override
    @Nullable
    public Resource createOverlay(@NotNull ResourceResolver resolver, @NotNull String overlayType) throws PersistenceException {
        Resource overlay = null;
        String overlayPath = null;
        Resource template = null;
        List<String> searchPath = Arrays.asList(resolver.getSearchPath());
        Iterator<String> searchPathIterator = searchPath.iterator();
        if (overlayType.startsWith("/")) {
            template = this.getTemplate(resolver, overlayType, searchPathIterator);
            if (template != null) {
                overlayPath = overlayType;
            } else {
                ArrayList<String> reversePath = new ArrayList<String>(searchPath);
                Collections.reverse(reversePath);
                template = this.getTemplate(resolver, overlayType, reversePath.iterator());
                if (template != null) {
                    overlayPath = overlayType;
                }
            }
        } else {
            String lastEntry = null;
            String currentEntry = null;
            while (searchPathIterator.hasNext() && template == null) {
                lastEntry = currentEntry;
                currentEntry = searchPathIterator.next();
                template = resolver.getResource(currentEntry + overlayType);
            }
            String string = overlayPath = lastEntry != null ? lastEntry + overlayType : null;
        }
        if (template != null && StringUtils.isNotBlank((CharSequence)overlayPath)) {
            overlay = resolver.getResource(overlayPath);
            if (overlay != null) {
                throw new IllegalArgumentException("Overlay already exists");
            }
            Resource parent = this.prepareParent(resolver, template.getParent(), StringUtils.substringBeforeLast((String)overlayPath, (String)"/"));
            if (parent != null) {
                overlay = this.copyTemplate(resolver, template, parent);
            }
        }
        return overlay;
    }

    @Override
    public boolean removeOverlay(@NotNull ResourceResolver resolver, @NotNull String overlayType) throws PersistenceException {
        Resource overlay = null;
        for (String searchPathElement : resolver.getSearchPath()) {
            if (overlayType.startsWith("/")) {
                if (!overlayType.startsWith(searchPathElement)) continue;
                overlay = resolver.getResource(overlayType);
                continue;
            }
            overlay = resolver.getResource(searchPathElement + overlayType);
        }
        if (overlay != null) {
            resolver.delete(overlay);
            return true;
        }
        return false;
    }

    protected Resource getTemplate(@NotNull ResourceResolver resolver, @NotNull String overlayType, @NotNull Iterator<String> searchPathIterator) {
        String overlayPath = null;
        Resource template = null;
        String overlayEntry = null;
        while (searchPathIterator.hasNext() && overlayPath == null) {
            String thisEntry = searchPathIterator.next();
            if (!overlayType.startsWith(thisEntry)) continue;
            overlayEntry = thisEntry;
            overlayPath = overlayType;
        }
        while (searchPathIterator.hasNext() && template == null) {
            template = resolver.getResource(searchPathIterator.next() + overlayType.substring(overlayEntry.length()));
        }
        return template;
    }

    protected Resource copyTemplate(@NotNull ResourceResolver resolver, @NotNull Resource template, @NotNull Resource parent) throws PersistenceException {
        final ValueMap values = template.getValueMap();
        Resource resource = resolver.create(parent, template.getName(), (Map)new HashMap<String, Object>(){
            {
                for (String key : values.keySet()) {
                    if (IGNORED_PROPERTIES.contains(key)) continue;
                    this.put(key, values.get((Object)key));
                }
            }
        });
        for (Resource child : template.getChildren()) {
            this.copyTemplate(resolver, child, resource);
        }
        return resource;
    }

    protected Resource prepareParent(@NotNull ResourceResolver resolver, Resource template, String targetPath) throws PersistenceException {
        Resource resource = resolver.getResource(targetPath);
        if (resource == null && template != null) {
            String parentPath = StringUtils.substringBeforeLast((String)targetPath, (String)"/");
            Resource parent = this.prepareParent(resolver, template.getParent(), parentPath);
            final ValueMap values = template.getValueMap();
            resource = resolver.create(parent, template.getName(), (Map)new HashMap<String, Object>(){
                {
                    this.put("jcr:primaryType", values.get("jcr:primaryType", (Object)"nt:unstructured"));
                }
            });
        }
        return resource;
    }
}

