/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.scene;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.util.ValueEmbeddingReader;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.scene.SceneConfigurations;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scene {
    private static final Logger LOG = LoggerFactory.getLogger(Scene.class);
    @NotNull
    protected final BeanContext context;
    @NotNull
    protected final SceneConfigurations.Config sceneConfig;
    @NotNull
    protected final Resource configResource;
    @NotNull
    protected final String scenePath;
    @NotNull
    protected final String contentPath;
    @NotNull
    protected final String contentType;
    private transient Map<String, Object> sceneProperties;
    private transient Resource contentResource;
    private transient String frameUrl;
    private transient String elementPath;
    StringFilter PROPERTY_FILTER = new StringFilter.BlackList(new String[]{"^jcr:(primaryType|created.*|uuid)$", "^jcr:(baseVersion|predecessors|versionHistory|isCheckedOut)$"});
    protected static final Map<String, Object> CRUD_SCENE_FOLDER = new HashMap<String, Object>(){
        {
            this.put("jcr:primaryType", "sling:Folder");
        }
    };

    public Scene(@NotNull BeanContext context, @NotNull SceneConfigurations.Config sceneConfig, @NotNull String contentType) {
        this.context = context;
        this.sceneConfig = sceneConfig;
        this.contentType = contentType;
        ResourceResolver resolver = this.context.getResolver();
        this.configResource = Objects.requireNonNull(resolver.getResource(this.sceneConfig.getPath()));
        String scenesRoot = sceneConfig.getScenesRoot();
        if (StringUtils.isBlank((CharSequence)scenesRoot)) {
            NodesConfiguration nodesConfig = (NodesConfiguration)context.getService(NodesConfiguration.class);
            scenesRoot = nodesConfig.getScenesContentRoot();
        }
        this.scenePath = scenesRoot + (contentType.startsWith("/") ? contentType : "/mnt/overlay/" + contentType);
        this.contentPath = this.scenePath + "/_/" + this.sceneConfig.getKey();
    }

    @NotNull
    public String getFrameUrl(String toolId) {
        if (this.frameUrl == null) {
            this.frameUrl = "";
            if (this.isContentPrepared()) {
                String uri;
                SceneConfigurations.Config.Tool tool = this.getConfig().getTool(toolId);
                if (tool != null && StringUtils.isNotBlank((CharSequence)(uri = tool.getUri()))) {
                    try {
                        this.frameUrl = IOUtils.toString((Reader)new ValueEmbeddingReader((Reader)new StringReader(uri), this.getSceneProperties()));
                    }
                    catch (IOException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                if (StringUtils.isBlank((CharSequence)this.frameUrl)) {
                    this.frameUrl = this.contentPath + ".html";
                }
            } else {
                String placeholder = this.getConfig().getPlaceholder();
                if (StringUtils.isNotBlank((CharSequence)placeholder)) {
                    try {
                        this.frameUrl = IOUtils.toString((Reader)new ValueEmbeddingReader((Reader)new StringReader(placeholder), this.getSceneProperties()));
                    }
                    catch (IOException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.frameUrl)) {
                this.frameUrl = this.context.getRequest().getContextPath() + this.frameUrl;
            }
        }
        return this.frameUrl;
    }

    @NotNull
    public SceneConfigurations.Config getConfig() {
        return this.sceneConfig;
    }

    @NotNull
    public String getElementPath() {
        if (this.elementPath == null) {
            Iterator found;
            String contentPath = this.getContentPath();
            if (StringUtils.isNotBlank((CharSequence)contentPath) && (found = this.context.getResolver().findResources("/jcr:root" + contentPath + "//sample", "xpath")).hasNext()) {
                this.elementPath = ((Resource)found.next()).getPath();
            }
            if (this.elementPath == null) {
                this.elementPath = "";
            }
        }
        return this.elementPath;
    }

    @NotNull
    public String getContentPath() {
        return this.contentPath;
    }

    public boolean isContentPrepared() {
        return !ResourceUtil.isNonExistingResource((Resource)this.getContentResource());
    }

    @NotNull
    public Resource getContentResource() {
        if (this.contentResource == null) {
            ResourceResolver resolver = this.context.getResolver();
            this.contentResource = resolver.getResource(this.contentPath);
            if (this.contentResource == null) {
                this.contentResource = resolver.resolve(this.contentPath);
            }
        }
        return this.contentResource;
    }

    @Nullable
    protected Resource getContentTemplate() {
        ResourceResolver resolver = this.context.getResolver();
        ValueMap configValues = this.configResource.getValueMap();
        String templatePath = (String)configValues.get("template", String.class);
        return templatePath != null ? resolver.getResource(templatePath) : null;
    }

    protected Map<String, Object> getSceneProperties() {
        if (this.sceneProperties == null) {
            this.sceneProperties = new HashMap<String, Object>();
            this.sceneProperties.put("path", this.contentPath);
            this.sceneProperties.put("name", this.sceneConfig.getKey());
            this.sceneProperties.put("type", this.contentType);
        }
        return this.sceneProperties;
    }

    @Nullable
    public Resource prepareContent(boolean resetContent) throws IOException {
        ResourceResolver resolver = this.context.getResolver();
        Resource sceneResource = this.giveSceneContent(resolver, this.scenePath + "/_");
        Resource contentTemplate = this.getContentTemplate();
        return contentTemplate != null ? this.applyTemplate(resolver, this.getSceneProperties(), sceneResource, this.sceneConfig.getKey(), contentTemplate, resetContent) : null;
    }

    protected Resource applyTemplate(@NotNull ResourceResolver resolver, @NotNull Map<String, Object> properties, @NotNull Resource contentParent, @NotNull String name, @NotNull Resource template, boolean resetContent) throws IOException {
        Resource content = contentParent.getChild(name);
        if (content == null) {
            ValueMap templateValues = template.getValueMap();
            ModifiableValueMapDecorator contentValues = new ModifiableValueMapDecorator(new HashMap());
            contentValues.put((Object)"jcr:primaryType", templateValues.get((Object)"jcr:primaryType"));
            this.applyProperties(properties, (ModifiableValueMap)contentValues, templateValues);
            content = resolver.create(contentParent, name, (Map)contentValues);
        } else {
            if (!resetContent) {
                return content;
            }
            ModifiableValueMap contentValues = (ModifiableValueMap)content.adaptTo(ModifiableValueMap.class);
            if (contentValues == null) {
                throw new PersistenceException("can't modify '" + content.getPath() + "'");
            }
            this.applyProperties(properties, contentValues, template.getValueMap());
            for (Resource contentChild : content.getChildren()) {
                if (template.getChild(contentChild.getName()) != null) continue;
                resolver.delete(contentChild);
            }
        }
        for (Resource templateChild : template.getChildren()) {
            this.applyTemplate(resolver, properties, content, templateChild.getName(), templateChild, resetContent);
        }
        return content;
    }

    protected void applyProperties(@NotNull Map<String, Object> properties, @NotNull ModifiableValueMap content, @NotNull ValueMap template) throws IOException {
        ArrayList<String> forRemoval = new ArrayList<String>();
        for (String name : content.keySet()) {
            if (!this.PROPERTY_FILTER.accept(name) || template.get((Object)name) != null) continue;
            forRemoval.add(name);
        }
        for (String name : forRemoval) {
            content.remove((Object)name);
        }
        for (String name : template.keySet()) {
            if (!this.PROPERTY_FILTER.accept(name)) continue;
            Object value = template.get((Object)name);
            if (value instanceof String) {
                value = IOUtils.toString((Reader)new ValueEmbeddingReader((Reader)new StringReader((String)value), properties));
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    values[i] = IOUtils.toString((Reader)new ValueEmbeddingReader((Reader)new StringReader(values[i]), properties));
                }
            }
            content.put((Object)name, value);
        }
    }

    protected Resource giveSceneContent(@NotNull ResourceResolver resolver, @NotNull String path) throws PersistenceException {
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            String name = StringUtils.substringAfterLast((String)path, (String)"/");
            String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
            Resource parent = this.giveSceneContent(resolver, parentPath);
            resource = resolver.create(parent, name, CRUD_SCENE_FOLDER);
        }
        return resource;
    }
}

