/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.remote.RemoteClientBuilder;
import java.net.ProxySelector;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
@Designate(ocd=Config.class, factory=true)
public class RemoteProxyBuilder
implements RemoteClientBuilder {
    private Config config;
    private HttpHost proxyHost;
    private Credentials proxyCredentials;
    private AuthScheme proxyAuthScheme = new BasicScheme();

    @Override
    public void configure(@NotNull HttpClientContext context) {
        if (this.proxyCredentials != null) {
            CredentialsProvider credentialsProvider = context.getCredentialsProvider();
            if (credentialsProvider == null) {
                credentialsProvider = new BasicCredentialsProvider();
                context.setCredentialsProvider(credentialsProvider);
            }
            credentialsProvider.setCredentials(new AuthScope(this.proxyHost), this.proxyCredentials);
        }
        if (this.proxyAuthScheme != null) {
            AuthCache authCache = context.getAuthCache();
            if (authCache == null) {
                authCache = new BasicAuthCache();
                context.setAuthCache(authCache);
            }
            context.getAuthCache().put(this.proxyHost, this.proxyAuthScheme);
        }
    }

    @Override
    public void configure(@NotNull HttpClientBuilder builder) {
        if (this.config != null) {
            if (this.config.proxy_system_default()) {
                builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
            } else if (this.proxyHost != null) {
                builder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(this.proxyHost));
            }
        }
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Config config) {
        this.config = config;
        this.proxyHost = null;
        this.proxyCredentials = null;
        this.proxyAuthScheme = null;
        if (!config.proxy_system_default() && StringUtils.isNotBlank((CharSequence)config.proxy_host()) && config.proxy_port() > 0) {
            this.proxyHost = new HttpHost(config.proxy_host(), config.proxy_port());
            if (StringUtils.isNotBlank((CharSequence)config.proxy_username()) && StringUtils.isNotBlank((CharSequence)config.proxy_password())) {
                this.proxyCredentials = new UsernamePasswordCredentials(config.proxy_username(), config.proxy_password());
                this.proxyAuthScheme = new BasicScheme();
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        this.proxyAuthScheme = null;
        this.proxyCredentials = null;
        this.proxyHost = null;
        this.config = null;
    }

    @ObjectClassDefinition(name="Composum Nodes Remote Resource Proxy")
    public static @interface Config {
        @AttributeDefinition(name="Aspect Key", description="the key to add (reference) this configuration aspect to a remote provider")
        public String aspect_key() default "proxy";

        @AttributeDefinition(name="Service Ranking", description="the ranking of this configuration")
        public int service_ranking() default 100;

        @AttributeDefinition(name="Use System Proxy", description="use the predefined proxy configuration of the host system")
        public boolean proxy_system_default() default false;

        @AttributeDefinition(name="Proxy Host", description="the hostname (or the ip address) of the proxy server")
        public String proxy_host();

        @AttributeDefinition(name="Proxy Port", description="the proxy port of the proxy server")
        public int proxy_port() default 3128;

        @AttributeDefinition(name="Proxy Username")
        public String proxy_username();

        @AttributeDefinition(name="Proxy Password", type=AttributeType.PASSWORD)
        public String proxy_password();

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "'{aspect.key}' ({service.ranking}) - use system: {proxy.system.default}, proxy: {proxy.host}:{proxy.port}";
    }
}

