/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.remote.RemoteClientBuilder;
import com.composum.sling.nodes.mount.remote.RemoteProvider;
import com.composum.sling.nodes.mount.remote.RemoteResource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemoteClient {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteClient.class);
    public static final Pattern REMOTE_URL_PATTERN = Pattern.compile("^(?<url>(?<scheme>https?)://(?<host>[^:/]+)(:(?<port>\\d+))?(?<context>/.+)?)/?$");
    @NotNull
    protected final RemoteProvider provider;
    @NotNull
    protected final Collection<String> builderKeys;
    private transient Collection<RemoteClientBuilder> builders;
    protected final HttpHost remoteHost;
    protected final String remoteUrl;
    private transient HttpClientContext clientContext;
    @NotNull
    private final List<Header> defaultHeaders;

    protected RemoteClient(@NotNull RemoteProvider provider, @NotNull RemoteProvider.Config config, @NotNull Collection<String> builderKeys) {
        this.provider = provider;
        this.builderKeys = builderKeys;
        Matcher matcher = REMOTE_URL_PATTERN.matcher(config.remote_url());
        if (matcher.matches()) {
            String scheme = matcher.group("scheme");
            String host = matcher.group("host");
            String portStr = matcher.group("port");
            int port = -1;
            if (StringUtils.isNotBlank((CharSequence)portStr)) {
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException nfex) {
                    LOG.error("invalid port: '{}'", (Object)portStr);
                }
            }
            this.remoteHost = new HttpHost(host, port, scheme);
            String url = matcher.group("url");
            while (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            this.remoteUrl = url;
            LOG.info("remote: '{}', host: '{}' ({}://{}:{})", new Object[]{this.remoteUrl, this.remoteHost, scheme, host, port});
        } else {
            this.remoteHost = null;
            this.remoteUrl = "";
            LOG.error("invalid remote URL '{}'", (Object)config.remote_url());
        }
        this.defaultHeaders = new ArrayList<Header>();
        this.defaultHeaders.add((Header)new BasicHeader("Authorization", this.getAuthHeader(config.login_username(), config.login_password())));
        for (String header : config.request_headers()) {
            if (!StringUtils.isNotBlank((CharSequence)header)) continue;
            String[] parts = StringUtils.split((String)header, (String)"=", (int)2);
            this.defaultHeaders.add((Header)new BasicHeader(parts[0], parts.length > 1 ? parts[1] : ""));
        }
    }

    public boolean isValid() {
        return this.remoteHost != null;
    }

    @NotNull
    public String getHttpUrl(@NotNull String resourcePath) {
        String path = this.provider.remotePath(resourcePath);
        return this.remoteUrl + path;
    }

    @NotNull
    public String getHttpUrl(@NotNull RemoteResource resource) {
        return this.getHttpUrl(resource.getPath());
    }

    protected HttpHead buildHttpHead(@NotNull String url) {
        return new HttpHead(url);
    }

    protected HttpGet buildHttpGet(@NotNull String url) {
        return new HttpGet(url);
    }

    protected HttpPropfind buildPropfind(@NotNull String url) throws IOException {
        return new HttpPropfind(url, 1, 1);
    }

    protected HttpPost buildHttpPost(@NotNull String url) {
        return new HttpPost(url);
    }

    public HttpResponse execute(@NotNull HttpUriRequest request) throws IOException {
        return this.execute(this.buildClient(), request);
    }

    public HttpResponse execute(@NotNull HttpClient client, @NotNull HttpUriRequest request) throws IOException {
        return client.execute(request, (HttpContext)this.getClientContext());
    }

    protected HttpClientContext getClientContext() {
        if (this.clientContext == null) {
            this.clientContext = new HttpClientContext();
            for (RemoteClientBuilder clientBuilder : this.getBuilders()) {
                clientBuilder.configure(this.clientContext);
            }
        }
        return this.clientContext;
    }

    @NotNull
    protected HttpClient buildClient() {
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultHeaders(this.defaultHeaders);
        for (RemoteClientBuilder clientBuilder : this.getBuilders()) {
            clientBuilder.configure(builder);
        }
        return builder.build();
    }

    protected Collection<RemoteClientBuilder> getBuilders() {
        if (this.builders == null) {
            this.builders = this.provider.clientSetup.getBuilders(this.builderKeys);
        }
        return this.builders;
    }

    protected String getAuthHeader(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
        return "Basic " + new String(encodedAuth);
    }
}

