/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.consoleplugin;

import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"service.description=Composum Nodes Service Graph Webconsole Plugin", "felix.webconsole.category=Composum", "felix.webconsole.label=servicegraph", "felix.webconsole.title=Service Graph", "felix.webconsole.css=servicegraph/slingconsole/composum/nodes/console/nodetypesplugin.css"})
public class ShowServiceGraphConsolePlugin
extends HttpServlet {
    public static final String PARAM_CLASSREGEX = "classregex";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_BUNDLE = "bundle";
    protected static final String LOC_CSS = "slingconsole/composum/nodes/console/nodetypesplugin.css";
    protected BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void writeForm(PrintWriter writer, HttpServletRequest request, String classRegex) {
        writer.println("<html><body><h2>Service reference structure</h2>");
        writer.println("<p>This shows the structure of the service crossreferences of a part of the application(s). Please be aware that this is not 100% complete - it reconstructs the usage by the types of the fields of the services as read out by Java reflection.</p>");
        writer.println("<form action=\"" + request.getRequestURL() + "\" method=\"get\">");
        writer.println("Show services with classnames matching regex: <input type=\"text\" size=\"80\" name=\"classregex\" value=\"" + classRegex + "\">\n<br>\nShow as \n  <input type=\"radio\" name=\"type\" value=\"graph\" checked> graph with <a href=\"https://github.com/magjac/d3-graphviz\">d3-graphviz</a>\n  <input type=\"radio\" name=\"type\" value=\"dotty\"> dotty for <a href=\"http://graphviz.org/\">Graphviz</a>\n  <input type=\"radio\" name=\"type\" value=\"text\"> Text.   Do <input type=\"radio\" name=\"bundle\" value=\"true\" checked> group / \n  <input type=\"radio\" name=\"bundle\" value=\"false\"> do not group services into bundles.\n  <input type=\"submit\">\n");
        writer.println("</form>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().endsWith(LOC_CSS)) {
            response.setContentType("text/css");
            IOUtils.copy((InputStream)Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/slingconsole/composum/nodes/console/nodetypesplugin.css")), (OutputStream)response.getOutputStream());
            return;
        }
        String type = ((String)StringUtils.defaultIfBlank((CharSequence)XSS.filter((String)request.getParameter(PARAM_TYPE)), (CharSequence)"graph")).toLowerCase();
        boolean isText = type.equals("text");
        boolean isGraph = type.equals("graph");
        boolean isConsole = request.getRequestURI().contains("console");
        boolean showBundles = ((String)StringUtils.defaultIfBlank((CharSequence)XSS.filter((String)request.getParameter(PARAM_BUNDLE)), (CharSequence)"true")).toLowerCase().equals("true");
        String classRegex = (String)StringUtils.defaultIfBlank((CharSequence)XSS.filter((String)request.getParameter(PARAM_CLASSREGEX)), (CharSequence)"^com.composum");
        Pattern classPattern = Pattern.compile(classRegex);
        PrintWriter writer = response.getWriter();
        if (isConsole && !request.getRequestURI().endsWith(".txt") && !request.getRequestURI().endsWith(".dot") && !request.getRequestURI().endsWith(".gv")) {
            response.setContentType("text/html");
            this.writeForm(writer, request, classRegex);
            writer.println("<h3 id='thegraph'>Graph</h3>");
            if (isGraph) {
                writer.println("<p>You can scroll around the graph by dragging it with the mouse. Within the graph, the scroll wheel works as zoom in / zoom out. <button onclick='maximizeGraph();'>Maximize graph</button>\n<a href=\"#asimage\">Go to saveable SVG</a><p>&nbsp;");
                writer.println("<div id=\"graph\" style=\"text-align: center;\"><div id=\"wait\" style=\"padding: 10px;\">(Please wait for rendering process.)</div></div>\n");
            }
            writer.println("<pre id=\"digraph\">");
        } else if (isText) {
            response.setContentType("text/plain");
        } else {
            response.setContentType("text/vnd.graphviz");
        }
        if (!isText) {
            writer.println(" digraph servicestructure {");
        }
        HashMap classes = new HashMap();
        try {
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(null, null);
            Arrays.sort(refs, Comparator.naturalOrder());
            for (ServiceReference ref : refs) {
                Class<?> clazz;
                Object service = null;
                try {
                    service = this.bundleContext.getService(ref);
                    if (service == null) {
                        if (!isText) continue;
                        writer.println(ref + " : no service");
                        continue;
                    }
                    clazz = service.getClass();
                }
                finally {
                    if (service != null) {
                        service = null;
                        this.bundleContext.ungetService(ref);
                    }
                }
                if (!classPattern.matcher(clazz.getName()).find()) continue;
                if (isText) {
                    writer.println(ref.toString());
                    writer.println("class: " + clazz.getName());
                    writer.println("from bundle " + ref.getBundle().getSymbolicName());
                    for (String propertyKey : ref.getPropertyKeys()) {
                        Object property = ref.getProperty(propertyKey);
                        if (property.getClass().isArray()) {
                            Object[] array = (Object[])property;
                            property = Arrays.asList(array).toString();
                        }
                        writer.println("    " + propertyKey + "=" + property);
                    }
                    continue;
                }
                classes.put(clazz, ref);
            }
            if (!isText) {
                this.writeReferences(writer, classes, classPattern, showBundles);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (!isText) {
            writer.println("}");
        }
        if (isConsole) {
            writer.println("</pre>");
            if (isGraph) {
                writer.println("<h3 id=\"asimage\">Graph as image</h3>");
                writer.println("<p>Here's the graph as SVG image (shown here in reduced size). Open or save the image using the browsers context menu.</p>");
                writer.println("<img id=\"saveimg\" style=\"max-width:256px;max-height:256px;min-width: 32px;min-height: 32px;border: 1px solid #000;\" />");
                writer.println("<script src=\"https://d3js.org/d3.v4.min.js\"></script>\n<script src=\"https://unpkg.com/viz.js@1.8.0/viz.js\" type=\"javascript/worker\"></script>\n<script src=\"https://unpkg.com/d3-graphviz@1.4.0/build/d3-graphviz.min.js\"></script>\n<script>\nfunction svg2img() {\n    var svg = document.querySelector('svg');\n    var xml = new XMLSerializer().serializeToString(svg);\n    var svg64 = btoa(xml);\n    var b64start = 'data:image/svg+xml;base64,';\n    var image64 = b64start + svg64;\n    return image64;\n};\n\n\nfunction createSvg() {\n    try {\n        document.getElementById('wait').style.display='none';\n        img = document.getElementById('saveimg');\n        img.src = svg2img();\n    }\n    catch (e) {\n        if (console) console.log(e);\n    }\n}\n\ndot = document.getElementById('digraph').innerText;\ngraphviz = d3.select(\"#graph\").graphviz();\ngraphviz.on('end',createSvg);\ngraphviz.renderDot(dot);\n\nfunction maximizeGraph() {\n    $('svg').css('width', window.innerWidth).css('height', window.innerHeight).css('position', 'fixed').css('left', 0).css('top', 0)\n}\n</script>");
            }
            writer.println("</html>");
        }
    }

    protected void writeReferences(PrintWriter writer, Map<Class<?>, ServiceReference<?>> classes, Pattern classPattern, boolean showBundles) {
        TreeMap classIdx = new TreeMap();
        for (Class<?> clazz : classes.keySet()) {
            classIdx.put(clazz.getName(), clazz);
        }
        TreeMap<String, String> shortnames = new TreeMap<String, String>();
        String prefix = StringUtils.getCommonPrefix((String[])classIdx.keySet().toArray(new String[0]));
        for (String cname : classIdx.keySet()) {
            String shortcname = StringUtils.removeStart((String)cname, (String)prefix);
            String pkg = StringUtils.substringBeforeLast((String)shortcname, (String)".");
            String cls = StringUtils.substringAfterLast((String)shortcname, (String)".");
            shortnames.put(cname, pkg + "\\n" + cls);
        }
        TreeSet<String> bundles = new TreeSet<String>();
        for (Map.Entry<Class<?>, ServiceReference<?>> entry : classes.entrySet()) {
            String bundleName = entry.getValue().getBundle().getSymbolicName();
            bundles.add(bundleName);
        }
        for (String bundle : bundles) {
            if (showBundles) {
                writer.println("    subgraph cluster_" + bundle.replaceAll("[^a-zA-Z0-9]+", "_") + " {");
                writer.println("        graph[style=dashed];");
                writer.println("        label=\"" + bundle + "\";");
            }
            for (Map.Entry classEntry : classIdx.entrySet()) {
                Class clazz = (Class)classEntry.getValue();
                String bundlename = classes.get(clazz).getBundle().getSymbolicName();
                if (!bundle.equals(bundlename)) continue;
                ArrayList<Class> referredClasses = new ArrayList<Class>();
                for (Class serviceOrSuper = clazz; serviceOrSuper != null; serviceOrSuper = serviceOrSuper.getSuperclass()) {
                    for (Field field : serviceOrSuper.getDeclaredFields()) {
                        ShowServiceGraphConsolePlugin.collectReferredClasses(field.getGenericType(), referredClasses, new HashSet<Type>());
                    }
                }
                TreeSet<String> refFields = new TreeSet<String>();
                block7: for (Class referredClass : referredClasses) {
                    if (!classPattern.matcher(referredClass.getName()).find()) continue;
                    for (Class serviceClass : classIdx.values()) {
                        if (!referredClass.isAssignableFrom(serviceClass)) continue;
                        refFields.add(serviceClass.getName());
                        continue block7;
                    }
                }
                for (String field : refFields) {
                    writer.println("        \"" + (String)shortnames.get(clazz.getName()) + "\" -> \"" + (String)shortnames.get(field) + "\";");
                }
            }
            if (!showBundles) continue;
            writer.println("    }");
        }
    }

    protected static void collectReferredClasses(Type type, List<Class> referredClasses, Set<Type> visited) {
        if (visited.contains(type) || type == null) {
            return;
        }
        visited.add(type);
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                referredClasses.add(clazz.getComponentType());
            } else {
                referredClasses.add(clazz);
                ShowServiceGraphConsolePlugin.collectReferredClasses(clazz.getGenericSuperclass(), referredClasses, visited);
                for (Type genericInterface : clazz.getGenericInterfaces()) {
                    ShowServiceGraphConsolePlugin.collectReferredClasses(genericInterface, referredClasses, visited);
                }
            }
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            ShowServiceGraphConsolePlugin.collectReferredClasses(TypeUtils.getArrayComponentType((Type)arrayType), referredClasses, visited);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ShowServiceGraphConsolePlugin.collectReferredClasses(parameterizedType.getRawType(), referredClasses, visited);
            ShowServiceGraphConsolePlugin.collectReferredClasses(parameterizedType.getOwnerType(), referredClasses, visited);
            for (Type typeArgument : TypeUtils.getTypeArguments((ParameterizedType)parameterizedType).values()) {
                ShowServiceGraphConsolePlugin.collectReferredClasses(typeArgument, referredClasses, visited);
            }
        }
    }
}

