/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.console;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.SlingUrl;
import com.composum.sling.nodes.components.MergedModel;
import com.composum.sling.nodes.service.ServletRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.settings.SlingSettingsService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Condition {
    public static final String KEY_RESOURCE_TYPE = "resourceType";
    public static final String KEY_PRIMARY_TYPE = "primaryType";
    public static final String KEY_VERSIONABLE = "versionable";
    public static final String KEY_MERGED = "merged";
    public static final String KEY_ACL = "acl";
    public static final String KEY_JCR = "jcr";
    public static final String KEY_CLASS = "class";
    public static final String KEY_SERVLET = "servlet";
    public static final String KEY_HTTP = "http";
    public static final String KEY_RUNMODE = "runmode";
    public static final String KEY_RESOURCE = "resource";
    public static final String KEY_RESTRICTIONS = "restrictions";
    public static final Condition MERGED_RESOURCE = new MergedResource();
    public static final Condition VERSIONABLE = new Versionable();
    public static final Condition CAN_HAVE_ACL = new CanHaveAcl();
    public static final Condition JCR_RESOURCE = new JcrResource();
    public static final Options DEFAULT = new Options().addFactory("resourceType", (key, pattern) -> pattern instanceof String ? new ResourceType((String)pattern) : null).addFactory("primaryType", (key, pattern) -> pattern instanceof String ? new PrimaryType((String)pattern) : null).addFactory("merged", (key, pattern) -> MERGED_RESOURCE).addFactory("versionable", (key, pattern) -> VERSIONABLE).addFactory("acl", (key, pattern) -> CAN_HAVE_ACL).addFactory("jcr", (key, pattern) -> JCR_RESOURCE).addFactory("restrictions", (key, pattern) -> pattern instanceof String ? new NodesRestrictions((String)pattern) : null).addFactory("resource", (key, pattern) -> pattern instanceof String ? new ResourcePermission((String)pattern) : null).addFactory("runmode", (key, pattern) -> pattern instanceof String ? new RunmodePermission((String)pattern) : null).addFactory("servlet", (key, pattern) -> pattern instanceof String ? new ServletPermission((String)pattern) : null).addFactory("class", (key, pattern) -> pattern instanceof String ? new ClassAvailability((String)pattern) : null).addFactory("http", (key, pattern) -> pattern instanceof String ? new HttpStatus((String)pattern) : null);

    public boolean accept(@NotNull BeanContext var1, @NotNull Resource var2);

    public static class Options
    implements Factory {
        private final Map<String, Factory> factorySet = new HashMap<String, Factory>();

        @Override
        @Nullable
        public Condition getCondition(@NotNull String key, @Nullable Object pattern) {
            Factory factory = this.factorySet.get(key);
            return factory != null ? factory.getCondition(key.toLowerCase(), pattern) : null;
        }

        @Nullable
        public Condition getCondition(@Nullable String rule) {
            if (StringUtils.isNotBlank((CharSequence)rule)) {
                String[] parts = StringUtils.split((String)rule, (String)":", (int)2);
                return this.getCondition(parts[0], parts.length > 1 ? parts[1] : null);
            }
            return null;
        }

        @NotNull
        public Options addFactory(@NotNull String key, @NotNull Factory factory) {
            this.factorySet.put(key, factory);
            return this;
        }
    }

    public static interface Factory {
        @Nullable
        public Condition getCondition(@NotNull String var1, @Nullable Object var2);
    }

    public static class MergedResource
    implements Condition {
        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            return MergedModel.isMergedResource(resource);
        }
    }

    public static class ResourceType
    implements Condition {
        protected final String pattern;

        public ResourceType(@NotNull String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            return StringUtils.isBlank((CharSequence)this.pattern) || resource.isResourceType(this.pattern);
        }
    }

    public static class PrimaryType
    implements Condition {
        protected final String pattern;

        public PrimaryType(@NotNull String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            return StringUtils.isBlank((CharSequence)this.pattern) || this.pattern.equals(resource.getValueMap().get("jcr:primaryType", String.class));
        }
    }

    public static class Versionable
    extends JcrResource {
        public static final Logger LOG = LoggerFactory.getLogger(Versionable.class);

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            ResourceResolver resolver;
            Session session;
            if (super.accept(context, resource) && (session = (Session)(resolver = resource.getResourceResolver()).adaptTo(Session.class)) != null) {
                try {
                    VersionManager versionManager = session.getWorkspace().getVersionManager();
                    versionManager.getBaseVersion(resource.getPath());
                    return true;
                }
                catch (UnsupportedRepositoryOperationException versionManager) {
                }
                catch (RepositoryException ex) {
                    LOG.error("unexpected exception checking '" + resource.getPath() + "'", (Throwable)ex);
                }
            }
            return false;
        }
    }

    public static class CanHaveAcl
    extends JcrResource {
    }

    public static class JcrResource
    implements Condition {
        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            return !ResourceUtil.isSyntheticResource((Resource)resource) && resource.adaptTo(Node.class) != null;
        }
    }

    public static class HttpStatus
    implements Condition {
        public static final Logger LOG = LoggerFactory.getLogger(HttpStatus.class);
        protected final int expectedStatus;
        protected final String serviceUrl;

        public HttpStatus(@NotNull String pattern) {
            String[] parts = StringUtils.split((String)pattern, (String)":", (int)2);
            if (parts.length < 2) {
                this.expectedStatus = 200;
                this.serviceUrl = parts[0];
            } else {
                this.expectedStatus = Integer.parseInt(parts[0]);
                this.serviceUrl = parts[1];
            }
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            boolean serviceAvailable = false;
            if (StringUtils.isNotBlank((CharSequence)this.serviceUrl)) {
                try {
                    SlingHttpServletRequest request = context.getRequest();
                    String relativeUrl = new SlingUrl(request).fromUrl(this.serviceUrl).getUrl();
                    String absoluteUrl = LinkUtil.getAbsoluteUrl((SlingHttpServletRequest)request, (String)relativeUrl);
                    HttpHead httpMethod = new HttpHead(absoluteUrl);
                    httpMethod.addHeader("Cookie", request.getHeader("Cookie"));
                    CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                    int status = httpClient.execute((HttpUriRequest)httpMethod).getStatusLine().getStatusCode();
                    serviceAvailable = status == this.expectedStatus;
                }
                catch (Exception ex) {
                    LOG.warn("precondition check failed: " + ex.getMessage());
                }
            }
            return serviceAvailable;
        }
    }

    public static class ClassAvailability
    implements Condition {
        public static final Logger LOG = LoggerFactory.getLogger(ClassAvailability.class);
        protected final String pattern;

        public ClassAvailability(@NotNull String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            boolean classAvailable = false;
            try {
                context.getType(this.pattern);
                classAvailable = true;
            }
            catch (Exception ex) {
                LOG.warn("precondition check failed: " + ex.getMessage());
            }
            return classAvailable;
        }
    }

    public static class ResourcePermission
    implements Condition {
        protected final String path;

        public ResourcePermission(@NotNull String pattern) {
            this.path = pattern;
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            String absolutePath = this.path.startsWith("/") ? this.path : ((CoreConfiguration)context.getService(CoreConfiguration.class)).getComposumBase() + this.path;
            return context.getResolver().getResource(absolutePath) != null;
        }
    }

    public static class NodesRestrictions
    implements Condition {
        protected final ServiceRestrictions.Key key;
        protected final ServiceRestrictions.Permission permission;

        public NodesRestrictions(@NotNull String pattern) {
            String[] keyValue = StringUtils.split((String)pattern, (String)"=", (int)2);
            this.key = new ServiceRestrictions.Key(keyValue[0]);
            ServiceRestrictions.Permission perm = null;
            if (keyValue.length > 1) {
                try {
                    perm = ServiceRestrictions.Permission.valueOf((String)keyValue[1]);
                }
                catch (IllegalArgumentException ignore) {
                    perm = ServiceRestrictions.Permission.none;
                }
            }
            this.permission = perm != null ? perm : ServiceRestrictions.Permission.write;
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            ServiceRestrictions restrictions = (ServiceRestrictions)context.getService(ServiceRestrictions.class);
            return restrictions != null && restrictions.isPermissible(context.getRequest(), this.key, this.permission) && restrictions.checkAuthorizables(context.getRequest(), restrictions.getRestrictions(this.key));
        }
    }

    public static class ServletPermission
    implements Condition {
        protected final String servletKey;

        public ServletPermission(@NotNull String pattern) {
            this.servletKey = pattern;
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            ServletRegistry registry = (ServletRegistry)context.getService(ServletRegistry.class);
            return registry.getServletData(this.servletKey) != null;
        }
    }

    public static class RunmodePermission
    implements Condition {
        protected final List<String> alternatives;

        public RunmodePermission(@NotNull String pattern) {
            this.alternatives = Arrays.asList(StringUtils.split((String)pattern, (String)","));
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            SlingSettingsService settings = (SlingSettingsService)context.getService(SlingSettingsService.class);
            java.util.Set runmodes = settings.getRunModes();
            for (String pattern : this.alternatives) {
                if ((pattern.startsWith("!") || !runmodes.contains(pattern)) && (!pattern.startsWith("!") || runmodes.contains(pattern.substring(1)))) continue;
                return true;
            }
            return this.alternatives.size() == 0;
        }
    }

    public static class Or
    extends Set {
        public Or(Condition ... conditions) {
            super(conditions);
        }

        public Or(String ... conditions) {
            super(conditions);
        }

        public Or() {
        }

        @Nullable
        public static Condition fromResource(@Nullable Resource resource) {
            return resource != null ? Or.fromProperties((Map<String, Object>)resource.getValueMap()) : null;
        }

        public static Condition fromProperties(@NotNull Map<String, Object> properties) {
            return Or.fromProperties(new Or(), properties);
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            for (Condition condition : this.conditions) {
                if (!condition.accept(context, resource)) continue;
                return true;
            }
            return this.conditions.isEmpty();
        }
    }

    public static class And
    extends Set {
        public And(Condition ... conditions) {
            super(conditions);
        }

        public And(String ... conditions) {
            super(conditions);
        }

        public And() {
        }

        @Nullable
        public static Condition fromResource(@Nullable Resource resource) {
            return resource != null ? And.fromProperties((Map<String, Object>)resource.getValueMap()) : null;
        }

        @NotNull
        public static Condition fromProperties(@NotNull Map<String, Object> properties) {
            return And.fromProperties(new And(), properties);
        }

        @Override
        public boolean accept(@NotNull BeanContext context, @NotNull Resource resource) {
            for (Condition condition : this.conditions) {
                if (condition.accept(context, resource)) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class Set
    implements Condition {
        protected final List<Condition> conditions = new ArrayList<Condition>();

        protected Set(Condition ... conditions) {
            this.conditions.addAll(Arrays.asList(conditions));
        }

        protected Set(String ... rules) {
            if (rules != null) {
                for (String rule : rules) {
                    Condition condition = DEFAULT.getCondition(rule);
                    if (condition == null) continue;
                    this.conditions.add(condition);
                }
            }
        }

        protected Set() {
        }

        protected static Condition fromProperties(@NotNull Set set, @NotNull Map<String, Object> properties) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                Condition condition = DEFAULT.getCondition(entry.getKey(), entry.getValue());
                if (condition == null) continue;
                set.conditions.add(condition);
            }
            return set;
        }
    }
}

