/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.browser;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.util.I18N;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.nodes.browser.BrowserViews;
import com.composum.sling.nodes.browser.MergeMountpointService;
import com.composum.sling.nodes.components.MergedModel;
import com.composum.sling.nodes.console.ConsoleServletBean;
import com.composum.sling.nodes.scene.SceneConfigurations;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/repository/resources")
public class Browser
extends ConsoleServletBean {
    private static final Logger LOG = LoggerFactory.getLogger(Browser.class);
    public static final String TYPE_FILE = "nt:file";
    public static final String TYPE_RESOURCE = "nt:resource";
    public static final String OAK_RESOURCE = "oak:Resource";
    public static final String TYPE_UNSTRUCTURED = "nt:unstructured";
    public static final String HTML = "html";
    public static final String JSP = "jsp";
    public static final String PDF = "pdf";
    public static final String PROP_DATA = "jcr:data";
    public static final String PROP_MIME_TYPE = "jcr:mimeType";
    public static final String DEFAULT_MIME_TYPE = "text/html";
    public static final Map<String, String> EDITOR_MODES = new HashMap<String, String>();
    public static final Map<String, String> FILE_ICONS;
    private transient MergeMountpointService mergeMountpointService;
    private transient String primaryType;
    private transient String resourceType;
    private transient Boolean isDeclaringType;
    private transient List<String> supertypeChain;
    private transient Map<String, Reference> resourceTypes;
    private transient Map<String, Reference> relatedPathSet;
    private transient Boolean overlayAvailable;
    private transient Boolean overrideAvailable;
    private transient Map<String, Reference> typeRootLabels;
    private transient String mimeType;
    private transient String nameExtension;
    private transient String viewType;
    private transient String textType;
    private transient String fileIcon;
    private transient Boolean isRenderable;
    private transient Boolean isFile;
    private transient Boolean isAsset;
    private transient Boolean isImage;
    private transient Boolean isVideo;
    private transient Boolean isText;
    private transient NodeHandle current;
    private transient NodeHandle parent;
    private transient List<NodeHandle> parents;
    public static final Pattern SETUP_SCRIPT_PATTERN;
    private transient Boolean setupScript;
    private transient String textSnippet;

    public Browser(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public Browser(BeanContext context) {
        super(context);
    }

    public Browser() {
    }

    public String getPrimaryType() {
        if (this.primaryType == null) {
            this.primaryType = "";
            try {
                NodeType type;
                Node node = (Node)this.resource.adaptTo(Node.class);
                this.primaryType = node != null ? ((type = node.getPrimaryNodeType()) != null ? type.getName() : "{untyped}") : (String)this.getResource().getValueMap().get("jcr:primaryType", (Object)"{no node}");
            }
            catch (RepositoryException ex) {
                this.primaryType = (String)this.getResource().getValueMap().get("jcr:primaryType", (Object)String.format("{%s}", ex.getMessage()));
            }
        }
        return this.primaryType;
    }

    public boolean isTyped() {
        return StringUtils.isNotBlank((CharSequence)this.getResourceType());
    }

    public boolean isDeclaringType() {
        if (this.isDeclaringType == null) {
            this.isDeclaringType = false;
            String path = this.getPath();
            if (path.startsWith(this.getOverrideRoot() + "/")) {
                path = path.substring(this.getOverrideRoot().length());
            }
            for (String root : this.getTypeSearchPath(true)) {
                if (!path.startsWith(root)) continue;
                this.isDeclaringType = true;
                break;
            }
        }
        return this.isDeclaringType;
    }

    public boolean isSourcePath() {
        return this.isDeclaringType() && !this.isOverlayResource() && !this.isOverrideResource();
    }

    @NotNull
    public String getResourceType() {
        if (this.resourceType == null) {
            this.resourceType = "";
            String type = Browser.getResourceType(this.getResource());
            if (StringUtils.isNotBlank((CharSequence)type) && !"sling:nonexisting".equals(type) && !this.getPath().equals(this.getOverlayRoot() + "/" + type)) {
                this.resourceType = type;
            }
        }
        return this.resourceType;
    }

    @Nullable
    public static String getResourceType(@NotNull ResourceHandle resource) {
        ResourceHandle handle;
        ResourceHandle contentResource;
        String result = resource.getResourceType();
        if ((StringUtils.isBlank((CharSequence)result) || ((String)resource.getValueMap().get("jcr:primaryType", (Object)"{no node}")).equals(result)) && (contentResource = resource.getContentResource()) != null && StringUtils.isNotBlank((CharSequence)(result = contentResource.getResourceType())) && result.equals((handle = ResourceHandle.use((Resource)contentResource)).getPrimaryType())) {
            result = null;
        }
        return result;
    }

    @Nullable
    protected String getResourceType(@Nullable String resourceType) {
        if (StringUtils.isNotBlank((CharSequence)resourceType)) {
            if (resourceType.startsWith(this.getOverrideRoot())) {
                resourceType = resourceType.substring(this.getOverrideRoot().length());
            }
            for (String root : this.getTypeSearchPath(true)) {
                if (!resourceType.startsWith(root)) continue;
                resourceType = resourceType.substring(root.length());
                break;
            }
        }
        return resourceType;
    }

    @Nullable
    protected Resource getTypeResource(@Nullable String resourceType, boolean includeOverlay) {
        ResourceResolver resolver = this.getResolver();
        if (StringUtils.isNotBlank((CharSequence)resourceType)) {
            if (!resourceType.startsWith("/")) {
                for (String root : this.getTypeSearchPath(includeOverlay)) {
                    Resource typeResource = resolver.getResource(root + resourceType);
                    if (typeResource == null) continue;
                    return typeResource;
                }
            }
            return resolver.getResource(resourceType);
        }
        return null;
    }

    @NotNull
    protected List<String> getTypeSearchPath(boolean includeOverlay) {
        ArrayList<String> typeSearchPath = new ArrayList<String>(Arrays.asList(this.getResolver().getSearchPath()));
        if (includeOverlay) {
            typeSearchPath.add(0, this.getOverlayRoot() + "/");
        }
        return typeSearchPath;
    }

    @NotNull
    public List<String> getSupertypeChain() {
        if (this.supertypeChain == null) {
            this.supertypeChain = new ArrayList<String>();
            ResourceHandle typeResource = this.resource;
            if (this.isDeclaringType()) {
                typeResource = this.getTypeResource(this.getResourceType(this.getPath()), false);
            }
            while (typeResource != null) {
                ValueMap values = typeResource.getValueMap();
                if ((typeResource = this.getTypeResource((String)values.get("sling:resourceSuperType", (Object)""), false)) == null) continue;
                this.supertypeChain.add(typeResource.getPath());
            }
        }
        return this.supertypeChain;
    }

    @NotNull
    protected Map<String, Reference> getResourceTypeSet() {
        if (this.resourceTypes == null) {
            this.resourceTypes = new LinkedHashMap<String, Reference>();
            String resourceType = this.getResourceType(this.isDeclaringType() ? this.getPath() : this.getResourceType());
            if (StringUtils.isNotBlank((CharSequence)resourceType)) {
                String path;
                Reference label;
                ResourceResolver resolver = this.getResolver();
                Map<String, Reference> labels = this.getTypeRootLabels();
                if (this.isOverrideAvailable()) {
                    label = labels.get(this.getOverrideRoot() + "/");
                    path = this.getOverridePath();
                    this.resourceTypes.put(label.getLabel(), new Reference(label.getLabel(), label.getTooltip() + "\n" + path, path));
                }
                if (this.isOverlayAvailable()) {
                    label = labels.get(this.getOverlayRoot() + "/");
                    path = this.getOverlayPath();
                    this.resourceTypes.put(label.getLabel(), new Reference(label.getLabel(), label.getTooltip() + "\n" + path, path));
                }
                String basePath = this.getBasePath();
                for (String root : this.getTypeSearchPath(false)) {
                    String resourceTypePath = root + resourceType;
                    Resource type = resolver.getResource(resourceTypePath);
                    Reference label2 = labels.get(root);
                    this.resourceTypes.put(label2.getLabel(), new Reference(label2.getLabel(), label2.getTooltip() + "\n" + resourceTypePath, resourceTypePath, type != null ? (basePath != null && resolver.getResource(basePath) != null ? "is-overlay" : null) : "overlay-option"));
                }
            }
        }
        return this.resourceTypes;
    }

    @NotNull
    public Map<String, Reference> getRelatedPathSet() {
        if (this.relatedPathSet == null) {
            if (this.isDeclaringType()) {
                this.relatedPathSet = this.getResourceTypeSet();
            } else {
                Resource type;
                String resourceType;
                this.relatedPathSet = new LinkedHashMap<String, Reference>();
                Map<String, Reference> labels = this.getTypeRootLabels();
                String overrideRoot = this.getOverrideRoot() + "/";
                if (this.isOverrideAvailable()) {
                    Reference label = labels.get(overrideRoot);
                    String overridePath = this.getOverridePath();
                    String basePath = this.getBasePath();
                    this.relatedPathSet.put(label.getLabel(), new Reference(label.getLabel(), label.getTooltip() + "\n" + overridePath, overridePath));
                    this.relatedPathSet.put("B", new Reference("B", I18N.get((SlingHttpServletRequest)this.getRequest(), (String)"Original (Base Path)") + "\n" + basePath, basePath));
                }
                if (StringUtils.isNotBlank((CharSequence)(resourceType = this.getResourceType())) && (type = this.getTypeResource(resourceType, false)) != null) {
                    String typePath = type.getPath();
                    this.relatedPathSet.put("T", new Reference("T", I18N.get((SlingHttpServletRequest)this.getRequest(), (String)"Resource Type") + "\n" + typePath, typePath));
                }
            }
        }
        return this.relatedPathSet;
    }

    public String getBasePath() {
        if (this.isOverrideResource()) {
            return this.getPath().substring(this.getOverrideRoot().length());
        }
        if (this.isOverlayResource()) {
            Resource type = this.getTypeResource(this.getResourceType(this.isDeclaringType() ? this.getPath() : this.getResourceType()), false);
            return type != null ? type.getPath() : this.getPath();
        }
        return this.getPath();
    }

    public String getOverlayRoot() {
        return this.getMergeMountpointService().overlayMergeMountPoint(this.getResolver());
    }

    private MergeMountpointService getMergeMountpointService() {
        if (this.mergeMountpointService == null) {
            this.mergeMountpointService = (MergeMountpointService)this.getSling().getService(MergeMountpointService.class);
        }
        return this.mergeMountpointService;
    }

    public boolean isOverlayResource() {
        return this.getPath().startsWith(this.getOverlayRoot() + "/");
    }

    public boolean isOverlayAvailable() {
        if (this.overlayAvailable == null) {
            String overlayPath = this.getOverlayPath();
            this.overlayAvailable = overlayPath != null && this.getResolver().getResource(overlayPath) != null;
        }
        return this.overlayAvailable;
    }

    @Nullable
    public String getOverlayPath() {
        return this.isOverlayResource() ? this.getPath() : (this.isDeclaringType() ? this.getOverlayRoot() + "/" + this.getResourceType(this.getPath()) : null);
    }

    public String getOverrideRoot() {
        return this.getMergeMountpointService().overrideMergeMountPoint(this.getResolver());
    }

    public boolean isOverrideResource() {
        return this.getPath().startsWith(this.getOverrideRoot() + "/");
    }

    public boolean isOverrideAvailable() {
        if (this.overrideAvailable == null) {
            this.overrideAvailable = this.getResolver().getResource(this.getOverridePath()) != null;
        }
        return this.overrideAvailable;
    }

    @NotNull
    public String getOverridePath() {
        return this.isOverrideResource() ? this.getPath() : this.getOverrideRoot() + this.getBasePath();
    }

    protected Map<String, Reference> getTypeRootLabels() {
        if (this.typeRootLabels == null) {
            this.typeRootLabels = new HashMap<String, Reference>();
            this.typeRootLabels.put(this.getOverrideRoot() + "/", new Reference("o/r", "Resource Merger - Override", this.getOverrideRoot()));
            this.typeRootLabels.put(this.getOverlayRoot() + "/", new Reference("o/l", "Resource Merger - Overlay", this.getOverlayRoot()));
            for (String root : this.getResolver().getSearchPath()) {
                String label = ("" + root.charAt(1)).toUpperCase();
                String path = StringUtils.removeEnd((String)root, (String)"/");
                this.typeRootLabels.put(root, new Reference(label, "Resource Resolver - " + path, path));
            }
        }
        return this.typeRootLabels;
    }

    public boolean isSceneAvailable() {
        Collection<SceneConfigurations.Config> availableScenes = this.getAvailableScenes();
        return !availableScenes.isEmpty();
    }

    @NotNull
    public Collection<SceneConfigurations.Config> getAvailableScenes() {
        return SceneConfigurations.instance((SlingHttpServletRequest)this.getRequest()).getSceneConfigs();
    }

    public boolean isRenderable() {
        if (this.isRenderable == null) {
            this.isRenderable = Browser.isRenderable(this.getResource(), this.getNameExtension());
        }
        return this.isRenderable;
    }

    public static boolean isRenderable(@NotNull ResourceHandle resource, @Nullable String extension) {
        return StringUtils.isNotBlank((CharSequence)Browser.getResourceType(resource)) || Browser.isText(resource) && (HTML.equalsIgnoreCase(extension) || Browser.getMimeType((Resource)resource).endsWith("/html")) || Browser.isFile(resource) && (PDF.equalsIgnoreCase(extension) || Browser.getMimeType((Resource)resource).endsWith("/pdf"));
    }

    public boolean isFile() {
        if (this.isFile == null) {
            this.isFile = Browser.isFile(this.getResource());
        }
        return this.isFile;
    }

    public static boolean isFile(@NotNull ResourceHandle resource) {
        ValueMap values;
        String typeName;
        boolean result = false;
        ResourceHandle contentResource = resource.getContentResource();
        if (contentResource == null) {
            contentResource = resource;
        }
        if (TYPE_RESOURCE.equals(typeName = (String)(values = contentResource.getValueMap()).get("jcr:primaryType", (Object)"")) || OAK_RESOURCE.equals(typeName) || TYPE_FILE.equals(typeName) || TYPE_UNSTRUCTURED.equals(typeName)) {
            if (values.containsKey((Object)PROP_DATA)) {
                result = true;
            } else {
                String mimeType = (String)contentResource.getValueMap().get(PROP_MIME_TYPE, String.class);
                if (StringUtils.isNotBlank((CharSequence)mimeType)) {
                    result = true;
                }
            }
        }
        return result;
    }

    @NotNull
    public String getFilePath() {
        return Browser.getFilePath(this.getResource());
    }

    @NotNull
    public static String getFilePath(@NotNull ResourceHandle resource) {
        if (Browser.isFile(resource)) {
            ResourceHandle fileRes = resource;
            if ("jcr:content".equals(resource.getName())) {
                fileRes = resource.getParent();
            }
            if (fileRes != null && fileRes.isOfType(TYPE_FILE)) {
                return fileRes.getPath();
            }
        }
        return "";
    }

    @NotNull
    public String getFileIcon() {
        if (this.fileIcon == null) {
            this.fileIcon = Browser.getFileIcon(this.getResource());
        }
        return this.fileIcon;
    }

    @NotNull
    public static String getFileIcon(@NotNull ResourceHandle resource) {
        String extension;
        String mimeType = MimeTypeUtil.getMimeType((Resource)resource, (String)DEFAULT_MIME_TYPE);
        String icon = Browser.getFileType(FILE_ICONS, mimeType, extension = ResourceUtil.getNameExtension((Resource)resource));
        return StringUtils.isNotBlank((CharSequence)icon) ? "file-" + icon + "-o" : "file-o";
    }

    public InputStream openFile() {
        if (this.isFile()) {
            ResourceHandle contentResource = this.getContentResource();
            if (contentResource == null) {
                contentResource = this.getResource();
            }
            ValueMap values = contentResource.getValueMap();
            return (InputStream)values.get(PROP_DATA, InputStream.class);
        }
        return null;
    }

    public boolean isAsset() {
        if (this.isAsset == null) {
            this.isAsset = ResourceUtil.isResourceType((Resource)this.resource, (String)"cpa:Asset");
        }
        return this.isAsset;
    }

    public boolean isImage() {
        if (this.isImage == null) {
            this.isImage = this.isFile() && this.getMimeType().startsWith("image/") || this.isAsset();
        }
        return this.isImage;
    }

    public String getImageCSS() {
        String mimeType = this.getMimeType();
        return mimeType.substring(mimeType.indexOf(47) + 1).replaceAll("[+]", " ");
    }

    public boolean isVideo() {
        if (this.isVideo == null) {
            this.isVideo = this.isFile() && this.getMimeType().startsWith("video/");
        }
        return this.isVideo;
    }

    public boolean isText() {
        if (this.isText == null) {
            this.isText = Browser.isText(this.getResource());
        }
        return this.isText;
    }

    public static boolean isText(@NotNull ResourceHandle resource) {
        return Browser.isFile(resource) && StringUtils.isNotBlank((CharSequence)Browser.getTextType(resource));
    }

    public boolean isMergedResource() {
        return MergedModel.isMergedResource((Resource)this.resource);
    }

    public boolean isJcrResource() {
        return !ResourceUtil.isSyntheticResource((Resource)this.resource) && this.resource.adaptTo(Node.class) != null;
    }

    public boolean isCanHaveAcl() {
        return this.isJcrResource();
    }

    public boolean isVersionable() {
        if (!this.isJcrResource()) {
            return false;
        }
        try {
            VersionManager versionManager = this.getSession().getWorkspace().getVersionManager();
            versionManager.getBaseVersion(this.getPath());
            return true;
        }
        catch (UnsupportedRepositoryOperationException e) {
            return false;
        }
        catch (RepositoryException e) {
            LOG.error("Bug: unknown error on " + this.getPath(), (Throwable)e);
            return false;
        }
    }

    public boolean isSetupScript() {
        if (this.setupScript == null) {
            this.setupScript = false;
            if (this.isText() && "json".equals(this.getTextType())) {
                this.setupScript = SETUP_SCRIPT_PATTERN.matcher(this.getTextSnippet()).matches();
            }
        }
        return this.setupScript;
    }

    @NotNull
    public String getTextSnippet() {
        if (this.textSnippet == null) {
            this.textSnippet = "";
            if (this.isText()) {
                try (InputStream data = this.openFile();){
                    if (data != null) {
                        char[] buffer = new char[512];
                        int len = IOUtils.read((Reader)new InputStreamReader(data), (char[])buffer);
                        this.textSnippet = new String(buffer, 0, len);
                    }
                }
                catch (IOException ex) {
                    LOG.error(ex.toString());
                }
            }
        }
        return this.textSnippet;
    }

    @NotNull
    public String getNameExtension() {
        if (this.nameExtension == null) {
            this.nameExtension = ResourceUtil.getNameExtension((Resource)this.getResource());
        }
        return this.nameExtension;
    }

    @NotNull
    public String getTextType() {
        if (this.textType == null) {
            this.textType = Browser.getTextType(this.getResource());
        }
        return this.textType;
    }

    @NotNull
    public static String getTextType(@NotNull ResourceHandle resource) {
        String mimeType = MimeTypeUtil.getMimeType((Resource)resource, (String)DEFAULT_MIME_TYPE);
        String extension = ResourceUtil.getNameExtension((Resource)resource);
        return Browser.getFileType(EDITOR_MODES, mimeType, extension);
    }

    @NotNull
    public static String getFileType(Map<String, String> typeMap, String mimeType, String extension) {
        String textType = null;
        if (StringUtils.isNotBlank((CharSequence)mimeType) && StringUtils.isBlank((CharSequence)(textType = typeMap.get(mimeType)))) {
            String[] parts = StringUtils.split((String)mimeType, (char)'/');
            if (parts.length > 1) {
                textType = typeMap.get(parts[1]);
            }
            if (StringUtils.isBlank((CharSequence)textType)) {
                if (StringUtils.isNotBlank((CharSequence)extension)) {
                    textType = typeMap.get(extension);
                }
                if (StringUtils.isBlank((CharSequence)textType)) {
                    textType = typeMap.get(parts[0]);
                }
            }
        }
        if (StringUtils.isBlank(textType) && StringUtils.isNotBlank((CharSequence)extension)) {
            textType = typeMap.get(extension);
        }
        if (textType == null) {
            textType = "";
        }
        return textType;
    }

    public String getViewType() {
        if (this.viewType == null) {
            BrowserViews.View genericView = BrowserViews.getView(this.context, (Resource)this.getResource());
            if (genericView != null) {
                return "generic";
            }
            this.viewType = "something";
            if (this.isFile()) {
                this.viewType = this.isVideo() ? "video" : (this.isImage() ? "image" : (this.isText() ? ("groovy".equalsIgnoreCase(this.getTextType()) ? "script" : "text") : "binary"));
            } else if (this.isAsset()) {
                this.viewType = "image";
            } else {
                String resourceType = this.getResourceType();
                if (StringUtils.isNotBlank((CharSequence)resourceType)) {
                    this.viewType = "typed";
                } else if (this.isDeclaringType()) {
                    this.viewType = "component";
                }
            }
        }
        return this.viewType;
    }

    public String getTabType() {
        String tabType = this.getRequest().getSelectors((StringFilter)new StringFilter.BlackList("^tab$"));
        tabType = StringUtils.isBlank((CharSequence)tabType) ? "properties" : (tabType.startsWith(".generic.") ? "generic" : tabType.substring(1));
        return tabType;
    }

    public String getName() {
        return this.getResource().getResourceName();
    }

    public NodeHandle getCurrent() {
        if (this.current == null) {
            this.current = new NodeHandle((Resource)this.resource);
        }
        return this.current;
    }

    public String getCurrentPathUrl() {
        return this.getCurrent().getPathUrl();
    }

    public String getMappedUrl() {
        return this.getCurrent().getMappedUrl();
    }

    public String getCurrentUrl() {
        return this.getCurrent().getUrl();
    }

    public String getEditCodeUrl() {
        return LinkUtil.getUnmappedUrl((SlingHttpServletRequest)this.getRequest(), (String)("/bin/cpm/edit/code.html" + this.getCurrent().getPath()));
    }

    public String getMimeType() {
        return this.getCurrent().getMimeType();
    }

    @NotNull
    public static String getMimeType(@NotNull Resource resource) {
        return MimeTypeUtil.getMimeType((Resource)resource, (String)"");
    }

    public NodeHandle getParent() {
        if (this.parent == null) {
            this.parent = new NodeHandle((Resource)this.resource.getParent());
        }
        return this.parent;
    }

    public List<NodeHandle> getParents() {
        if (this.parents == null) {
            String parentPath;
            this.parents = new ArrayList<NodeHandle>();
            ResourceHandle resource = this.getResource();
            while (StringUtils.isNotBlank((CharSequence)(parentPath = resource.getParentPath()))) {
                NodeHandle parent = new NodeHandle(this.getResolver().resolve(parentPath));
                this.parents.add(0, parent);
                resource = parent.getResource();
            }
        }
        return this.parents;
    }

    static {
        EDITOR_MODES.put("c", "c_cpp");
        EDITOR_MODES.put("cc", "c_cpp");
        EDITOR_MODES.put("cpp", "c_cpp");
        EDITOR_MODES.put("h", "c_cpp");
        EDITOR_MODES.put("hh", "c_cpp");
        EDITOR_MODES.put("cs", "csharp");
        EDITOR_MODES.put("clj", "clojure");
        EDITOR_MODES.put("css", "css");
        EDITOR_MODES.put("conf", "apache_conf");
        EDITOR_MODES.put("config", "text");
        EDITOR_MODES.put("csv", "text");
        EDITOR_MODES.put("tsv", "text");
        EDITOR_MODES.put("d", "d");
        EDITOR_MODES.put("dart", "dart");
        EDITOR_MODES.put("diff", "diff");
        EDITOR_MODES.put("patch", "diff");
        EDITOR_MODES.put("e", "eiffel");
        EDITOR_MODES.put("ecma", "javascript");
        EDITOR_MODES.put("esp", JSP);
        EDITOR_MODES.put("ftl", "ftl");
        EDITOR_MODES.put("groovy", "groovy");
        EDITOR_MODES.put("gvy", "groovy");
        EDITOR_MODES.put("handlebars", "handlebars");
        EDITOR_MODES.put("hbs", "handlebars");
        EDITOR_MODES.put("htm", HTML);
        EDITOR_MODES.put(HTML, HTML);
        EDITOR_MODES.put("xhtml", HTML);
        EDITOR_MODES.put("java", "java");
        EDITOR_MODES.put("javascript", "javascript");
        EDITOR_MODES.put("js", "javascript");
        EDITOR_MODES.put("json", "json");
        EDITOR_MODES.put(JSP, JSP);
        EDITOR_MODES.put("jspf", JSP);
        EDITOR_MODES.put("jspx", JSP);
        EDITOR_MODES.put("kt", "kotlin");
        EDITOR_MODES.put("less", "less");
        EDITOR_MODES.put("markdown", "markdown");
        EDITOR_MODES.put("md", "markdown");
        EDITOR_MODES.put("m", "objectivec");
        EDITOR_MODES.put("mm", "objectivec");
        EDITOR_MODES.put("php", "php");
        EDITOR_MODES.put("pl", "perl");
        EDITOR_MODES.put("properties", "properties");
        EDITOR_MODES.put("py", "python");
        EDITOR_MODES.put("rb", "ruby");
        EDITOR_MODES.put("ru", "ruby");
        EDITOR_MODES.put("ruby", "ruby");
        EDITOR_MODES.put("rs", "rust");
        EDITOR_MODES.put("rst", "text");
        EDITOR_MODES.put("scala", "scala");
        EDITOR_MODES.put("sass", "sass");
        EDITOR_MODES.put("scss", "scss");
        EDITOR_MODES.put("sh", "sh");
        EDITOR_MODES.put("sql", "sql");
        EDITOR_MODES.put("svg", "svg");
        EDITOR_MODES.put("svg+xml", "svg");
        EDITOR_MODES.put("swift", "swift");
        EDITOR_MODES.put("tcl", "tcl");
        EDITOR_MODES.put("tex", "tex");
        EDITOR_MODES.put("text", "text");
        EDITOR_MODES.put("textile", "textile");
        EDITOR_MODES.put("txt", "text");
        EDITOR_MODES.put("xml", "xml");
        EDITOR_MODES.put("xslt", "xml");
        EDITOR_MODES.put("xslt+xml", "xml");
        EDITOR_MODES.put("xquery", "xquery");
        EDITOR_MODES.put("xql", "xquery");
        EDITOR_MODES.put("yaml", "yaml");
        EDITOR_MODES.put("yml", "yaml");
        FILE_ICONS = new HashMap<String, String>();
        FILE_ICONS.put(PDF, PDF);
        FILE_ICONS.put("jar", "archive");
        FILE_ICONS.put("far", "archive");
        FILE_ICONS.put("war", "archive");
        FILE_ICONS.put("zip", "archive");
        FILE_ICONS.put("tar", "archive");
        FILE_ICONS.put("gtar", "archive");
        FILE_ICONS.put("gzip", "archive");
        FILE_ICONS.put("gz", "archive");
        FILE_ICONS.put("audio", "audio");
        FILE_ICONS.put("au", "audio");
        FILE_ICONS.put("snd", "audio");
        FILE_ICONS.put("wav", "audio");
        FILE_ICONS.put("aif", "audio");
        FILE_ICONS.put("aiff", "audio");
        FILE_ICONS.put("aifc", "audio");
        FILE_ICONS.put("ram", "audio");
        FILE_ICONS.put("ra", "audio");
        FILE_ICONS.put("mp2", "audio");
        FILE_ICONS.put("m4a", "audio");
        FILE_ICONS.put("m4v", "video");
        FILE_ICONS.put("mp4", "video");
        FILE_ICONS.put("mov", "video");
        FILE_ICONS.put("msword", "word");
        FILE_ICONS.put("doc", "word");
        FILE_ICONS.put("docx", "word");
        FILE_ICONS.put("msexcel", "excel");
        FILE_ICONS.put("xls", "excel");
        FILE_ICONS.put("xlsx", "excel");
        FILE_ICONS.put("mspowerpoint", "powerpoint");
        FILE_ICONS.put("ppt", "powerpoint");
        FILE_ICONS.put("pptx", "powerpoint");
        SETUP_SCRIPT_PATTERN = Pattern.compile(".*[\"']?acl[\"']?\\s*:\\s*[\\[{].*", 40);
    }

    public class NodeHandle {
        protected ResourceHandle resource;
        protected String name;
        protected String path;
        protected String pathUrl;
        protected String mappedUrl;
        protected String url;
        protected String mimeType;

        public NodeHandle(Resource resource) {
            this.resource = ResourceHandle.use((Resource)resource);
        }

        public ResourceHandle getResource() {
            return this.resource;
        }

        public String getId() {
            return this.resource.getId();
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.resource.getName();
                if (StringUtils.isBlank((CharSequence)this.name)) {
                    this.name = "jcr:root";
                }
            }
            return this.name;
        }

        public String getNameEscaped() {
            return StringEscapeUtils.escapeHtml4((String)this.getName());
        }

        public String getPath() {
            if (this.path == null) {
                this.path = this.resource.getPath();
            }
            return this.path;
        }

        public String getPathEncoded() {
            return LinkUtil.encodePath((String)this.getPath());
        }

        public String getPathUrl() {
            if (this.pathUrl == null) {
                this.pathUrl = this.getPathEncoded();
                this.pathUrl = this.pathUrl + LinkUtil.getExtension((ResourceHandle)this.resource, (String)(Browser.this.isAsset() ? "" : null));
            }
            return this.pathUrl;
        }

        public String getMappedUrl() {
            if (this.mappedUrl == null) {
                this.mappedUrl = LinkUtil.getMappedUrl((SlingHttpServletRequest)Browser.this.getRequest(), (String)this.getPath());
            }
            return this.mappedUrl;
        }

        public String getUrl() {
            if (this.url == null) {
                this.url = LinkUtil.getUrl((SlingHttpServletRequest)Browser.this.getRequest(), (String)this.getPath(), (String)(Browser.this.isAsset() ? "" : null));
            }
            return this.url;
        }

        public String getMimeType() {
            if (this.mimeType == null) {
                this.mimeType = MimeTypeUtil.getMimeType((Resource)this.resource, (String)Browser.DEFAULT_MIME_TYPE);
            }
            return this.mimeType;
        }
    }

    public static class Reference {
        @NotNull
        protected final String label;
        @Nullable
        protected final String tooltip;
        @NotNull
        protected final String path;
        @Nullable
        protected final String actions;

        public Reference(@NotNull String label, @Nullable String tooltip, @NotNull String path) {
            this(label, tooltip, path, null);
        }

        public Reference(@NotNull String label, @Nullable String tooltip, @NotNull String path, @Nullable String actions) {
            this.label = label;
            this.tooltip = tooltip;
            this.path = path;
            this.actions = actions;
        }

        @NotNull
        public String getLabel() {
            return this.label;
        }

        @Nullable
        public String getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        @NotNull
        public String getActions() {
            return this.actions != null ? this.actions : "";
        }

        public String toString() {
            return "Reference{label='" + this.label + '\'' + ", actions='" + this.actions + '\'' + ", path='" + this.path + '\'' + '}';
        }
    }
}

