/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.util.ServiceHandle;
import org.apache.sling.xss.ProtectionContext;
import org.apache.sling.xss.XSSAPI;
import org.apache.sling.xss.XSSFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XSS {
    protected static ServiceHandle<XSSAPI> XSSAPI_HANDLE = new ServiceHandle<XSSAPI>(XSSAPI.class);
    protected static ServiceHandle<XSSFilter> XSSFilter_HANDLE = new ServiceHandle<XSSFilter>(XSSFilter.class);

    @NotNull
    public static XSSAPI api() {
        return XSSAPI_HANDLE.getService();
    }

    @NotNull
    public static XSSFilter filter() {
        return XSSFilter_HANDLE.getService();
    }

    protected XSS() {
    }

    @Nullable
    public static Integer getValidInteger(@Nullable String integer, int defaultValue) {
        return XSS.api().getValidInteger(integer, defaultValue);
    }

    @Nullable
    public static Long getValidLong(@Nullable String source, long defaultValue) {
        return XSS.api().getValidLong(source, defaultValue);
    }

    @Nullable
    public static Double getValidDouble(@Nullable String source, double defaultValue) {
        return XSS.api().getValidDouble(source, defaultValue);
    }

    @Nullable
    public static String getValidDimension(@Nullable String dimension, @Nullable String defaultValue) {
        return XSS.api().getValidDimension(dimension, defaultValue);
    }

    @NotNull
    public static String getValidHref(@Nullable String url) {
        return XSS.api().getValidHref(url);
    }

    @Nullable
    public static String getValidJSToken(@Nullable String token, @Nullable String defaultValue) {
        return XSS.api().getValidJSToken(token, defaultValue);
    }

    @Nullable
    public static String getValidStyleToken(@Nullable String token, @Nullable String defaultValue) {
        return XSS.api().getValidStyleToken(token, defaultValue);
    }

    @Nullable
    public static String getValidCSSColor(@Nullable String color, @Nullable String defaultColor) {
        return XSS.api().getValidCSSColor(color, defaultColor);
    }

    public static String getValidMultiLineComment(@Nullable String comment, @Nullable String defaultComment) {
        return XSS.api().getValidMultiLineComment(comment, defaultComment);
    }

    public static String getValidJSON(@Nullable String json, @Nullable String defaultJson) {
        return XSS.api().getValidJSON(json, defaultJson);
    }

    public static String getValidXML(@Nullable String xml, @Nullable String defaultXml) {
        return XSS.api().getValidXML(xml, defaultXml);
    }

    @Nullable
    public static String encodeForHTML(@Nullable String source) {
        return XSS.api().encodeForHTML(source);
    }

    @Nullable
    public static String encodeForHTMLAttr(@Nullable String source) {
        return XSS.api().encodeForHTMLAttr(source);
    }

    @Nullable
    public static String encodeForXML(@Nullable String source) {
        return XSS.api().encodeForXML(source);
    }

    @Nullable
    public static String encodeForXMLAttr(@Nullable String source) {
        return XSS.api().encodeForXMLAttr(source);
    }

    @Nullable
    public static String encodeForJSString(@Nullable String source) {
        return XSS.api().encodeForJSString(source);
    }

    @Nullable
    public static String encodeForCSSString(@Nullable String source) {
        return XSS.api().encodeForCSSString(source);
    }

    @NotNull
    public static String filterHTML(@Nullable String source) {
        return XSS.api().filterHTML(source);
    }

    public static boolean check(ProtectionContext context, String src) {
        return XSS.filter().check(context, src);
    }

    public static String filter(String src) {
        return XSS.filter().filter(src);
    }

    public static String[] filter(String[] src) {
        if (src != null) {
            for (int i = 0; i < src.length; ++i) {
                src[i] = XSS.filter(src[i]);
            }
        }
        return src;
    }

    public static String filter(String contextName, String src) {
        ProtectionContext context = ProtectionContext.fromName((String)contextName);
        return context != null ? XSS.filter().filter(src) : XSS.filter().filter(context, src);
    }

    public static String filter(ProtectionContext context, String src) {
        return XSS.filter().filter(context, src);
    }

    public static boolean isValidHref(String url) {
        return XSS.filter().isValidHref(url);
    }
}

