/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.JcrResource;
import com.composum.sling.core.util.CoreConstants;
import com.composum.sling.core.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil
extends org.apache.sling.api.resource.ResourceUtil
implements CoreConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtil.class);
    public static final Map<String, List<String>> NODE_TYPE_MAP = new HashMap<String, List<String>>();

    public static List<Resource> getChildrenByType(Resource resource, List<String> typeSet) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        if (resource != null) {
            block0: for (Resource child : resource.getChildren()) {
                for (String type : typeSet) {
                    if (!ResourceUtil.isResourceType(child, type)) continue;
                    children.add(child);
                    continue block0;
                }
            }
        }
        return children;
    }

    public static List<Resource> getChildrenByType(Resource resource, String type) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        if (resource != null) {
            for (Resource child : resource.getChildren()) {
                if (!ResourceUtil.isResourceType(child, type)) continue;
                children.add(child);
            }
        }
        return children;
    }

    public static List<Resource> getChildrenByResourceType(Resource resource, String resourceType) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        if (resource != null) {
            for (Resource child : resource.getChildren()) {
                if (!child.isResourceType(resourceType)) continue;
                children.add(child);
            }
        }
        return children;
    }

    public static int getIndexOfSameType(Resource resource) {
        if (resource != null) {
            String name = resource.getName();
            String type = resource.getResourceType();
            Resource parent = resource.getParent();
            if (parent != null) {
                int index = 0;
                for (Resource child : parent.getChildren()) {
                    if (!child.isResourceType(type)) continue;
                    if (name.equals(child.getName())) {
                        return index;
                    }
                    ++index;
                }
            }
        }
        return -1;
    }

    public static Resource getNextOfSameType(Resource resource, boolean wrapAround) {
        if (resource != null) {
            String name = resource.getName();
            String type = resource.getResourceType();
            Resource parent = resource.getParent();
            if (parent != null) {
                boolean returnNext = false;
                for (Resource child : parent.getChildren()) {
                    if (!child.isResourceType(type)) continue;
                    if (returnNext) {
                        return child;
                    }
                    if (!name.equals(child.getName())) continue;
                    returnNext = true;
                }
                if (returnNext && wrapAround) {
                    for (Resource child : parent.getChildren()) {
                        if (!child.isResourceType(type)) continue;
                        return child;
                    }
                }
            }
        }
        return null;
    }

    public static String getNameExtension(Resource resource) {
        int dot;
        String name = resource.getName();
        if ("jcr:content".equals(name)) {
            name = Objects.requireNonNull(resource.getParent()).getName();
        }
        String extension = (dot = name.lastIndexOf(46)) >= 0 ? name.substring(dot + 1).toLowerCase() : "";
        return extension;
    }

    public static String getPrimaryType(Resource resource) {
        String result = null;
        if (resource != null) {
            if (resource instanceof JcrResource) {
                result = ((JcrResource)resource).getPrimaryType();
            } else {
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    try {
                        NodeType type = node.getPrimaryNodeType();
                        if (type != null) {
                            result = type.getName();
                        }
                    }
                    catch (RepositoryException type) {
                        // empty catch block
                    }
                }
                if (result == null) {
                    ValueMap values = resource.getValueMap();
                    result = (String)values.get("jcr:primaryType", String.class);
                }
            }
        }
        return result;
    }

    public static boolean isResourceType(@Nullable Resource resource, String resourceType) {
        return resource != null && (resource.isResourceType(resourceType) || ResourceUtil.isPrimaryType(resource, resourceType) || ResourceUtil.isNodeType(resource, resourceType));
    }

    public static boolean isPrimaryType(Resource resource, String primaryType) {
        return primaryType.equals(ResourceUtil.getPrimaryType(resource));
    }

    public static boolean isNodeType(Resource resource, String primaryType) {
        if (resource != null) {
            try {
                String[] mixins;
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    return node.isNodeType(primaryType);
                }
                ValueMap values = resource.getValueMap();
                if (ResourceUtil.isNodeType(primaryType, (String)values.get("jcr:primaryType", String.class))) {
                    return true;
                }
                for (String mixin : mixins = (String[])values.get("jcr:mixinTypes", (Object)new String[0])) {
                    if (!ResourceUtil.isNodeType(primaryType, mixin)) continue;
                    return true;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isNodeType(String wanted, String probe) {
        if (wanted.equals(probe)) {
            return true;
        }
        List<String> variations = NODE_TYPE_MAP.get(wanted);
        return variations != null && variations.contains(probe);
    }

    public static Resource getResourceType(Resource resource) {
        return resource != null ? ResourceUtil.getResourceType(resource.getResourceResolver(), resource.getResourceType()) : null;
    }

    public static Resource getResourceType(ResourceResolver resolver, String resourceTypeName) {
        Resource resourceType = null;
        if (StringUtils.isNotBlank((CharSequence)resourceTypeName)) {
            if (resourceTypeName.startsWith("/")) {
                resourceType = resolver.getResource(resourceTypeName);
            } else {
                String[] searchPath;
                for (String path : searchPath = resolver.getSearchPath()) {
                    resourceType = resolver.getResource(path + resourceTypeName);
                    if (resourceType == null) continue;
                    return resourceType;
                }
            }
        }
        return resourceType;
    }

    public static boolean isResourceType(Resource resource, Pattern pattern) {
        return resource != null && ResourceUtil.isResourceType(resource.getResourceResolver(), resource.getResourceType(), pattern);
    }

    public static boolean isResourceType(ResourceResolver resolver, String resourceTypeName, Pattern pattern) {
        if (StringUtils.isNotBlank((CharSequence)resourceTypeName)) {
            if (pattern.matcher(resourceTypeName).find()) {
                return true;
            }
            Resource resourceType = ResourceUtil.getResourceType(resolver, resourceTypeName);
            if (resourceType == null) {
                return false;
            }
            ValueMap values = resourceType.getValueMap();
            String resourceSuperTypeName = (String)values.get("sling:resourceSuperType", (Object)"");
            return ResourceUtil.isResourceType(resolver, resourceSuperTypeName, pattern);
        }
        return false;
    }

    public static <T> T getTypeProperty(Resource resource, String name, T defaultValue) {
        T value = ResourceUtil.getTypeProperty(resource, name, PropertyUtil.getType(defaultValue));
        return value != null ? value : defaultValue;
    }

    public static <T> T getTypeProperty(Resource resource, String name, Class<T> type) {
        return resource != null ? (T)ResourceUtil.getTypeProperty(resource.getResourceResolver(), resource.getResourceType(), name, type) : null;
    }

    public static <T> T getTypeProperty(ResourceResolver resolver, String resourceTypeName, String name, Class<T> type) {
        ValueMap values;
        Object value = null;
        Resource resourceType = ResourceUtil.getResourceType(resolver, resourceTypeName);
        if (resourceType != null && (value = (values = resourceType.getValueMap()).get(name, type)) == null) {
            String resourceSuperTypeName = (String)values.get("sling:resourceSuperType", (Object)"");
            value = ResourceUtil.getTypeProperty(resolver, resourceSuperTypeName, name, type);
        }
        return (T)value;
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path) throws RepositoryException {
        return ResourceUtil.getOrCreateResource(resolver, path, null);
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path, String primaryTypes) throws RepositoryException {
        Resource resource = resolver.getResource(path);
        if (resource == null && (path = ResourceUtil.normalize((String)path)) != null) {
            Resource parent;
            int lastTypeSegment;
            int lastPathSegment = path.lastIndexOf(47);
            String parentPath = "/";
            String name = path;
            if (lastPathSegment >= 0) {
                name = path.substring(lastPathSegment + 1);
                parentPath = path.substring(0, lastPathSegment);
                if (StringUtils.isBlank((CharSequence)parentPath)) {
                    parentPath = "/";
                }
            }
            String parentTypes = primaryTypes;
            String type = primaryTypes;
            if (primaryTypes != null && (lastTypeSegment = primaryTypes.lastIndexOf(47)) >= 0) {
                type = primaryTypes.substring(lastTypeSegment + 1);
                parentTypes = primaryTypes.substring(0, lastTypeSegment);
            }
            if ((parent = ResourceUtil.getOrCreateResource(resolver, parentPath, parentTypes)) != null) {
                Node node = (Node)parent.adaptTo(Node.class);
                if (node != null) {
                    if (StringUtils.isNotBlank((CharSequence)type)) {
                        node.addNode(name, type);
                    } else {
                        node.addNode(name);
                    }
                } else {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    if (StringUtils.isNotBlank((CharSequence)type)) {
                        properties.put("jcr:primaryType", type);
                    }
                    try {
                        resolver.create(parent, name, properties);
                    }
                    catch (PersistenceException pex) {
                        LOG.error(pex.getMessage(), (Throwable)pex);
                        throw new RepositoryException((Throwable)pex);
                    }
                }
                resource = parent.getChild(name);
            }
        }
        return resource;
    }

    public static boolean containsPath(List<Resource> collection, Resource resource) {
        return ResourceUtil.containsPath(collection, resource.getPath());
    }

    public static boolean containsPath(List<Resource> collection, String path) {
        for (Resource item : collection) {
            if (!item.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String[] splitPathAndName(@NotNull String path) {
        String[] result = new String[2];
        int nameSeparator = path.lastIndexOf(47);
        if (nameSeparator >= 0) {
            result[0] = path.substring(0, nameSeparator);
            result[1] = path.substring(nameSeparator + 1);
            if (result[0].isEmpty()) {
                result[0] = "/";
            }
        } else {
            result[0] = null;
            result[1] = path;
        }
        return result;
    }

    public static Resource getOrCreateChild(Resource resource, String relPath, String primaryTypes) throws RepositoryException {
        Resource child = null;
        if (resource != null) {
            ResourceResolver resolver = resource.getResourceResolver();
            String path = resource.getPath();
            while (relPath.startsWith("/")) {
                relPath = relPath.substring(1);
            }
            if (StringUtils.isNotBlank((CharSequence)relPath)) {
                path = path + "/" + relPath;
            }
            child = ResourceUtil.getOrCreateResource(resolver, path, primaryTypes);
        }
        return child;
    }

    public static boolean isWriteEnabled(Resource resource, String relPath) throws RepositoryException {
        ResourceResolver resolver = resource.getResourceResolver();
        Session session = Objects.requireNonNull((Session)resolver.adaptTo(Session.class));
        AccessControlManager accessManager = AccessControlUtil.getAccessControlManager((Session)session);
        String resourcePath = resource.getPath();
        Privilege[] addPrivileges = new Privilege[]{accessManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")};
        boolean result = accessManager.hasPrivileges(resourcePath, addPrivileges);
        if (StringUtils.isNotBlank((CharSequence)relPath)) {
            if (!resourcePath.endsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            resourcePath = resourcePath + relPath;
        }
        Privilege[] changePrivileges = new Privilege[]{accessManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties")};
        try {
            result = result && accessManager.hasPrivileges(resourcePath, changePrivileges);
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isRenderableFile(Resource resource) {
        boolean result = false;
        try {
            String typeName;
            Node node = (Node)resource.adaptTo(Node.class);
            if (node != null) {
                NodeType type = node.getPrimaryNodeType();
                typeName = type.getName();
            } else {
                typeName = (String)resource.getValueMap().get("jcr:primaryType", (Object)"");
            }
            if ("nt:file".equals(typeName)) {
                String resoureName = resource.getName();
                result = resoureName.toLowerCase().endsWith(".html");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isFile(Resource resource) {
        try {
            String typeName = null;
            Node node = (Node)resource.adaptTo(Node.class);
            if (node != null) {
                NodeType type = node.getPrimaryNodeType();
                if (type != null) {
                    typeName = type.getName();
                }
            } else {
                typeName = (String)resource.getValueMap().get("jcr:primaryType", String.class);
            }
            if (typeName != null) {
                switch (typeName) {
                    case "nt:file": {
                        return true;
                    }
                    case "nt:resource": 
                    case "nt:unstructured": {
                        String mimeType = null;
                        try {
                            if (node != null) {
                                Property propMimeType = node.getProperty("jcr:mimeType");
                                if (propMimeType != null) {
                                    mimeType = propMimeType.getString();
                                }
                                node.getProperty("jcr:data");
                            } else {
                                mimeType = (String)resource.getValueMap().get("jcr:mimeType", (Object)"");
                            }
                            return StringUtils.isNotBlank((CharSequence)mimeType);
                        }
                        catch (PathNotFoundException pathNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (RepositoryException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static Resource getDataResource(Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                try {
                    node.getProperty("jcr:data");
                    return resource;
                }
                catch (PathNotFoundException pnfex) {
                    Node contentNode = node.getNode("jcr:content");
                    contentNode.getProperty("jcr:data");
                    return resource.getChild("jcr:content");
                }
            }
            catch (RepositoryException pnfex) {}
        } else {
            if (resource.getValueMap().get((Object)"jcr:data") != null) {
                return resource;
            }
            Resource contentRes = resource.getChild("jcr:content");
            if (contentRes != null && contentRes.getValueMap().get((Object)"jcr:data") != null) {
                return contentRes;
            }
        }
        return null;
    }

    public static Binary getBinaryData(Resource resource) {
        return PropertyUtil.getBinaryData((Node)resource.adaptTo(Node.class));
    }

    @Nullable
    public static Resource getByUuid(@NotNull ResourceResolver resolver, @Nullable String uuid) throws RepositoryException {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            return null;
        }
        Resource result = null;
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session != null) {
            try {
                Node node = session.getNodeByIdentifier(uuid);
                result = resolver.getResource(node.getPath());
            }
            catch (ItemNotFoundException e) {
                LOG.debug("Node not found by uuid {}", (Object)uuid);
            }
        } else {
            throw new RepositoryException("Cannot get JCR Session from resolver " + resolver);
        }
        return result;
    }

    @Nullable
    public static Resource getReferredResource(@Nullable Resource propertyResource) throws RepositoryException {
        Resource referredResource;
        if (propertyResource == null) {
            return null;
        }
        Property property = (Property)propertyResource.adaptTo(Property.class);
        Node node = property != null ? property.getNode() : null;
        String path = node != null ? node.getPath() : null;
        Resource resource = referredResource = path != null ? propertyResource.getResourceResolver().getResource(path) : null;
        if (referredResource == null) {
            if (property == null) {
                LOG.debug("Could not get Property for {}", (Object)propertyResource.getPath());
            } else if (StringUtils.isNotEmpty((CharSequence)property.getString()) && property.getDefinition() != null && 9 == property.getDefinition().getRequiredType()) {
                LOG.warn("Inconsistent JCR: could not find referred resource for strong reference at {}", (Object)propertyResource.getPath());
            }
        }
        return referredResource;
    }

    static {
        NODE_TYPE_MAP.put("nt:hierarchyNode", Arrays.asList("nt:folder", "sling:Folder", "sling:OrderedFolder"));
    }
}

