/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.ResourceHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MimeTypeUtil.class);
    public static final Pattern HAS_FILE_EXT_PATTERN = Pattern.compile("^.*\\.([a-zA-Z]+[0-9]?)$");
    public static final Pattern FILE_EXT_FROM_MIME = Pattern.compile("^.*/([a-zA-Z]+[0-9]?)$");
    private static MimeTypes mimeTypes;

    public static boolean isMimeType(Resource resource, String pattern) {
        return MimeTypeUtil.isMimeType(resource, Pattern.compile(pattern));
    }

    public static boolean isMimeType(Resource resource, Pattern pattern) {
        String mimeType = MimeTypeUtil.getMimeType(resource, "");
        return pattern.matcher(mimeType).matches();
    }

    public static String getMimeType(Resource resource, String defaultValue) {
        MimeType mimeType = MimeTypeUtil.getMimeType(resource);
        return mimeType != null ? mimeType.toString() : defaultValue;
    }

    public static String getMimeType(String name, Property property, String defaultValue) {
        MimeType mimeType = MimeTypeUtil.getMimeType(name, property);
        return mimeType != null ? mimeType.toString() : defaultValue;
    }

    public static MimeType getMimeType(Resource resource) {
        ResourceHandle handle;
        MimeType result = null;
        if (resource != null && (result = MimeTypeUtil.getMimeType((handle = ResourceHandle.use(resource)).getProperty("jcr:mimeType", ""))) == null) {
            String name = resource.getName();
            if ("jcr:content".equals(name)) {
                result = MimeTypeUtil.getParentMimeType(resource);
            } else {
                result = MimeTypeUtil.getContentMimeType(resource);
                if (result == null) {
                    String filename = MimeTypeUtil.getResourceName(resource);
                    result = MimeTypeUtil.getMimeType(filename);
                }
            }
        }
        return result;
    }

    private static MimeType getParentMimeType(Resource resource) {
        ResourceHandle handle;
        MimeType result = null;
        if (resource != null && (resource = resource.getParent()) != null && (result = MimeTypeUtil.getMimeType((handle = ResourceHandle.use(resource)).getProperty("jcr:mimeType", ""))) == null) {
            String filename = MimeTypeUtil.getResourceName(resource);
            result = MimeTypeUtil.getMimeType(filename);
        }
        return result;
    }

    private static MimeType getContentMimeType(Resource resource) {
        MimeType result = null;
        if (resource != null && (resource = resource.getChild("jcr:content")) != null) {
            ResourceHandle handle = ResourceHandle.use(resource);
            result = MimeTypeUtil.getMimeType(handle.getProperty("jcr:mimeType", ""));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeType getMimeType(String name, Property property) {
        MimeType result;
        block15: {
            result = null;
            try {
                Binary binary;
                Binary binary2 = binary = property != null ? property.getBinary() : null;
                if (binary == null) break block15;
                try {
                    InputStream input = binary.getStream();
                    try {
                        MediaType mediaType = MimeTypeUtil.getMediaType(input, name);
                        if (mediaType != null) {
                            try {
                                result = MimeTypeUtil.getMimeTypes().forName(mediaType.toString());
                            }
                            catch (MimeTypeException mimeTypeException) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        try {
                            input.close();
                        }
                        catch (IOException ioex) {
                            LOG.error(ioex.toString());
                        }
                    }
                }
                finally {
                    binary.dispose();
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.toString());
            }
        }
        return result;
    }

    public static String getFilename(Resource resource, String extFallback) {
        String filename = MimeTypeUtil.getResourceName(resource);
        if (!HAS_FILE_EXT_PATTERN.matcher(filename).matches()) {
            String filenameEnd = null;
            MimeType mimeType = MimeTypeUtil.getMimeType(resource);
            if (mimeType != null) {
                String ext = mimeType.getExtension();
                if (StringUtils.isNotBlank((CharSequence)ext)) {
                    filenameEnd = ext;
                } else {
                    Matcher matcher = FILE_EXT_FROM_MIME.matcher(mimeType.toString());
                    if (matcher.matches()) {
                        filenameEnd = "." + matcher.group(1);
                    }
                }
            }
            if (StringUtils.isBlank(filenameEnd) && StringUtils.isNotBlank((CharSequence)extFallback)) {
                filenameEnd = "." + extFallback;
            }
            if (StringUtils.isNotBlank(filenameEnd) && !filename.toLowerCase().endsWith(filenameEnd.toLowerCase())) {
                filename = filename + filenameEnd;
            }
        }
        return filename;
    }

    public static String getResourceName(Resource resource) {
        String result = null;
        if (resource != null) {
            String name = resource.getName();
            result = "jcr:content".equals(name) ? MimeTypeUtil.getResourceName(resource.getParent()) : name;
        }
        return result;
    }

    public static MimeType getMimeType(String value) {
        block5: {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                try {
                    return MimeTypeUtil.getMimeTypes().forName(value);
                }
                catch (MimeTypeException e) {
                    MediaType mediaType = MimeTypeUtil.getMediaType(null, value);
                    if (mediaType == null) break block5;
                    try {
                        return MimeTypeUtil.getMimeTypes().forName(mediaType.toString());
                    }
                    catch (MimeTypeException mimeTypeException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static MediaType getMediaType(InputStream input, String filename) {
        MediaType result = null;
        Metadata metaData = new Metadata();
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            metaData.set("resourceName", filename);
        }
        MimeTypes mimeTypes = MimeTypeUtil.getMimeTypes();
        try {
            result = mimeTypes.detect(null, metaData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static MimeTypes getMimeTypes() {
        if (mimeTypes == null) {
            mimeTypes = MimeTypes.getDefaultMimeTypes();
        }
        return mimeTypes;
    }
}

