/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.user;

import com.composum.sling.core.AbstractSlingBean;
import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.ResourceUtil;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;

@Restricted(key="nodes/users/profile")
public class UserProfile
extends AbstractSlingBean {
    public static final String SERVICE_KEY = "nodes/users/profile";
    public static final String PN_GENDER = "gender";
    public static final String PN_TITLE = "title";
    public static final String PN_GIVEN_NAME = "givenName";
    public static final String PN_FAMILY_NAME = "familyName";
    public static final String PN_JOB_TITLE = "jobTitle";
    public static final String PN_EMAIL = "email";
    public static final String PN_PHONE_NUMBER = "phoneNumber";
    public static final String PN_STREET = "street";
    public static final String PN_POSTAL_CODE = "postalCode";
    public static final String PN_CITY = "city";
    public static final String PN_COUNTRY = "country";
    public static final String PN_ABOUT = "aboutMe";
    public static final String NN_PROFILE = "profile";
    public static final String USERS_ROOT = "/home/";
    protected boolean allowed;
    protected ValueMap values;
    private transient String name;
    private transient String address;

    public UserProfile(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public UserProfile(BeanContext context) {
        super(context);
    }

    public UserProfile() {
    }

    @Override
    public void initialize(BeanContext context, Resource resource) {
        this.allowed = context.getService(ServiceRestrictions.class).isPermissible(context.getRequest(), new ServiceRestrictions.Key(SERVICE_KEY), ServiceRestrictions.Permission.read);
        if (this.allowed) {
            String suffix;
            String path = resource.getPath();
            if (!path.startsWith(USERS_ROOT) && StringUtils.isNotBlank((CharSequence)(suffix = context.getRequest().getRequestPathInfo().getSuffix())) && suffix.startsWith(USERS_ROOT)) {
                resource = context.getResolver().resolve(suffix);
                path = resource.getPath();
            }
            if (!path.endsWith("/profile")) {
                resource = context.getResolver().resolve(path + "/" + NN_PROFILE);
            }
            super.initialize(context, resource);
            this.values = resource.getValueMap();
        } else {
            this.values = new ValueMapDecorator(Collections.emptyMap());
        }
    }

    @NotNull
    public ValueMap getValues() {
        return this.values;
    }

    public boolean isValid() {
        return this.allowed && !ResourceUtil.isSyntheticResource((Resource)this.resource) && !ResourceUtil.isNonExistingResource((Resource)this.resource);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.name == null) {
            StringBuilder builder = new StringBuilder();
            String value = (String)this.values.get(PN_TITLE, String.class);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                builder.append(value);
            }
            if (StringUtils.isNotBlank((CharSequence)(value = (String)this.values.get(PN_GIVEN_NAME, String.class)))) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(value);
            }
            if (StringUtils.isNotBlank((CharSequence)(value = (String)this.values.get(PN_FAMILY_NAME, String.class)))) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(value);
            }
            this.name = builder.toString();
        }
        return this.name;
    }

    @NotNull
    public String getEmail() {
        return (String)this.values.get(PN_EMAIL, (Object)"");
    }

    @NotNull
    public String getPhoneNumber() {
        return (String)this.values.get(PN_PHONE_NUMBER, (Object)"");
    }

    @NotNull
    public String getAddress() {
        if (this.address == null) {
            StringBuilder builder = new StringBuilder();
            String value = (String)this.values.get(PN_STREET, String.class);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                builder.append(value);
            }
            if (StringUtils.isNotBlank((CharSequence)(value = (String)this.values.get(PN_POSTAL_CODE, String.class)))) {
                if (builder.length() > 0) {
                    builder.append("<br/>");
                }
                builder.append(value);
                value = (String)this.values.get(PN_CITY, String.class);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    builder.append(' ').append(value);
                }
            } else {
                value = (String)this.values.get(PN_CITY, String.class);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    if (builder.length() > 0) {
                        builder.append("<br/>");
                    }
                    builder.append(value);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(value = (String)this.values.get(PN_COUNTRY, String.class)))) {
                if (builder.length() > 0) {
                    builder.append("<br/>");
                }
                builder.append(value);
            }
            this.address = builder.toString();
        }
        return this.address;
    }

    @NotNull
    public String getAbout() {
        return (String)this.values.get(PN_ABOUT, (Object)"");
    }
}

