/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.SlingResourceUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletOperationSet<E extends Enum<?>, O extends Enum<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(ServletOperationSet.class);
    protected Map<Method, Map<E, O>> operationDefaults = new HashMap<Method, Map<E, O>>();
    protected Map<Method, Map<E, Map<O, ServletOperation>>> operationMap = new HashMap<Method, Map<E, Map<O, ServletOperation>>>();
    protected final E defaultExtension;

    public ServletOperationSet(E defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public ServletOperation getOperation(SlingHttpServletRequest request, Method method) {
        Map<O, ServletOperation> operations;
        Map<E, Map<O, ServletOperation>> extensions;
        Enum defaultOperation;
        ServletOperation operation = null;
        E extension = RequestUtil.getExtension(request, this.defaultExtension);
        Map<E, O> extensionDefaults = this.operationDefaults.get((Object)method);
        if (extensionDefaults != null && (defaultOperation = (Enum)extensionDefaults.get(extension)) != null && (extensions = this.operationMap.get((Object)method)) != null && (operations = extensions.get(extension)) != null) {
            operation = operations.get(RequestUtil.getSelector(request, defaultOperation));
        }
        return operation;
    }

    public void setOperation(Method method, E extension, O operation, ServletOperation implementation) {
        this.setOperation(method, extension, operation, implementation, false);
    }

    public void setOperation(Method method, E extension, O operation, ServletOperation implementation, boolean isDefault) {
        Map extensions = this.operationMap.computeIfAbsent(method, k -> new HashMap());
        Map operations = extensions.computeIfAbsent(extension, k -> new HashMap());
        if (implementation != null) {
            operations.put(operation, implementation);
        } else {
            operations.remove(operation);
        }
        if (isDefault || this.getDefaultOperation(method, extension) == null) {
            this.setDefaultOperation(method, extension, operation);
        }
    }

    public O getDefaultOperation(Method method, E extension) {
        Enum operation = null;
        Map<E, O> extensions = this.operationDefaults.get((Object)method);
        if (extensions != null) {
            operation = (Enum)extensions.get(extension);
        }
        return (O)operation;
    }

    public void setDefaultOperation(Method method, E extension, O operation) {
        Map extensions = this.operationDefaults.computeIfAbsent(method, k -> new HashMap());
        if (operation != null) {
            extensions.put(extension, operation);
        } else {
            extensions.remove(extension);
        }
    }

    protected ResourceHandle getResource(SlingHttpServletRequest request) {
        return AbstractServiceServlet.getResource(request);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block5: {
            ServletOperation operation = this.getOperation(request, Method.GET);
            if (operation != null) {
                try {
                    ResourceHandle resource = this.getResource(request);
                    LOG.debug("Calling GET {} for {} with {}", (Object)operation.getClass().getSimpleName(), (Object)SlingResourceUtil.getPath((Resource)resource));
                    operation.doIt(request, response, resource);
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    if (response.isCommitted()) {
                        ServletOutputStream log = response.getOutputStream();
                        log.write(ex.toString().getBytes(MappingRules.CHARSET));
                        break block5;
                    }
                    response.sendError(400, ex.toString());
                }
            } else {
                this.sendInvalidOperation(request, response, Method.GET);
            }
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block5: {
            ServletOperation operation = this.getOperation(request, Method.POST);
            if (operation != null) {
                try {
                    ResourceHandle resource = this.getResource(request);
                    LOG.debug("Calling POST {} with {}", (Object)operation.getClass().getSimpleName(), (Object)SlingResourceUtil.getPath((Resource)resource));
                    operation.doIt(request, response, resource);
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    if (response.isCommitted()) {
                        ServletOutputStream log = response.getOutputStream();
                        log.write(ex.toString().getBytes(MappingRules.CHARSET));
                        break block5;
                    }
                    response.sendError(400, ex.toString());
                }
            } else {
                this.sendInvalidOperation(request, response, Method.POST);
            }
        }
    }

    protected void doPut(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block5: {
            ServletOperation operation = this.getOperation(request, Method.PUT);
            if (operation != null) {
                try {
                    ResourceHandle resource = this.getResource(request);
                    LOG.debug("Calling PUT {} with {}", (Object)operation.getClass().getSimpleName(), (Object)SlingResourceUtil.getPath((Resource)resource));
                    operation.doIt(request, response, resource);
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    if (response.isCommitted()) {
                        ServletOutputStream log = response.getOutputStream();
                        log.write(ex.toString().getBytes(MappingRules.CHARSET));
                        break block5;
                    }
                    response.sendError(400, ex.toString());
                }
            } else {
                this.sendInvalidOperation(request, response, Method.PUT);
            }
        }
    }

    protected void doDelete(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block5: {
            ServletOperation operation = this.getOperation(request, Method.DELETE);
            if (operation != null) {
                try {
                    ResourceHandle resource = this.getResource(request);
                    LOG.debug("Calling DELETE {} with {}", (Object)operation.getClass().getSimpleName(), (Object)SlingResourceUtil.getPath((Resource)resource));
                    operation.doIt(request, response, resource);
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    if (response.isCommitted()) {
                        ServletOutputStream log = response.getOutputStream();
                        log.write(ex.toString().getBytes(MappingRules.CHARSET));
                        break block5;
                    }
                    response.sendError(400, ex.toString());
                }
            } else {
                this.sendInvalidOperation(request, response, Method.DELETE);
            }
        }
    }

    public void sendInvalidOperation(SlingHttpServletRequest request, SlingHttpServletResponse response, Method method) throws IOException {
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String message = "invalid operation '" + method.name() + ":" + pathInfo.getSelectorString() + "." + pathInfo.getExtension() + "'";
        try {
            throw new Exception(message);
        }
        catch (Exception ex) {
            LOG.error(message, (Throwable)ex);
            response.sendError(400, message);
            return;
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

