/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.service.impl;

import com.composum.sling.core.service.ServiceRestrictions;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"service.description=Composum Service Restrictions POST Filter", "sling.filter.scope=REQUEST"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=Config.class)
public class PostServletRestrictionsFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(PostServletRestrictionsFilter.class);
    @Reference
    private ServiceRestrictions restrictions;
    private Config config;
    private final Map<Pattern, ServiceRestrictions.Key> restrictedPaths = new LinkedHashMap<Pattern, ServiceRestrictions.Key>();

    @Activate
    @Modified
    public final void activate(Config config) {
        this.config = config;
        this.restrictedPaths.clear();
        for (String rule : config.restictedPaths()) {
            String[] keyVal = StringUtils.split((String)rule, (String)"=", (int)2);
            if (keyVal.length != 2 || !StringUtils.isNotBlank((CharSequence)keyVal[0]) || !StringUtils.isNotBlank((CharSequence)keyVal[1])) continue;
            this.restrictedPaths.put(Pattern.compile(keyVal[0]), new ServiceRestrictions.Key(keyVal[1]));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest request;
        if (this.config.enabled() && this.restrictedPaths.size() > 0 && servletRequest instanceof SlingHttpServletRequest && "POST".equals((request = (SlingHttpServletRequest)servletRequest).getMethod())) {
            String path = request.getResource().getPath();
            for (Map.Entry<Pattern, ServiceRestrictions.Key> entry : this.restrictedPaths.entrySet()) {
                if (!entry.getKey().matcher(path).matches() || this.restrictions.isPermissible(request, entry.getValue(), ServiceRestrictions.Permission.write)) continue;
                SlingHttpServletResponse response = (SlingHttpServletResponse)servletResponse;
                LOG.warn("POST request to {} denied due to restrictions for service {}", (Object)path, (Object)entry.getValue());
                response.sendError(405);
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    @ObjectClassDefinition(name="Composum Service Restrictions POST Filter Configuration")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="the on/off switch for the Restrictions Filter (default: true)")
        public boolean enabled() default true;

        @AttributeDefinition(name="Path Restrictions", description="the mapping of repository path patterns to service keys (e.g. '^/content(/.*)?$=pages/content/edit')")
        public String[] restictedPaths() default {};

        @AttributeDefinition(name="Service Ranking", description="the ranking of the service to place the servlet filter at the right place in the filter chain")
        public int service_ranking() default 2600;
    }
}

