/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.service.impl;

import com.composum.sling.core.service.PathReferencesService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.description=Composum Nodes Path References Service"})
public class PathReferencesServiceImpl
implements PathReferencesService {
    @Override
    @NotNull
    public PathReferencesService.HitIterator findReferences(@NotNull ResourceResolver resolver, @NotNull PathReferencesService.Options options, @NotNull String searchRoot, @NotNull String path) {
        boolean searchRelative;
        String relPath;
        while (searchRoot.endsWith("/")) {
            searchRoot = searchRoot.substring(0, searchRoot.length() - 1);
        }
        if (StringUtils.isBlank((CharSequence)searchRoot)) {
            throw new IllegalArgumentException("repository root used as search root");
        }
        path = path.replace('*', '%');
        String basePath = options.getBasePath().replace('*', '%');
        String absPath = PathReferencesServiceImpl.absPath(basePath, relPath = PathReferencesServiceImpl.relPath(basePath, path));
        String withoutQueryChars = absPath.replaceAll("[%]", "");
        if (StringUtils.isBlank((CharSequence)withoutQueryChars) || "/".equals(withoutQueryChars)) {
            throw new IllegalArgumentException("path is empty or the repository root path");
        }
        String primaryType = options.getPrimaryType();
        String contentPath = options.getContentPath();
        String resourceName = options.getResourceName();
        String resourceType = options.getResourceType();
        String propertyName = options.getPropertyName();
        propertyName = StringUtils.isBlank((CharSequence)propertyName) ? "*" : "@" + propertyName;
        StringBuilder queryBuilder = new StringBuilder("/jcr:root");
        queryBuilder.append(searchRoot).append("//");
        if (StringUtils.isNotBlank((CharSequence)primaryType)) {
            queryBuilder.append("element(").append(StringUtils.isNotBlank((CharSequence)resourceName) ? resourceName : "*").append(",").append(primaryType).append(")");
        } else {
            queryBuilder.append(StringUtils.isNotBlank((CharSequence)resourceName) ? resourceName : "*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentPath)) {
            queryBuilder.append(contentPath.startsWith("/") ? contentPath : "/" + contentPath);
        }
        queryBuilder.append("[");
        int brackets = 0;
        if (StringUtils.isNotBlank((CharSequence)resourceType)) {
            queryBuilder.append("@sling:resourceType='").append(resourceType).append("' and (");
            ++brackets;
        }
        boolean bl = searchRelative = options.isUseRelativePath() && !relPath.startsWith("/");
        if (options.isUseTextSearch()) {
            queryBuilder.append("jcr:contains(").append(propertyName.startsWith("@") ? propertyName : ".").append(",'").append(searchRelative ? relPath : absPath).append("')");
        } else {
            if (options.isUseAbsolutePath() || !searchRelative) {
                this.addPathExpression(options, queryBuilder, propertyName, absPath);
            }
            if (searchRelative) {
                if (options.isUseAbsolutePath()) {
                    queryBuilder.append(" or ");
                }
                this.addPathExpression(options, queryBuilder, propertyName, relPath);
            }
        }
        while (--brackets >= 0) {
            queryBuilder.append(")");
        }
        queryBuilder.append("]");
        String queryString = queryBuilder.toString();
        try {
            Iterator result = resolver.findResources(queryString, "xpath");
            return new HitIteratorImpl(options, queryString, absPath, relPath, result);
        }
        catch (Exception ex) {
            return new HitIteratorImpl(options, queryString, absPath, relPath, ex);
        }
    }

    protected void addPathExpression(@NotNull PathReferencesService.Options options, @NotNull StringBuilder queryBuilder, @NotNull String propertyName, @NotNull String path) {
        if (!options.isChildrenOnly()) {
            if (!path.contains("%")) {
                queryBuilder.append("./").append(propertyName).append("='").append(path).append("'");
            } else {
                queryBuilder.append("jcr:like(./").append(propertyName).append(",'").append(path).append("')");
            }
            if (options.isFindRichText()) {
                queryBuilder.append(" or jcr:like(./").append(propertyName).append(",'%=\"").append(path).append("\"%')");
            }
        }
        if (options.isIncludeChildren() || options.isChildrenOnly()) {
            if (!options.isChildrenOnly()) {
                queryBuilder.append(" or ");
            }
            queryBuilder.append("jcr:like(./").append(propertyName).append(",'").append(path).append("/%')");
            if (options.isFindRichText()) {
                queryBuilder.append(" or jcr:like(./").append(propertyName).append(",'%=\"").append(path).append("/%')");
            }
        }
    }

    @Override
    public void changeReferences(@NotNull ResourceResolver resolver, @NotNull PathReferencesService.Hit hit, @NotNull String newPath) {
        ModifiableValueMap modifiable = (ModifiableValueMap)hit.getResource().adaptTo(ModifiableValueMap.class);
        if (modifiable != null) {
            for (PathReferencesService.Hit.Property property : hit.getProperties()) {
                String name = property.getName();
                Object current = modifiable.get((Object)name);
                if (current instanceof String) {
                    PathReferencesService.Hit.Property.Value value = property.getValue();
                    if (value == null) continue;
                    modifiable.put((Object)name, (Object)value.apply(newPath));
                    continue;
                }
                if (!(current instanceof String[])) continue;
                String[] values = (String[])current;
                String[] modified = Arrays.copyOf(values, values.length);
                for (PathReferencesService.Hit.Property.Value value : property.getValues()) {
                    int index = value.getIndex();
                    if (index >= modified.length) continue;
                    modified[index] = value.apply(newPath);
                }
                modifiable.put((Object)name, (Object)modified);
            }
        }
    }

    protected static void collectOccurrences(@NotNull List<String> collection, @NotNull String text, @NotNull String path, boolean includeChildren) {
        PathReferencesServiceImpl.collectOccurrences(collection, text, PathReferencesServiceImpl.propertyValuePattern(path, includeChildren));
        PathReferencesServiceImpl.collectOccurrences(collection, text, PathReferencesServiceImpl.richTextPattern(path, includeChildren));
    }

    protected static void collectOccurrences(@NotNull List<String> collection, @NotNull String text, @NotNull Pattern pattern) {
        Matcher matcher = pattern.matcher(text);
        int pos = 0;
        while (matcher.find(pos)) {
            collection.add(matcher.group("path"));
            pos = matcher.end();
        }
    }

    protected static Pattern richTextPattern(@NotNull String path, boolean includeChildren) {
        return Pattern.compile("(=[\"'])(?<path>" + path + (includeChildren ? "(/[^\"']+)?" : "") + ")([\"'])");
    }

    protected static Pattern propertyValuePattern(@NotNull String path, boolean includeChildren) {
        return Pattern.compile("^(?<path>" + path + (includeChildren ? "(/.+)?" : "") + ")$");
    }

    @NotNull
    protected static String relPath(@NotNull String basePath, @NotNull String path) {
        if (path.equals(basePath) || path.startsWith(basePath + "/")) {
            path = path.substring(basePath.length());
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    @NotNull
    protected static String absPath(@NotNull String basePath, @NotNull String relPath) {
        return relPath.startsWith("/") ? relPath : basePath + "/" + relPath;
    }

    protected static class HitIteratorImpl
    implements PathReferencesService.HitIterator {
        protected final PathReferencesService.Options options;
        protected final String queryString;
        protected final String absPath;
        protected final String relPath;
        protected final Iterator<Resource> searchResult;
        protected final Throwable throwable;
        protected IteratorHit next = null;

        public HitIteratorImpl(@NotNull PathReferencesService.Options options, @NotNull String queryString, @NotNull String absPath, @NotNull String relPath, @NotNull Iterator<Resource> searchResult) {
            this.options = options;
            this.queryString = queryString;
            this.absPath = absPath;
            this.relPath = relPath;
            this.searchResult = searchResult;
            this.throwable = null;
        }

        public HitIteratorImpl(@NotNull PathReferencesService.Options options, @NotNull String queryString, @NotNull String absPath, @NotNull String relPath, @NotNull Throwable throwable) {
            this.options = options;
            this.queryString = queryString;
            this.absPath = absPath;
            this.relPath = relPath;
            this.searchResult = Collections.emptyIterator();
            this.throwable = throwable;
        }

        @Nullable
        protected PathReferencesService.Hit loadNext() {
            while (this.next == null && this.searchResult.hasNext()) {
                IteratorHit hit = new IteratorHit(this.searchResult.next());
                if (hit.getPropertyMap().isEmpty()) continue;
                this.next = hit;
            }
            return this.next;
        }

        @Override
        public boolean hasNext() {
            return this.loadNext() != null;
        }

        @Override
        @Nullable
        public PathReferencesService.Hit next() {
            PathReferencesService.Hit result = this.loadNext();
            this.next = null;
            return result;
        }

        @NotNull
        public String getRelPath() {
            return this.relPath;
        }

        @NotNull
        public String getAbsPath() {
            return this.absPath;
        }

        @Override
        @NotNull
        public String getQueryString() {
            return this.queryString;
        }

        @Override
        @Nullable
        public Throwable getThrowable() {
            return this.throwable;
        }

        protected class IteratorHit
        implements PathReferencesService.Hit {
            protected Resource resource;
            private transient Map<String, PathReferencesService.Hit.Property> propertyMap;

            public IteratorHit(Resource resource) {
                this.resource = resource;
            }

            @Override
            @NotNull
            public Resource getResource() {
                return this.resource;
            }

            @NotNull
            protected Map<String, PathReferencesService.Hit.Property> getPropertyMap() {
                if (this.propertyMap == null) {
                    this.propertyMap = new HashMap<String, PathReferencesService.Hit.Property>();
                    ValueMap resourceValues = this.resource.getValueMap();
                    String propertyName = HitIteratorImpl.this.options.getPropertyName();
                    if (StringUtils.isBlank((CharSequence)propertyName)) {
                        for (Map.Entry entry : resourceValues.entrySet()) {
                            HitProperty property;
                            String key = (String)entry.getKey();
                            Object value = entry.getValue();
                            if (value instanceof String) {
                                String string = (String)value;
                                if (!this.isMatchingValue(string)) continue;
                                this.propertyMap.put(key, new HitProperty(key, string));
                                continue;
                            }
                            if (!(value instanceof String[]) || (property = this.extractMatchingValues(key, (String[])value)).isEmpty()) continue;
                            this.propertyMap.put(key, property);
                        }
                    } else {
                        HitProperty property;
                        Object value = resourceValues.get((Object)propertyName);
                        if (value instanceof String) {
                            if (this.isMatchingValue((String)value)) {
                                this.propertyMap.put(propertyName, new HitProperty(propertyName, (String)value));
                            }
                        } else if (value instanceof String[] && !(property = this.extractMatchingValues(propertyName, (String[])value)).isEmpty()) {
                            this.propertyMap.put(propertyName, property);
                        }
                    }
                }
                return this.propertyMap;
            }

            @NotNull
            protected HitProperty extractMatchingValues(@NotNull String key, @NotNull String[] value) {
                HitProperty property = new HitProperty(key);
                for (int i = 0; i < value.length; ++i) {
                    if (!this.isMatchingValue(value[i])) continue;
                    property.addValue(value[i], i);
                }
                return property;
            }

            protected boolean isMatchingValue(@NotNull String value) {
                boolean searchRelative = HitIteratorImpl.this.options.isUseRelativePath() && !HitIteratorImpl.this.getRelPath().startsWith("/");
                return (HitIteratorImpl.this.options.isUseAbsolutePath() || !searchRelative) && this.isMatchingValue(value, HitIteratorImpl.this.getAbsPath()) || searchRelative && this.isMatchingValue(value, HitIteratorImpl.this.getRelPath());
            }

            protected boolean isMatchingValue(@NotNull String value, @NotNull String path) {
                return this.isMatchingVal(value, path) || HitIteratorImpl.this.options.isFindRichText() && this.isMatchingText(value, path);
            }

            protected boolean isMatchingVal(@NotNull String value, @NotNull String path) {
                return HitIteratorImpl.this.options.isChildrenOnly() ? value.startsWith(path + "/") : value.equals(path) || HitIteratorImpl.this.options.isIncludeChildren() && value.startsWith(path + "/");
            }

            protected boolean isMatchingText(@NotNull String value, @NotNull String path) {
                return (HitIteratorImpl.this.options.isChildrenOnly() || HitIteratorImpl.this.options.isIncludeChildren()) && value.contains("=\"" + path + "/") || !HitIteratorImpl.this.options.isChildrenOnly() && value.contains("=\"" + path + "\"");
            }

            @Override
            @NotNull
            public Iterable<PathReferencesService.Hit.Property> getProperties() {
                return this.getPropertyMap().values();
            }

            @Override
            @NotNull
            public Set<String> getPropertyNames() {
                return this.getPropertyMap().keySet();
            }

            @Override
            @Nullable
            public PathReferencesService.Hit.Property getProperty(@NotNull String propertyName) {
                return this.getPropertyMap().get(propertyName);
            }

            @Override
            @Nullable
            public PathReferencesService.Hit.Property getProperty() {
                Map<String, PathReferencesService.Hit.Property> props = this.getPropertyMap();
                return props.isEmpty() ? null : props.values().iterator().next();
            }

            @Override
            @Nullable
            public PathReferencesService.Hit.Property.Value getValue() {
                PathReferencesService.Hit.Property property = this.getProperty();
                return property != null ? property.getValue() : null;
            }

            @Override
            public boolean isRichText() {
                Map<String, PathReferencesService.Hit.Property> props = this.getPropertyMap();
                return !props.isEmpty() && props.values().iterator().next().isRichText();
            }

            protected class HitProperty
            implements PathReferencesService.Hit.Property {
                protected final String name;
                protected final List<PathReferencesService.Hit.Property.Value> value = new ArrayList<PathReferencesService.Hit.Property.Value>();
                protected final boolean multi;
                private transient Boolean richText;

                public HitProperty(String name) {
                    this.name = name;
                    this.multi = true;
                }

                public HitProperty(@NotNull String name, String value) {
                    this.name = name;
                    this.multi = false;
                    this.addValue(value, 0);
                }

                public boolean isEmpty() {
                    return this.value.isEmpty();
                }

                @Override
                @NotNull
                public String getName() {
                    return this.name;
                }

                @Override
                @Nullable
                public PathReferencesService.Hit.Property.Value getValue() {
                    return this.value.isEmpty() ? null : this.value.get(0);
                }

                @Override
                @NotNull
                public String getText() {
                    PathReferencesService.Hit.Property.Value value = this.getValue();
                    return value != null ? value.getText() : "";
                }

                @Override
                @NotNull
                public List<PathReferencesService.Hit.Property.Value> getValues() {
                    return this.value;
                }

                protected void addValue(@NotNull String value, int index) {
                    this.value.add(new HitValue(value, index));
                }

                @Override
                public boolean isMulti() {
                    return this.multi;
                }

                @Override
                public boolean isRichText() {
                    block1: {
                        PathReferencesService.Hit.Property.Value val;
                        if (this.richText != null) break block1;
                        this.richText = false;
                        Iterator<PathReferencesService.Hit.Property.Value> iterator = this.value.iterator();
                        while (iterator.hasNext() && !(this.richText = Boolean.valueOf((val = iterator.next()).isRichText())).booleanValue()) {
                        }
                    }
                    return this.richText;
                }

                protected class HitValue
                implements PathReferencesService.Hit.Property.Value {
                    @NotNull
                    protected final String text;
                    protected final int index;
                    private transient List<String> paths;
                    private transient Boolean absolute;
                    private transient Boolean relative;
                    private transient Boolean childPath;
                    private transient Boolean richText;

                    public HitValue(String text, int index) {
                        this.text = text;
                        this.index = index;
                    }

                    public String toString() {
                        return this.getText();
                    }

                    @Override
                    public int getIndex() {
                        return this.index;
                    }

                    @Override
                    @NotNull
                    public String apply(@NotNull String newPath) {
                        return this.isRichText() ? this.applyText(newPath) : this.applyVal(newPath);
                    }

                    @NotNull
                    protected String applyVal(@NotNull String newPath) {
                        String basePath = HitIteratorImpl.this.options.getBasePath();
                        String relPath = PathReferencesServiceImpl.relPath(basePath, newPath);
                        if (this.isAbsolute()) {
                            return this.getText().replaceAll("^" + HitIteratorImpl.this.absPath, PathReferencesServiceImpl.absPath(basePath, relPath));
                        }
                        return this.getText().replaceAll("^" + HitIteratorImpl.this.relPath, relPath);
                    }

                    @NotNull
                    protected String applyText(@NotNull String newPath) {
                        String basePath = HitIteratorImpl.this.options.getBasePath();
                        String relPath = PathReferencesServiceImpl.relPath(basePath, newPath);
                        if (this.isAbsolute()) {
                            return this.getText().replaceAll("^=\"" + HitIteratorImpl.this.absPath, "=\"" + PathReferencesServiceImpl.absPath(basePath, relPath));
                        }
                        return this.getText().replaceAll("^=\"" + HitIteratorImpl.this.relPath, "=\"" + relPath);
                    }

                    @Override
                    @NotNull
                    public String getText() {
                        return this.text;
                    }

                    @Override
                    @NotNull
                    public List<String> getPaths() {
                        if (this.paths == null) {
                            boolean includeChildren;
                            this.paths = new ArrayList<String>();
                            boolean bl = includeChildren = HitIteratorImpl.this.options.isIncludeChildren() || HitIteratorImpl.this.options.isChildrenOnly();
                            if (HitIteratorImpl.this.options.isUseAbsolutePath()) {
                                PathReferencesServiceImpl.collectOccurrences(this.paths, this.getText(), HitIteratorImpl.this.getAbsPath(), includeChildren);
                            }
                            if (HitIteratorImpl.this.options.isUseRelativePath()) {
                                PathReferencesServiceImpl.collectOccurrences(this.paths, this.getText(), HitIteratorImpl.this.getRelPath(), includeChildren);
                            }
                        }
                        return this.paths;
                    }

                    @Override
                    public boolean isAbsolute() {
                        if (this.absolute == null) {
                            this.absolute = false;
                            for (String path : this.getPaths()) {
                                if (!path.startsWith(HitIteratorImpl.this.getAbsPath())) continue;
                                this.absolute = true;
                                break;
                            }
                        }
                        return this.absolute;
                    }

                    @Override
                    public boolean isRelative() {
                        if (this.relative == null) {
                            this.relative = false;
                            for (String path : this.getPaths()) {
                                if (!path.startsWith(HitIteratorImpl.this.getRelPath())) continue;
                                this.relative = true;
                                break;
                            }
                        }
                        return this.relative;
                    }

                    @Override
                    public boolean isChildPath() {
                        if (this.childPath == null) {
                            this.childPath = false;
                            for (String path : this.getPaths()) {
                                if (path.equals(HitIteratorImpl.this.getAbsPath()) || path.equals(HitIteratorImpl.this.getRelPath())) continue;
                                this.childPath = true;
                                break;
                            }
                        }
                        return this.childPath;
                    }

                    @Override
                    public boolean isRichText() {
                        if (this.richText == null) {
                            this.richText = this.getText().contains("=\"");
                        }
                        return this.richText;
                    }
                }
            }
        }
    }
}

