/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.service.impl;

import com.composum.sling.core.service.TranslationService;
import com.composum.sling.core.util.I18N;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.description=Composum Nodes Translations Service"})
public class CoreTranslationService
implements TranslationService {
    protected static Gson gson = new GsonBuilder().create();

    @Override
    @NotNull
    public JsonElement translate(@NotNull SlingHttpServletRequest request, @NotNull JsonElement element) {
        if (element instanceof JsonObject) {
            JsonObject translated = new JsonObject();
            for (Map.Entry<String, JsonElement> entry : ((JsonObject)element).entrySet()) {
                translated.add(entry.getKey(), this.translate(request, entry.getValue()));
            }
            return translated;
        }
        if (element instanceof JsonArray) {
            JsonArray translated = new JsonArray();
            for (JsonElement entry : (JsonArray)element) {
                translated.add(this.translate(request, entry));
            }
            return translated;
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isString()) {
                primitive = new JsonPrimitive(I18N.get(request, primitive.getAsString()));
            }
            return primitive;
        }
        return element;
    }

    @Override
    @NotNull
    public JsonElement translate(@NotNull SlingHttpServletRequest request, @NotNull Reader reader) {
        return this.translate(request, gson.fromJson(reader, JsonElement.class));
    }

    @Override
    public void translate(@NotNull SlingHttpServletRequest request, @NotNull Reader reader, @NotNull Writer writer) {
        JsonElement element = this.translate(request, reader);
        gson.toJson(element, (Appendable)writer);
    }
}

