/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.service;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PathReferencesService {
    @NotNull
    public HitIterator findReferences(@NotNull ResourceResolver var1, @NotNull Options var2, @NotNull String var3, @NotNull String var4);

    public void changeReferences(@NotNull ResourceResolver var1, @NotNull Hit var2, @NotNull String var3);

    public static interface HitIterator
    extends Iterator<Hit> {
        public String getQueryString();

        public Throwable getThrowable();
    }

    public static interface Hit {
        @NotNull
        public Resource getResource();

        @NotNull
        public Set<String> getPropertyNames();

        @NotNull
        public Iterable<Property> getProperties();

        @Nullable
        public Property getProperty(@NotNull String var1);

        @Nullable
        public Property getProperty();

        @Nullable
        public Property.Value getValue();

        public boolean isRichText();

        public static interface Property {
            @NotNull
            public String getName();

            @Nullable
            public Value getValue();

            @NotNull
            public String getText();

            @NotNull
            public List<Value> getValues();

            public boolean isMulti();

            public boolean isRichText();

            public static interface Value {
                public int getIndex();

                @NotNull
                public String apply(@NotNull String var1);

                @NotNull
                public String getText();

                @NotNull
                public List<String> getPaths();

                public boolean isAbsolute();

                public boolean isRelative();

                public boolean isChildPath();

                public boolean isRichText();
            }
        }
    }

    public static class Options {
        protected String basePath = "";
        protected String primaryType = null;
        protected String contentPath = null;
        protected String resourceName = null;
        protected String resourceType = null;
        protected String propertyName = null;
        protected boolean useTextSearch = true;
        protected boolean useAbsolutePath = true;
        protected boolean useRelativePath = false;
        protected boolean includeChildren = false;
        protected boolean childrenOnly = false;
        protected boolean findRichText = false;

        @NotNull
        public String getBasePath() {
            return this.basePath;
        }

        @Nullable
        public String getPrimaryType() {
            return this.primaryType;
        }

        @Nullable
        public String getContentPath() {
            return this.contentPath;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isUseTextSearch() {
            return this.useTextSearch;
        }

        public boolean isUseAbsolutePath() {
            return this.useAbsolutePath;
        }

        public boolean isUseRelativePath() {
            return this.useRelativePath;
        }

        public boolean isIncludeChildren() {
            return this.includeChildren;
        }

        public boolean isChildrenOnly() {
            return this.childrenOnly;
        }

        public boolean isFindRichText() {
            return this.findRichText;
        }

        public Options basePath(@NotNull String path) {
            this.basePath = path;
            while (this.basePath.endsWith("/")) {
                this.basePath = this.basePath.substring(0, this.basePath.length() - 1);
            }
            return this;
        }

        public Options primaryType(@NotNull String name) {
            this.primaryType = name;
            return this;
        }

        public Options contentPath(@NotNull String name) {
            this.contentPath = name;
            return this;
        }

        public Options resourceName(@NotNull String name) {
            this.resourceName = name;
            return this;
        }

        public Options resourceType(@NotNull String name) {
            this.resourceType = name;
            return this;
        }

        public Options propertyName(@NotNull String name) {
            String string = this.propertyName = "*".equals(name) ? "" : name;
            if (this.propertyName.startsWith("@")) {
                this.propertyName = this.propertyName.substring(1);
            }
            return this;
        }

        public Options useTextSearch(boolean flag) {
            this.useTextSearch = flag;
            return this;
        }

        public Options useAbsolutePath(boolean flag) {
            this.useAbsolutePath = flag;
            return this;
        }

        public Options useRelativePath(boolean flag) {
            this.useRelativePath = flag;
            return this;
        }

        public Options includeChildren(boolean flag) {
            this.includeChildren = flag;
            return this;
        }

        public Options childrenOnly(boolean flag) {
            this.childrenOnly = flag;
            return this;
        }

        public Options findRichText(boolean flag) {
            this.findRichText = flag;
            return this;
        }
    }
}

