/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.proxy;

import com.composum.sling.core.Restricted;
import com.composum.sling.core.proxy.GenericProxyService;
import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="core/proxy/generic")
@Component(service={Servlet.class}, property={"service.description=Composum Generic Proxy Servlet", "sling.servlet.paths=/bin/cpm/proxy", "sling.servlet.extensions=fwd", "sling.servlet.methods=GET"})
public class GenericProxyServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(GenericProxyServlet.class);
    public static final String SERVICE_KEY = "core/proxy/generic";
    public static final Pattern EXTERNAL_SUFFIX = Pattern.compile("^/https?://", 2);
    protected List<GenericProxyService> instances = Collections.synchronizedList(new ArrayList());

    @Reference(service=GenericProxyService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void addProxyService(@NotNull GenericProxyService service) {
        LOG.info("addProxyService: {}", (Object)service.getName());
        this.instances.add(service);
    }

    protected void removeProxyService(@NotNull GenericProxyService service) {
        LOG.info("removeProxyService: {}", (Object)service.getName());
        this.instances.remove(service);
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String targetSuffix = XSS.filter(pathInfo.getSuffix());
        if (StringUtils.isNotBlank((CharSequence)targetSuffix)) {
            String targetUrl = EXTERNAL_SUFFIX.matcher(targetSuffix).find() ? targetSuffix.substring(1) : targetSuffix;
            String queryString = request.getQueryString();
            if (StringUtils.isNotBlank((CharSequence)queryString)) {
                targetUrl = targetUrl + "?" + queryString;
            }
            for (GenericProxyService service : this.instances) {
                if (!service.doProxy(request, response, targetUrl)) continue;
                return;
            }
        }
        response.sendError(404);
    }
}

