/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.filter;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeFilters {
    private static final Logger LOG = LoggerFactory.getLogger(NodeTypeFilters.class);
    public static final String NODE_TYPE_PREFIX = "node:";
    public static final String TYPE_ORDERABLE = "node:orderable";
    public static Map<String, NodeTypeFilter> TYPE_FILTER_SET = new HashMap<String, NodeTypeFilter>();

    public static boolean accept(Resource resource, String type) {
        try {
            Node node;
            NodeTypeFilter filter;
            if (resource != null && (filter = TYPE_FILTER_SET.get(type)) != null && (node = (Node)resource.adaptTo(Node.class)) != null) {
                NodeType[] mixins;
                if (NodeTypeFilters.accept(filter, node.getPrimaryNodeType())) {
                    return true;
                }
                for (NodeType mixinType : mixins = node.getMixinNodeTypes()) {
                    if (!NodeTypeFilters.accept(filter, mixinType)) continue;
                    return true;
                }
            }
        }
        catch (RepositoryException rex) {
            LOG.error(rex.getMessage(), (Throwable)rex);
        }
        return false;
    }

    protected static boolean accept(NodeTypeFilter filter, NodeType nodeType) {
        if (nodeType != null) {
            NodeType[] supertypes;
            if (filter.accept(nodeType)) {
                return true;
            }
            for (NodeType superType : supertypes = nodeType.getDeclaredSupertypes()) {
                if (!NodeTypeFilters.accept(filter, superType)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        TYPE_FILTER_SET.put(TYPE_ORDERABLE, new OrderableTypeFilter());
    }

    public static class OrderableTypeFilter
    implements NodeTypeFilter {
        @Override
        public boolean accept(NodeType type) {
            return type.hasOrderableChildNodes();
        }
    }

    public static interface NodeTypeFilter {
        public boolean accept(NodeType var1);
    }
}

