/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.servlet;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(service={Servlet.class}, property={"sling.servlet.paths=/bin/cpm/nodes/debug/clientlibgraph", "sling.servlet.methods=GET", "sling.auth.requirements=/bin/cpm/nodes/debug/clientlibgraph"})
public class DebugClientlibGraphServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DebugClientlibGraphServlet.class);
    public static final String SERVLET_PATH = "/bin/cpm/nodes/debug/clientlibgraph";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            new ClientlibGrapher(request, response).run();
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private class ClientlibGrapher {
        private final PrintWriter w;
        private final SlingHttpServletRequest request;
        private final SlingHttpServletResponse response;
        private final ResourceResolver resolver;
        private final String type;
        private final boolean compressfolders;

        public ClientlibGrapher(@NotNull SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
            this.w = response.getWriter();
            this.request = request;
            this.response = response;
            this.resolver = request.getResourceResolver();
            RequestPathInfo pathInfo = request.getRequestPathInfo();
            this.type = pathInfo.getExtension();
            this.compressfolders = null == pathInfo.getSelectorString() || !pathInfo.getSelectorString().contains("folders");
        }

        public void run() throws RepositoryException {
            this.response.setContentType("text/plain");
            QueryManager querymanager = Objects.requireNonNull((Session)this.resolver.adaptTo(Session.class)).getWorkspace().getQueryManager();
            String statement = "//element(*)[sling:resourceType='composum/nodes/commons/clientlib']/" + this.type + "/..";
            NodeIterator clientlibs = querymanager.createQuery(statement, "xpath").execute().getNodes();
            ArrayList<Clientlib> libs = new ArrayList<Clientlib>();
            while (clientlibs.hasNext()) {
                libs.add(new Clientlib(Clientlib.Type.valueOf(this.type), this.resolver.getResource(clientlibs.nextNode().getPath())));
            }
            this.w.println("digraph \"clientlibs." + this.type + "\" {");
            for (Clientlib lib : libs) {
                String path = lib.getResourceFolder().resource.getPath();
                for (String cat : lib.getCategories()) {
                    this.e(cat, path, true);
                }
                ClientlibResourceFolder rf = lib.getResourceFolder();
                this.w.println("subgraph \"cluster_" + path + "\" {");
                this.w.println("label=" + this.q(path) + ";");
                this.n(path, null);
                this.w.println(this.q(path) + ";");
                this.childedges(rf, rf);
                this.w.println("}");
                this.references(rf, libs, rf);
                this.w.println();
            }
            this.w.println("}");
        }

        private void references(ClientlibResourceFolder rf, List<Clientlib> libs, ClientlibResourceFolder topfolder) {
            for (ClientlibRef clientlibRef : rf.getEmbedded()) {
                this.reference(rf, libs, clientlibRef, true, topfolder);
            }
            for (ClientlibRef clientlibRef : rf.getDependencies()) {
                this.reference(rf, libs, clientlibRef, false, topfolder);
            }
            for (ClientlibElement clientlibElement : rf.getChildren()) {
                if (!(clientlibElement instanceof ClientlibResourceFolder)) continue;
                this.references((ClientlibResourceFolder)clientlibElement, libs, topfolder);
            }
        }

        private void reference(ClientlibResourceFolder rf, List<Clientlib> libs, ClientlibRef ref, boolean embedded, ClientlibResourceFolder topfolder) {
            String path;
            String string = path = this.compressfolders ? topfolder.resource.getPath() : rf.resource.getPath();
            if (ref.isCategory()) {
                this.e(path, ref.category, embedded);
                return;
            }
            for (Clientlib lib : libs) {
                if (!ref.isSatisfiedby(lib.makeLink())) continue;
                this.e(path, lib.getResourceFolder().resource.getPath(), embedded);
                return;
            }
            Resource file = this.resolver.resolve(ref.path);
        }

        private void childedges(ClientlibResourceFolder rf, ClientlibResourceFolder topfolder) {
            String path = this.compressfolders ? topfolder.resource.getPath() : rf.resource.getPath();
            this.n(path, rf.resource.getName() + (rf.getExpanded() ? " (E)" : ""));
            for (ClientlibElement clientlibElement : rf.getChildren()) {
                if (clientlibElement instanceof ClientlibResourceFolder) {
                    ClientlibResourceFolder cf = (ClientlibResourceFolder)clientlibElement;
                    if (!this.compressfolders) {
                        this.e(path, cf.resource.getPath(), true);
                    }
                    this.childedges(cf, topfolder);
                    continue;
                }
                if (clientlibElement instanceof ClientlibFile) {
                    ClientlibFile clientlibFile = (ClientlibFile)clientlibElement;
                    continue;
                }
                this.e(path, "ERROR: Unknown child type " + clientlibElement, true);
            }
        }

        private void e(String n1, String n2, boolean embed) {
            this.w.println(this.q(n1) + " -> " + this.q(n2) + (embed ? "" : " [style=dashed]") + ";");
        }

        private void n(String path, String alias) {
            if (null == alias) {
                this.w.println(this.q(path) + ";");
            } else {
                this.w.println(this.q(path) + "[label=" + this.q(alias) + "];");
            }
        }

        private String q(String s) {
            return " \"" + s + "\" ";
        }
    }
}

