/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.servlet;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.clientlibs.servlet.AbstractClientlibServlet;
import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=composum/nodes/commons/clientlib", "sling.servlet.methods=HEAD", "sling.servlet.methods=GET", "sling.servlet.extensions=css", "sling.servlet.extensions=js"})
public class ClientlibServlet
extends AbstractClientlibServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ClientlibServlet.class);
    protected static final Pattern FILENAME_PATTERN = Pattern.compile("[^/]*+$");
    protected static final Pattern HASHSUFFIX_PATTERN = Pattern.compile("/?([0-9a-zA-Z_-]++)/" + FILENAME_PATTERN.pattern());
    @Reference
    protected ClientlibService service;
    @Reference
    protected ClientlibConfiguration configuration;

    @Override
    @NotNull
    protected ClientlibService getClientlibService() {
        return this.service;
    }

    @Override
    @NotNull
    protected ClientlibConfiguration.Config getConfig() {
        return this.configuration.getConfig();
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.serve(true, request, response);
    }

    protected void doHead(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.serve(false, request, response);
    }

    private void serve(boolean get, @NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException, ServletException {
        if (this.usefulRequest(request, response)) {
            try {
                RequestPathInfo pathInfo = request.getRequestPathInfo();
                String extension = pathInfo.getExtension();
                if (StringUtils.isNotBlank((CharSequence)extension)) {
                    String selectors = pathInfo.getSelectorString();
                    Clientlib.Type type = Clientlib.Type.valueOf(extension.toLowerCase());
                    String path = pathInfo.getResourcePath();
                    String hash = ClientlibServlet.parseHashFromSuffix(XSS.filter(pathInfo.getSuffix()));
                    ClientlibRef ref = new ClientlibRef(type, path, false, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("deliver: {} ({})", (Object)ref.path, (Object)request.getRequestURI());
                    }
                    this.deliverClientlib(get, request, response, ref, hash, this.isMinified(selectors));
                } else {
                    LOG.error("no extension found ({})", (Object)request.getRequestURL().toString());
                }
            }
            catch (RepositoryException ex) {
                throw new ServletException((Throwable)ex);
            }
        }
    }

    public static String makePath(String path, Clientlib.Type type, boolean minified, String hash) {
        StringBuilder builder = new StringBuilder(path);
        if (minified) {
            builder.append(".min");
        }
        if (!path.endsWith("." + type.name()) && type != Clientlib.Type.img && type != Clientlib.Type.link) {
            builder.append('.').append(type.name());
        }
        return ClientlibServlet.appendHashSuffix(builder.toString(), hash);
    }

    @Override
    protected String makeUri(boolean minified, ClientlibLink link) {
        return ClientlibServlet.makePath(link.path, link.type, minified, link.hash);
    }

    public static String appendHashSuffix(String url, String hash) {
        if (null == hash) {
            return url;
        }
        Matcher matcher = FILENAME_PATTERN.matcher(url);
        String fname = "";
        if (matcher.find()) {
            fname = matcher.group(0);
        }
        return url + "/" + hash + "/" + fname;
    }

    public static String parseHashFromSuffix(String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix)) {
            return null;
        }
        Matcher matcher = HASHSUFFIX_PATTERN.matcher(suffix);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        LOG.warn("Could not parse hash suffix {}", (Object)suffix);
        return null;
    }
}

